/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.generator.GenerateSQLContributor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.OpenHandler;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class OpenObjectConsoleHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        DBPDataSourceContainer ds = null;
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        List selectedObjects = NavigatorUtils.getSelectedObjects((ISelection)currentSelection);
        ArrayList<DBSEntity> entities = new ArrayList<DBSEntity>();
        for (DBSObject object : selectedObjects) {
            ds = object.getDataSource().getContainer();
            if (!(object instanceof DBSEntity)) continue;
            entities.add((DBSEntity)object);
        }
        GenerateSQLContributor.SQLGenerator<DBSEntity> generator = GenerateSQLContributor.SELECT_GENERATOR(entities, true);
        String title = "Query";
        if (entities.size() == 1) {
            title = DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)entities.get(0)), (DBPEvaluationContext)DBPEvaluationContext.DML);
        }
        try {
            this.openConsole(workbenchWindow, generator, ds, title, !entities.isEmpty(), currentSelection);
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Open console", "Can open SQL editor", (Throwable)e);
        }
        return null;
    }

    protected void openConsole(IWorkbenchWindow workbenchWindow, DBRRunnableWithResult<String> generator, DBPDataSourceContainer ds, String title, boolean doRun, ISelection currentSelection) throws Exception {
        UIUtils.runInUI((IRunnableContext)workbenchWindow, generator);
        String sql = CommonUtils.notEmpty((String)((String)generator.getResult()));
        IProject project = ds != null ? ds.getRegistry().getProject() : DBWorkbench.getPlatform().getProjectManager().getActiveProject();
        OpenHandler.checkProjectIsOpen(project);
        IFolder folder = OpenHandler.getCurrentScriptFolder(currentSelection);
        IFile scriptFile = SQLEditorUtils.createNewScript(project, folder, ds);
        FileEditorInput sqlInput = new FileEditorInput(scriptFile);
        final SQLEditor editor = (SQLEditor)workbenchWindow.getActivePage().openEditor((IEditorInput)sqlInput, SQLEditor.class.getName());
        if (editor != null) {
            editor.getDocument().set(sql);
            AbstractJob execJob = new AbstractJob("Execute SQL in console"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    int i = 0;
                    while (i < 100) {
                        if (editor.getExecutionContext() != null) break;
                        RuntimeUtils.pause((int)100);
                        ++i;
                    }
                    return Status.OK_STATUS;
                }
            };
            if (doRun) {
                execJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        UIUtils.syncExec(() -> editor.processSQL(false, false));
                    }
                });
            }
            execJob.schedule();
        }
    }
}

