/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class DeleteCurrentFileHandler
extends AbstractDataSourceHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = (IEditorPart)RuntimeUtils.getObjectAdapter((Object)HandlerUtil.getActivePart((ExecutionEvent)event), IEditorPart.class);
        if (editor == null) {
            log.error((Object)"No active SQL editor");
            return null;
        }
        IFile file = EditorUtils.getFileFromInput((IEditorInput)editor.getEditorInput());
        if (file == null) {
            DBWorkbench.getPlatformUI().showError("Rename", "Can't rename - no source file");
            return null;
        }
        if (UIUtils.confirmAction((String)SQLEditorMessages.editor_file_delete_confirm_delete_title, (String)NLS.bind((String)SQLEditorMessages.editor_file_delete_confirm_delete_text, (Object)file.getName()))) {
            try {
                file.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e1) {
                DBWorkbench.getPlatformUI().showError(SQLEditorMessages.editor_file_delete_error_title, NLS.bind((String)SQLEditorMessages.editor_file_delete_error_text, (Object)file.getName(), (Object)((Object)e1)));
            }
        }
        return null;
    }
}

