/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.editor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.erd.editor.ERDEditorPart;
import org.jkiss.dbeaver.ext.erd.model.DiagramLoader;
import org.jkiss.dbeaver.ext.erd.model.ERDObject;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.ext.erd.part.DiagramPart;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.AbstractLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class ERDEditorStandalone
extends ERDEditorPart
implements DBPContextProvider,
IResourceChangeListener {
    private static final Log log = Log.getLog(ERDEditorStandalone.class);

    @Override
    public void dispose() {
        super.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.loadDiagram(false);
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DiagramLoader.save(RuntimeUtils.makeMonitor((IProgressMonitor)monitor), this.getDiagramPart(), this.getDiagram(), false, buffer);
            IFile file = this.getEditorFile();
            file.setContents((InputStream)new ByteArrayInputStream(buffer.toByteArray()), true, true, monitor);
            this.getCommandStack().markSaveLocation();
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Save diagram", null, (Throwable)e);
        }
    }

    @Override
    protected synchronized void loadDiagram(boolean refreshMetadata) {
        if (this.diagramLoadingJob != null) {
            return;
        }
        this.diagramLoadingJob = LoadingJob.createService((ILoadService)new AbstractLoadService<EntityDiagram>("Load diagram '" + this.getEditorInput().getName() + "'"){

            public EntityDiagram evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    return ERDEditorStandalone.this.loadContentFromFile(monitor);
                }
                catch (DBException e) {
                    log.error((Object)e);
                    return null;
                }
            }

            public Object getFamily() {
                return ERDEditorStandalone.this;
            }
        }, this.progressControl.createLoadVisualizer());
        this.diagramLoadingJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ERDEditorStandalone.this.diagramLoadingJob = null;
            }
        });
        this.diagramLoadingJob.schedule();
        this.setPartName(this.getEditorInput().getName());
    }

    private EntityDiagram loadContentFromFile(DBRProgressMonitor progressMonitor) throws DBException {
        IFile file = this.getEditorFile();
        DiagramPart diagramPart = this.getDiagramPart();
        EntityDiagram entityDiagram = new EntityDiagram(this.getDecorator(), null, file.getName());
        entityDiagram.clear();
        entityDiagram.setLayoutManualAllowed(true);
        entityDiagram.setLayoutManualDesired(true);
        diagramPart.setModel(entityDiagram);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream fileContent = file.getContents();){
                DiagramLoader.load(progressMonitor, file.getProject(), diagramPart, fileContent);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)("Error loading ER diagram from '" + file.getName() + "'"), (Throwable)e);
        }
        return entityDiagram;
    }

    private IFile getEditorFile() {
        return EditorUtils.getFileFromInput((IEditorInput)this.getEditorInput());
    }

    public DBCExecutionContext getExecutionContext() {
        for (Object part : this.getViewer().getSelectedEditParts()) {
            ERDObject model;
            Object object;
            EditPart editPart = (EditPart)part;
            if (!(editPart.getModel() instanceof ERDObject) || !((object = (model = (ERDObject)editPart.getModel()).getObject()) instanceof DBSObject)) continue;
            DBSObject dbObject = (DBSObject)object;
            return DBUtils.getDefaultContext((DBSObject)dbObject, (boolean)true);
        }
        return null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        IFile file = this.getEditorFile();
        if ((delta = delta.findMember(file.getFullPath())) == null) {
            return;
        }
        if (delta.getKind() == 2) {
            if ((0x2000 & delta.getFlags()) != 0) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IFile newFile = workspace.getRoot().getFile(delta.getMovedToPath());
                this.setInput((IEditorInput)new FileEditorInput(newFile));
                this.setPartName(this.getEditorInput().getName());
            } else {
                UIUtils.asyncExec(() -> {
                    boolean bl = this.getSite().getWorkbenchWindow().getActivePage().closeEditor((IEditorPart)this, false);
                });
            }
        }
    }
}

