/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.dialogs;

import java.util.ResourceBundle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDCursor;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.QueryResultsDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.dialogs.ValueViewDialog;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.editors.data.AbstractDataEditor;

public class CursorViewDialog
extends ValueViewDialog
implements IResultSetContainer {
    private static final Log log = Log.getLog(CursorViewDialog.class);
    private DBDCursor value;
    private ResultSetViewer resultSetViewer;
    private CursorDataContainer dataContainer = new CursorDataContainer();
    private static boolean keepStatementOpenToggleState = false;

    public CursorViewDialog(IValueController valueController) {
        super(valueController);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        DBPPreferenceStore globalPreferenceStore;
        IValueController valueController = this.getValueController();
        this.value = (DBDCursor)valueController.getValue();
        Composite dialogGroup = (Composite)super.createDialogArea(parent);
        if (this.value != null && !(globalPreferenceStore = DBWorkbench.getPlatform().getPreferenceStore()).getBoolean("keep.statement.open")) {
            if (ConfirmationDialog.showConfirmDialog((ResourceBundle)ResourceBundle.getBundle("org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages"), (Shell)this.getShell(), (String)"keep_statement_open", (int)3, (Object[])new Object[0]) == 2) {
                IResultSetController rsv;
                globalPreferenceStore.setValue("keep.statement.open", true);
                if (valueController.getValueSite().getPart() instanceof IResultSetContainer && (rsv = ((IResultSetContainer)valueController.getValueSite().getPart()).getResultSetController()) != null) {
                    rsv.refresh();
                }
            }
            UIUtils.asyncExec(() -> {
                this.setReturnCode(1);
                this.close();
            });
        }
        this.resultSetViewer = new ResultSetViewer(dialogGroup, valueController.getValueSite(), this);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.grabExcessVerticalSpace = true;
        this.resultSetViewer.getControl().setLayoutData((Object)gd);
        this.resultSetViewer.refresh();
        return dialogGroup;
    }

    @Override
    public Object extractEditorValue() {
        return null;
    }

    @Override
    public Control getControl() {
        return this.resultSetViewer == null ? null : this.resultSetViewer.getControl();
    }

    @Override
    public void primeEditorValue(@Nullable Object value) throws DBException {
        this.resultSetViewer.refresh();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isDirty() {
        return this.resultSetViewer.isDirty();
    }

    @Override
    public void setDirty(boolean dirty) {
    }

    @Override
    public DBCExecutionContext getExecutionContext() {
        return this.getValueController().getExecutionContext();
    }

    @Override
    @Nullable
    public ResultSetViewer getResultSetController() {
        return this.resultSetViewer;
    }

    @Override
    @Nullable
    public DBSDataContainer getDataContainer() {
        return this.dataContainer;
    }

    @Override
    public boolean isReadyToRun() {
        return true;
    }

    @Override
    public void openNewContainer(DBRProgressMonitor monitor, DBSDataContainer dataContainer, DBDDataFilter newFilter) {
        DBNDatabaseNode targetNode = this.getExecutionContext().getDataSource().getContainer().getPlatform().getNavigatorModel().getNodeByObject(monitor, (DBSObject)dataContainer, false);
        if (targetNode == null) {
            UIUtils.showMessageBox(null, (String)"Open link", (String)("Can't navigate to '" + DBUtils.getObjectFullName((DBPNamedObject)dataContainer, (DBPEvaluationContext)DBPEvaluationContext.UI) + "' - navigator node not found"), (int)1);
            return;
        }
        AbstractDataEditor.openNewDataEditor(targetNode, newFilter);
    }

    @Override
    public IResultSetDecorator createResultSetDecorator() {
        return new QueryResultsDecorator();
    }

    private class CursorDataContainer
    implements DBSDataContainer {
        private CursorDataContainer() {
        }

        public int getSupportedFeatures() {
            return 0;
        }

        @NotNull
        public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
            DBCStatistics statistics = new DBCStatistics();
            DBRProgressMonitor monitor = session.getProgressMonitor();
            DBDCursor dbResult = CursorViewDialog.this.value;
            try {
                long rowCount;
                long startTime = System.currentTimeMillis();
                dataReceiver.fetchStart(session, (DBCResultSet)dbResult, firstRow, maxRows);
                try {
                    rowCount = 0L;
                    while (dbResult.nextRow()) {
                        if (monitor.isCanceled()) {
                            break;
                        }
                        dataReceiver.fetchRow(session, (DBCResultSet)dbResult);
                        if (++rowCount >= maxRows) {
                            break;
                        }
                        if (rowCount % 100L != 0L) continue;
                        monitor.subTask(String.valueOf(rowCount) + ResultSetMessages.dialog_cursor_view_monitor_rows_fetched);
                        monitor.worked(100);
                    }
                }
                finally {
                    try {
                        dataReceiver.fetchEnd(session, (DBCResultSet)dbResult);
                    }
                    catch (DBCException e) {
                        log.error((Object)"Error while finishing result set fetch", (Throwable)e);
                    }
                }
                statistics.setFetchTime(System.currentTimeMillis() - startTime);
                statistics.setRowsFetched(rowCount);
                DBCStatistics dBCStatistics = statistics;
                return dBCStatistics;
            }
            finally {
                dataReceiver.close();
            }
        }

        public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, DBDDataFilter dataFilter, long flags) {
            return -1L;
        }

        @Nullable
        public String getDescription() {
            return CursorViewDialog.this.value.toString();
        }

        public DBSObject getParentObject() {
            return null;
        }

        @NotNull
        public DBPDataSource getDataSource() {
            IValueController valueController = CursorViewDialog.this.getValueController();
            return valueController == null ? null : valueController.getExecutionContext().getDataSource();
        }

        @NotNull
        public String getName() {
            return CursorViewDialog.this.value.toString();
        }

        public boolean isPersisted() {
            return false;
        }
    }
}

