/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreMaterializedView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreView;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructureAssistant;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.utils.CommonUtils;

public class PostgreStructureAssistant
extends JDBCStructureAssistant {
    private final PostgreDataSource dataSource;

    public PostgreStructureAssistant(PostgreDataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected JDBCDataSource getDataSource() {
        return this.dataSource;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_CONSTRAINT, RelationalObjectType.TYPE_PROCEDURE, RelationalObjectType.TYPE_TABLE_COLUMN, RelationalObjectType.TYPE_DATA_TYPE};
    }

    public DBSObjectType[] getHyperlinkObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_PROCEDURE};
    }

    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_PROCEDURE};
    }

    protected void findObjectsByMask(JDBCSession session, DBSObjectType objectType, DBSObject parentObject, String objectNameMask, boolean caseSensitive, boolean globalSearch, int maxResults, List<DBSObjectReference> references) throws DBException, SQLException {
        PostgreSchema ownerSchema = parentObject instanceof PostgreSchema ? (PostgreSchema)parentObject : null;
        PostgreDataSource dataSource = (PostgreDataSource)session.getDataSource();
        PostgreDatabase database = dataSource.getDefaultInstance();
        ArrayList<PostgreSchema> nsList = new ArrayList<PostgreSchema>();
        if (ownerSchema != null) {
            nsList.add(0, ownerSchema);
        } else if (!globalSearch) {
            for (String sn : database.getSearchPath()) {
                PostgreSchema schema = database.getSchema(session.getProgressMonitor(), sn);
                if (schema == null) continue;
                nsList.add(schema);
            }
            PostgreSchema pgCatalog = database.getCatalogSchema(session.getProgressMonitor());
            if (pgCatalog != null) {
                nsList.add(pgCatalog);
            }
        } else {
            DBSObjectFilter schemaFilter = dataSource.getContainer().getObjectFilter(PostgreSchema.class, (DBSObject)database, true);
            if (schemaFilter != null && schemaFilter.isEnabled()) {
                for (PostgreSchema schema : database.getSchemas(session.getProgressMonitor())) {
                    if (!schemaFilter.matches(schema.getName())) continue;
                    nsList.add(schema);
                }
            }
        }
        if (objectType == RelationalObjectType.TYPE_TABLE) {
            this.findTablesByMask(session, nsList, objectNameMask, caseSensitive, maxResults, references);
        } else if (objectType == RelationalObjectType.TYPE_CONSTRAINT) {
            this.findConstraintsByMask(session, nsList, objectNameMask, caseSensitive, maxResults, references);
        } else if (objectType == RelationalObjectType.TYPE_PROCEDURE) {
            this.findProceduresByMask(session, nsList, objectNameMask, caseSensitive, maxResults, references);
        } else if (objectType == RelationalObjectType.TYPE_TABLE_COLUMN) {
            this.findTableColumnsByMask(session, nsList, objectNameMask, caseSensitive, maxResults, references);
        } else if (objectType == RelationalObjectType.TYPE_DATA_TYPE) {
            this.findDataTypesByMask(session, nsList, objectNameMask, caseSensitive, maxResults, references);
        }
    }

    private void findTablesByMask(JDBCSession session, @Nullable List<PostgreSchema> schema, String tableNameMask, boolean caseSensitive, int maxResults, List<DBSObjectReference> objects) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT x.oid,x.relname,x.relnamespace,x.relkind FROM pg_catalog.pg_class x WHERE x.relkind in('r','v','m') AND x.relname " + (caseSensitive ? "LIKE" : "ILIKE") + " ? " + (CommonUtils.isEmpty(schema) ? "" : " AND x.relnamespace IN (" + SQLUtils.generateParamList((int)schema.size()) + ")") + " ORDER BY x.relname LIMIT " + maxResults);){
            dbStat.setString(1, tableNameMask);
            if (!CommonUtils.isEmpty(schema)) {
                PostgreUtils.setArrayParameter(dbStat, 2, schema);
            }
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                int tableNum = maxResults;
                while (dbResult.next() && tableNum-- > 0) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    long schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"relnamespace");
                    final long tableId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
                    final String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relname");
                    PostgreClass.RelKind tableType = PostgreClass.RelKind.valueOf(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relkind"));
                    final PostgreSchema tableSchema = this.dataSource.getDefaultInstance().getSchema(session.getProgressMonitor(), schemaId);
                    if (tableSchema == null) {
                        log.debug((Object)("Can't resolve table '" + tableName + "' - owner schema " + schemaId + " not found"));
                        continue;
                    }
                    objects.add((DBSObjectReference)new AbstractObjectReference(tableName, tableSchema, null, tableType == PostgreClass.RelKind.r ? PostgreTable.class : (tableType == PostgreClass.RelKind.v ? PostgreView.class : PostgreMaterializedView.class), RelationalObjectType.TYPE_TABLE){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            PostgreTableBase table = tableSchema.getTable(monitor, tableId);
                            if (table == null) {
                                throw new DBException("Table '" + tableName + "' not found in schema '" + tableSchema.getName() + "'");
                            }
                            return table;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findProceduresByMask(JDBCSession session, @Nullable List<PostgreSchema> schema, String procNameMask, boolean caseSensitive, int maxResults, List<DBSObjectReference> objects) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT DISTINCT x.oid,x.proname,x.pronamespace FROM pg_catalog.pg_proc x WHERE x.proname " + (caseSensitive ? "LIKE" : "ILIKE") + " ? " + "AND x.proname NOT LIKE '\\_%'" + (CommonUtils.isEmpty(schema) ? "" : " AND x.pronamespace IN (" + SQLUtils.generateParamList((int)schema.size()) + ")") + " ORDER BY x.proname LIMIT " + maxResults);){
            dbStat.setString(1, procNameMask);
            if (!CommonUtils.isEmpty(schema)) {
                PostgreUtils.setArrayParameter(dbStat, 2, schema);
            }
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                int tableNum = maxResults;
                while (dbResult.next() && tableNum-- > 0) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    long schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"pronamespace");
                    final String procName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"proname");
                    final long procId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
                    final PostgreSchema procSchema = this.dataSource.getDefaultInstance().getSchema(session.getProgressMonitor(), schemaId);
                    if (procSchema == null) {
                        log.debug((Object)("Procedure's schema '" + schemaId + "' not found"));
                        continue;
                    }
                    objects.add((DBSObjectReference)new AbstractObjectReference(procName, procSchema, null, PostgreProcedure.class, RelationalObjectType.TYPE_PROCEDURE){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            PostgreProcedure procedure = procSchema.getProcedure(monitor, procId);
                            if (procedure == null) {
                                throw new DBException("Procedure '" + procName + "' not found in schema '" + procSchema.getName() + "'");
                            }
                            return procedure;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findConstraintsByMask(JDBCSession session, @Nullable List<PostgreSchema> schema, String constrNameMask, boolean caseSensitive, int maxResults, List<DBSObjectReference> objects) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT x.oid,x.conname,x.connamespace FROM pg_catalog.pg_constraint x WHERE x.conname " + (caseSensitive ? "LIKE" : "ILIKE") + " ? " + (CommonUtils.isEmpty(schema) ? "" : " AND x.connamespace IN (" + SQLUtils.generateParamList((int)schema.size()) + ")") + " ORDER BY x.conname LIMIT " + maxResults);){
            dbStat.setString(1, constrNameMask);
            if (!CommonUtils.isEmpty(schema)) {
                PostgreUtils.setArrayParameter(dbStat, 2, schema);
            }
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                int tableNum = maxResults;
                while (dbResult.next() && tableNum-- > 0) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    long schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"connamespace");
                    final long constrId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
                    final String constrName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"conname");
                    final PostgreSchema constrSchema = this.dataSource.getDefaultInstance().getSchema(session.getProgressMonitor(), schemaId);
                    if (constrSchema == null) {
                        log.debug((Object)("Constraint's schema '" + schemaId + "' not found"));
                        continue;
                    }
                    objects.add((DBSObjectReference)new AbstractObjectReference(constrName, constrSchema, null, PostgreTableConstraintBase.class, RelationalObjectType.TYPE_CONSTRAINT){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            PostgreTableConstraintBase constraint = (PostgreTableConstraintBase)PostgreUtils.getObjectById(monitor, constrSchema.constraintCache, constrSchema, constrId);
                            if (constraint == null) {
                                throw new DBException("Constraint '" + constrName + "' not found in schema '" + constrSchema.getName() + "'");
                            }
                            return constraint;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findTableColumnsByMask(JDBCSession session, @Nullable List<PostgreSchema> schema, String columnNameMask, boolean caseSensitive, int maxResults, List<DBSObjectReference> objects) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT x.attname,x.attrelid,x.atttypid,c.relnamespace FROM pg_catalog.pg_attribute x, pg_catalog.pg_class c\nWHERE c.oid=x.attrelid AND x.attname " + (caseSensitive ? "LIKE" : "ILIKE") + " ? " + (CommonUtils.isEmpty(schema) ? "" : " AND c.relnamespace IN (" + SQLUtils.generateParamList((int)schema.size()) + ")") + " ORDER BY x.attname LIMIT " + maxResults);){
            dbStat.setString(1, columnNameMask);
            if (!CommonUtils.isEmpty(schema)) {
                PostgreUtils.setArrayParameter(dbStat, 2, schema);
            }
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                int tableNum = maxResults;
                while (dbResult.next() && tableNum-- > 0) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    long schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"relnamespace");
                    final long tableId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"attrelid");
                    final String attributeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"attname");
                    final PostgreSchema constrSchema = this.dataSource.getDefaultInstance().getSchema(session.getProgressMonitor(), schemaId);
                    if (constrSchema == null) {
                        log.debug((Object)("Attribute's schema '" + schemaId + "' not found"));
                        continue;
                    }
                    objects.add((DBSObjectReference)new AbstractObjectReference(attributeName, constrSchema, null, PostgreTableBase.class, RelationalObjectType.TYPE_TABLE_COLUMN){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            PostgreTableBase table = (PostgreTableBase)PostgreUtils.getObjectById(monitor, constrSchema.tableCache, constrSchema, tableId);
                            if (table == null) {
                                throw new DBException("Table '" + tableId + "' not found in schema '" + constrSchema.getName() + "'");
                            }
                            return table.getAttribute(monitor, attributeName);
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findDataTypesByMask(JDBCSession session, List<PostgreSchema> catalog, String objectNameMask, boolean caseSensitive, int maxResults, List<DBSObjectReference> references) {
        session.getProgressMonitor();
    }
}

