/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.properties.tabbed.view;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.ui.internal.views.properties.tabbed.l10n.TabbedPropertyMessages;
import org.eclipse.ui.views.properties.tabbed.AbstractSectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.ITypeMapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class SectionDescriptor
extends AbstractSectionDescriptor {
    private static final String ATT_ID = "id";
    private static final String ATT_TARGET_TAB = "tab";
    private static final String ATT_AFTER_SECTION = "afterSection";
    private static final String ATT_CLASS = "class";
    private static final String ATT_SECTION_FILTER = "filter";
    private static final String ATT_SECTION_ENABLES_FOR = "enablesFor";
    private static final String ATT_INPUT_TYPE = "type";
    private static final String ELEMENT_INPUT = "input";
    private String id;
    private String targetTab;
    private String afterSection;
    private ArrayList inputTypes;
    private IFilter filter;
    private int enablesFor = -1;
    private IConfigurationElement configurationElement;

    protected SectionDescriptor(IConfigurationElement configurationElement, ITypeMapper typeMapper) {
        super(typeMapper);
        String enablesForStr;
        int enablesForTest;
        this.configurationElement = configurationElement;
        this.id = this.getConfigurationElement().getAttribute(ATT_ID);
        this.targetTab = this.getConfigurationElement().getAttribute(ATT_TARGET_TAB);
        this.afterSection = this.getConfigurationElement().getAttribute(ATT_AFTER_SECTION);
        if (this.getConfigurationElement().getAttribute(ATT_SECTION_ENABLES_FOR) != null && (enablesForTest = Integer.parseInt(enablesForStr = this.getConfigurationElement().getAttribute(ATT_SECTION_ENABLES_FOR))) > 0) {
            this.enablesFor = enablesForTest;
        }
        if (this.id == null || this.targetTab == null) {
            this.handleSectionError(null);
        }
    }

    private void handleSectionError(CoreException exception) {
        String pluginId = this.getConfigurationElement().getDeclaringExtension().getContributor().getName();
        String message = TabbedPropertyMessages.SectionDescriptor_Section_error;
        message = exception == null ? MessageFormat.format((String)TabbedPropertyMessages.SectionDescriptor_Section_error, (Object[])new Object[]{pluginId}) : MessageFormat.format((String)TabbedPropertyMessages.SectionDescriptor_class_not_found_error, (Object[])new Object[]{pluginId});
        Status status = new Status(4, pluginId, 2, message, (Throwable)exception);
        Bundle bundle = FrameworkUtil.getBundle(SectionDescriptor.class);
        Platform.getLog((Bundle)bundle).log((IStatus)status);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IFilter getFilter() {
        if (this.filter == null) {
            try {
                if (this.getConfigurationElement().getAttribute(ATT_SECTION_FILTER) != null) {
                    this.filter = (IFilter)this.configurationElement.createExecutableExtension(ATT_SECTION_FILTER);
                }
            }
            catch (CoreException exception) {
                this.handleSectionError(exception);
            }
        }
        return this.filter;
    }

    @Override
    public int getEnablesFor() {
        return this.enablesFor;
    }

    @Override
    public String getTargetTab() {
        return this.targetTab;
    }

    @Override
    public String getAfterSection() {
        if (this.afterSection == null) {
            return super.getAfterSection();
        }
        return this.afterSection;
    }

    @Override
    public ISection getSectionClass() {
        ISection section = null;
        try {
            section = (ISection)this.getConfigurationElement().createExecutableExtension(ATT_CLASS);
        }
        catch (CoreException exception) {
            this.handleSectionError(exception);
        }
        return section;
    }

    @Override
    public List getInputTypes() {
        if (this.inputTypes == null) {
            IConfigurationElement[] elements;
            this.inputTypes = new ArrayList();
            IConfigurationElement[] iConfigurationElementArray = elements = this.getConfigurationElement().getChildren(ELEMENT_INPUT);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                this.inputTypes.add(element.getAttribute(ATT_INPUT_TYPE));
                ++n2;
            }
        }
        return this.inputTypes;
    }

    public String toString() {
        return this.getId();
    }

    private IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }
}

