"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareCommitsView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../../atom/octicon"));

var _commitView = _interopRequireDefault(require("./commit-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCommitsView extends _react["default"].Component {
  render() {
    return _react["default"].createElement("div", {
      className: "timeline-item commits"
    }, this.renderSummary(), this.renderCommits());
  }

  renderSummary() {
    if (this.props.nodes.length > 1) {
      const namesString = this.calculateNames(this.props.nodes);
      return _react["default"].createElement("div", {
        className: "info-row"
      }, _react["default"].createElement(_octicon["default"], {
        className: "pre-timeline-item-icon",
        icon: "repo-push"
      }), _react["default"].createElement("span", {
        className: "comment-message-header"
      }, namesString, " added some commits..."));
    } else {
      return null;
    }
  }

  renderCommits() {
    return this.props.nodes.map(node => {
      return _react["default"].createElement(_commitView["default"], {
        key: node.id,
        commit: node,
        onBranch: this.props.onBranch,
        openCommit: this.props.openCommit
      });
    });
  }

  calculateNames(commits) {
    let names = new Set();
    commits.forEach(commit => {
      let name = null;

      if (commit.author.user) {
        name = commit.author.user.login;
      } else if (commit.author.name) {
        name = commit.author.name;
      }

      if (name && !names.has(name)) {
        names.add(name);
      }
    });
    names = Array.from(names);

    if (names.length === 1) {
      return names[0];
    } else if (names.length === 2) {
      return `${names[0]} and ${names[1]}`;
    } else if (names.length > 2) {
      return `${names[0]}, ${names[1]}, and others`;
    } else {
      return 'Someone';
    }
  }

}

exports.BareCommitsView = BareCommitsView;

_defineProperty(BareCommitsView, "propTypes", {
  nodes: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    author: _propTypes["default"].shape({
      name: _propTypes["default"].string,
      user: _propTypes["default"].shape({
        login: _propTypes["default"].string.isRequired
      })
    }).isRequired
  }).isRequired).isRequired,
  onBranch: _propTypes["default"].bool.isRequired,
  openCommit: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareCommitsView, {
  nodes: function () {
    const node = require("./__generated__/commitsView_nodes.graphql");

    if (node.hash && node.hash !== "e01f34cd74aa6d007049d5b421abe1ec") {
      console.error("The definition of 'commitsView_nodes' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/commitsView_nodes.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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