#pragma once
#include <ATen/Type.h>

namespace at {

struct CAFFE2_API TypeExtendedInterface : public Type {
  explicit TypeExtendedInterface(TensorTypeId type_id, bool is_variable, bool is_undefined)
      : Type(type_id, is_variable, is_undefined) {}
  virtual Tensor & _th_set_(Tensor & self, Storage source) const = 0;
  virtual Tensor & _th_set_(Tensor & self, Storage source, int64_t storage_offset, IntArrayRef size, IntArrayRef stride) const = 0;
  virtual Tensor & _th_set_(Tensor & self, const Tensor & source) const = 0;
  virtual Tensor & _th_set_(Tensor & self) const = 0;
  virtual Tensor & _th_fill_(Tensor & self, Scalar value) const = 0;
  virtual Tensor & _th_fill_(Tensor & self, const Tensor & value) const = 0;
  virtual bool _th_is_set_to(const Tensor & self, const Tensor & tensor) const = 0;
  virtual Tensor & s__th_masked_fill_(Tensor & self, const Tensor & mask, Scalar value) const = 0;
  virtual Tensor & _th_masked_fill_(Tensor & self, const Tensor & mask, Scalar value) const = 0;
  virtual Tensor & s__th_masked_fill_(Tensor & self, const Tensor & mask, const Tensor & value) const = 0;
  virtual Tensor & _th_masked_fill_(Tensor & self, const Tensor & mask, const Tensor & value) const = 0;
  virtual Tensor & s__th_masked_scatter_(Tensor & self, const Tensor & mask, const Tensor & source) const = 0;
  virtual Tensor & _th_masked_scatter_(Tensor & self, const Tensor & mask, const Tensor & source) const = 0;
  virtual Tensor & s__th_masked_select_out(Tensor & result, const Tensor & self, const Tensor & mask) const = 0;
  virtual Tensor & _th_masked_select_out(Tensor & result, const Tensor & self, const Tensor & mask) const = 0;
  virtual Tensor s__th_masked_select(const Tensor & self, const Tensor & mask) const = 0;
  virtual Tensor _th_masked_select(const Tensor & self, const Tensor & mask) const = 0;
  virtual Tensor & _th_nonzero_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_nonzero(const Tensor & self) const = 0;
  virtual Tensor _th_clone(const Tensor & self) const = 0;
  virtual Tensor _th_view(const Tensor & self, IntArrayRef size) const = 0;
  virtual Tensor & _th_resize_as_(Tensor & self, const Tensor & the_template) const = 0;
  virtual Tensor & _th_index_select_out(Tensor & result, const Tensor & self, int64_t dim, const Tensor & index) const = 0;
  virtual Tensor _th_index_select(const Tensor & self, int64_t dim, const Tensor & index) const = 0;
  virtual Tensor & _th_index_copy_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) const = 0;
  virtual Tensor & _th_take_out(Tensor & result, const Tensor & self, const Tensor & index) const = 0;
  virtual Tensor _th_take(const Tensor & self, const Tensor & index) const = 0;
  virtual Tensor & _th_put_(Tensor & self, const Tensor & index, const Tensor & source, bool accumulate) const = 0;
  virtual Tensor & _th_index_add_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) const = 0;
  virtual Tensor & _th_index_fill_(Tensor & self, int64_t dim, const Tensor & index, Scalar value) const = 0;
  virtual Tensor & _th_index_fill_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & value) const = 0;
  virtual Tensor & _th_unfold_out(Tensor & result, const Tensor & self, int64_t dimension, int64_t size, int64_t step) const = 0;
  virtual Tensor _th_unfold(const Tensor & self, int64_t dimension, int64_t size, int64_t step) const = 0;
  virtual Tensor & _th_scatter_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & src) const = 0;
  virtual Tensor & _th_scatter_(Tensor & self, int64_t dim, const Tensor & index, Scalar value) const = 0;
  virtual Tensor & _th_scatter_add_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & src) const = 0;
  virtual Tensor & _th_gather_out(Tensor & result, const Tensor & self, int64_t dim, const Tensor & index) const = 0;
  virtual Tensor _th_gather(const Tensor & self, int64_t dim, const Tensor & index) const = 0;
  virtual bool _th_equal(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_and_out(Tensor & result, const Tensor & self, Scalar other) const = 0;
  virtual Tensor _th_and(const Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_and_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_and_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor s__th_and(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor _th_and(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_iand_(Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_iand_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_iand_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_or_out(Tensor & result, const Tensor & self, Scalar other) const = 0;
  virtual Tensor _th_or(const Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_or_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_or_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor s__th_or(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor _th_or(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_ior_(Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_ior_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_ior_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_xor_out(Tensor & result, const Tensor & self, Scalar other) const = 0;
  virtual Tensor _th_xor(const Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_xor_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_xor_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor s__th_xor(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor _th_xor(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_ixor_(Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_ixor_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_ixor_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_lshift_out(Tensor & result, const Tensor & self, Scalar other) const = 0;
  virtual Tensor _th_lshift(const Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_lshift_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_lshift_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor s__th_lshift(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor _th_lshift(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_ilshift_(Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_ilshift_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_ilshift_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_rshift_out(Tensor & result, const Tensor & self, Scalar other) const = 0;
  virtual Tensor _th_rshift(const Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_rshift_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_rshift_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor s__th_rshift(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor _th_rshift(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_irshift_(Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_irshift_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_irshift_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_lt_out(Tensor & result, const Tensor & self, Scalar other) const = 0;
  virtual Tensor _th_lt(const Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_lt_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_lt_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor s__th_lt(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor _th_lt(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_lt_(Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_lt_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_lt_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_gt_out(Tensor & result, const Tensor & self, Scalar other) const = 0;
  virtual Tensor _th_gt(const Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_gt_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_gt_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor s__th_gt(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor _th_gt(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_gt_(Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_gt_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_gt_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_le_out(Tensor & result, const Tensor & self, Scalar other) const = 0;
  virtual Tensor _th_le(const Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_le_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_le_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor s__th_le(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor _th_le(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_le_(Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_le_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_le_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_ge_out(Tensor & result, const Tensor & self, Scalar other) const = 0;
  virtual Tensor _th_ge(const Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_ge_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_ge_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor s__th_ge(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor _th_ge(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_ge_(Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_ge_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_ge_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_eq_out(Tensor & result, const Tensor & self, Scalar other) const = 0;
  virtual Tensor _th_eq(const Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_eq_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_eq_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor s__th_eq(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor _th_eq(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_eq_(Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_eq_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_eq_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_ne_out(Tensor & result, const Tensor & self, Scalar other) const = 0;
  virtual Tensor _th_ne(const Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_ne_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_ne_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor s__th_ne(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor _th_ne(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_ne_(Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_ne_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_ne_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & s__th_min_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_min_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor s__th_min(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor _th_min(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor _th_min(const Tensor & self) const = 0;
  virtual std::tuple<Tensor &,Tensor &> _th_min_out(Tensor & min, Tensor & min_indices, const Tensor & self, int64_t dim, bool keepdim) const = 0;
  virtual std::tuple<Tensor,Tensor> _th_min(const Tensor & self, int64_t dim, bool keepdim) const = 0;
  virtual Tensor & s__th_max_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_max_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor s__th_max(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor _th_max(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor _th_max(const Tensor & self) const = 0;
  virtual std::tuple<Tensor &,Tensor &> _th_max_out(Tensor & max, Tensor & max_indices, const Tensor & self, int64_t dim, bool keepdim) const = 0;
  virtual std::tuple<Tensor,Tensor> _th_max(const Tensor & self, int64_t dim, bool keepdim) const = 0;
  virtual std::tuple<Tensor &,Tensor &> _th_mode_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim) const = 0;
  virtual std::tuple<Tensor,Tensor> _th_mode(const Tensor & self, int64_t dim, bool keepdim) const = 0;
  virtual std::tuple<Tensor &,Tensor &> _th_sort_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool descending) const = 0;
  virtual std::tuple<Tensor,Tensor> _th_sort(const Tensor & self, int64_t dim, bool descending) const = 0;
  virtual std::tuple<Tensor &,Tensor &> _th_topk_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted) const = 0;
  virtual std::tuple<Tensor,Tensor> _th_topk(const Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted) const = 0;
  virtual Tensor & _th_abs_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_abs(const Tensor & self) const = 0;
  virtual Tensor & _th_sigmoid_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_sigmoid(const Tensor & self) const = 0;
  virtual Tensor & _th_log_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_log(const Tensor & self) const = 0;
  virtual Tensor & _th_log10_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_log10(const Tensor & self) const = 0;
  virtual Tensor & _th_log1p_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_log1p(const Tensor & self) const = 0;
  virtual Tensor & _th_log2_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_log2(const Tensor & self) const = 0;
  virtual Tensor & _th_lgamma_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_lgamma(const Tensor & self) const = 0;
  virtual Tensor & _th_lgamma_(Tensor & self) const = 0;
  virtual Tensor & _th_digamma_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_digamma(const Tensor & self) const = 0;
  virtual Tensor & _th_digamma_(Tensor & self) const = 0;
  virtual Tensor & _th_polygamma_out(Tensor & result, int64_t n, const Tensor & self) const = 0;
  virtual Tensor _th_polygamma(int64_t n, const Tensor & self) const = 0;
  virtual Tensor & _th_polygamma_(Tensor & self, int64_t n) const = 0;
  virtual Tensor & _th_exp_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_exp(const Tensor & self) const = 0;
  virtual Tensor & _th_expm1_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_expm1(const Tensor & self) const = 0;
  virtual Tensor & _th_cos_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_cos(const Tensor & self) const = 0;
  virtual Tensor & _th_acos_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_acos(const Tensor & self) const = 0;
  virtual Tensor & _th_cosh_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_cosh(const Tensor & self) const = 0;
  virtual Tensor & _th_sin_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_sin(const Tensor & self) const = 0;
  virtual Tensor & _th_asin_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_asin(const Tensor & self) const = 0;
  virtual Tensor & _th_sinh_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_sinh(const Tensor & self) const = 0;
  virtual Tensor & _th_tan_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_tan(const Tensor & self) const = 0;
  virtual Tensor & _th_atan_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_atan(const Tensor & self) const = 0;
  virtual Tensor & _th_tanh_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_tanh(const Tensor & self) const = 0;
  virtual Tensor & _th_erf_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_erf(const Tensor & self) const = 0;
  virtual Tensor & _th_erfc_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_erfc(const Tensor & self) const = 0;
  virtual Tensor & _th_erfinv_(Tensor & self) const = 0;
  virtual Tensor & _th_erfinv_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_erfinv(const Tensor & self) const = 0;
  virtual Tensor & _th_sqrt_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_sqrt(const Tensor & self) const = 0;
  virtual Tensor & _th_rsqrt_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_rsqrt(const Tensor & self) const = 0;
  virtual Tensor & _th_ceil_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_ceil(const Tensor & self) const = 0;
  virtual Tensor & _th_floor_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_floor(const Tensor & self) const = 0;
  virtual Tensor & _th_round_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_round(const Tensor & self) const = 0;
  virtual Tensor & _th_trunc_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_trunc(const Tensor & self) const = 0;
  virtual Tensor & _th_frac_(Tensor & self) const = 0;
  virtual Tensor & _th_frac_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_frac(const Tensor & self) const = 0;
  virtual Tensor & _th_var_out(Tensor & result, const Tensor & self, int64_t dim, bool unbiased, bool keepdim) const = 0;
  virtual Tensor _th_var(const Tensor & self, int64_t dim, bool unbiased, bool keepdim) const = 0;
  virtual Tensor _th_var(const Tensor & self, bool unbiased) const = 0;
  virtual Tensor & _th_std_out(Tensor & result, const Tensor & self, int64_t dim, bool unbiased, bool keepdim) const = 0;
  virtual Tensor _th_std(const Tensor & self, int64_t dim, bool unbiased, bool keepdim) const = 0;
  virtual Tensor _th_std(const Tensor & self, bool unbiased) const = 0;
  virtual Tensor & _th_renorm_out(Tensor & result, const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const = 0;
  virtual Tensor _th_renorm(const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const = 0;
  virtual Tensor & _th_renorm_(Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const = 0;
  virtual Tensor s__th_dist(const Tensor & self, const Tensor & other, Scalar p) const = 0;
  virtual Tensor _th_dist(const Tensor & self, const Tensor & other, Scalar p) const = 0;
  virtual Tensor & _th_reciprocal_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_reciprocal(const Tensor & self) const = 0;
  virtual Tensor & _th_reciprocal_(Tensor & self) const = 0;
  virtual Tensor & _th_neg_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_neg(const Tensor & self) const = 0;
  virtual Tensor & _th_neg_(Tensor & self) const = 0;
  virtual Tensor & s__th_atan2_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_atan2_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor s__th_atan2(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor _th_atan2(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & s__th_atan2_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_atan2_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_pow_out(Tensor & result, const Tensor & self, Scalar exponent) const = 0;
  virtual Tensor _th_pow(const Tensor & self, Scalar exponent) const = 0;
  virtual Tensor & s__th_pow_out(Tensor & result, const Tensor & self, const Tensor & exponent) const = 0;
  virtual Tensor & _th_pow_out(Tensor & result, const Tensor & self, const Tensor & exponent) const = 0;
  virtual Tensor s__th_pow(const Tensor & self, const Tensor & exponent) const = 0;
  virtual Tensor _th_pow(const Tensor & self, const Tensor & exponent) const = 0;
  virtual Tensor & _th_pow_out(Tensor & result, Scalar self, const Tensor & exponent) const = 0;
  virtual Tensor _th_pow(Scalar self, const Tensor & exponent) const = 0;
  virtual Tensor & _th_pow_(Tensor & self, Scalar exponent) const = 0;
  virtual Tensor & s__th_pow_(Tensor & self, const Tensor & exponent) const = 0;
  virtual Tensor & _th_pow_(Tensor & self, const Tensor & exponent) const = 0;
  virtual Tensor & _th_histc_out(Tensor & result, const Tensor & self, int64_t bins, Scalar min, Scalar max) const = 0;
  virtual Tensor _th_histc(const Tensor & self, int64_t bins, Scalar min, Scalar max) const = 0;
  virtual Tensor & _th_zero_(Tensor & self) const = 0;
  virtual Tensor & _th_cumsum_out(Tensor & result, const Tensor & self, int64_t dim) const = 0;
  virtual Tensor _th_cumsum(const Tensor & self, int64_t dim) const = 0;
  virtual Tensor & _th_cumprod_out(Tensor & result, const Tensor & self, int64_t dim) const = 0;
  virtual Tensor _th_cumprod(const Tensor & self, int64_t dim) const = 0;
  virtual Tensor & _th_sign_out(Tensor & result, const Tensor & self) const = 0;
  virtual Tensor _th_sign(const Tensor & self) const = 0;
  virtual Tensor & _th_sign_(Tensor & self) const = 0;
  virtual Tensor _th_trace(const Tensor & self) const = 0;
  virtual Tensor & _th_fmod_out(Tensor & result, const Tensor & self, Scalar other) const = 0;
  virtual Tensor _th_fmod(const Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_fmod_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_fmod_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor s__th_fmod(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor _th_fmod(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_fmod_(Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_fmod_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_fmod_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_remainder_out(Tensor & result, const Tensor & self, Scalar other) const = 0;
  virtual Tensor _th_remainder(const Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_remainder_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_remainder_out(Tensor & result, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor s__th_remainder(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor _th_remainder(const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_remainder_(Tensor & self, Scalar other) const = 0;
  virtual Tensor & s__th_remainder_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_remainder_(Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _th_clamp_out(Tensor & result, const Tensor & self, Scalar min, Scalar max) const = 0;
  virtual Tensor _th_clamp(const Tensor & self, Scalar min, Scalar max) const = 0;
  virtual Tensor & _th_clamp_min_out(Tensor & result, const Tensor & self, Scalar min) const = 0;
  virtual Tensor _th_clamp_min(const Tensor & self, Scalar min) const = 0;
  virtual Tensor & _th_clamp_max_out(Tensor & result, const Tensor & self, Scalar max) const = 0;
  virtual Tensor _th_clamp_max(const Tensor & self, Scalar max) const = 0;
  virtual Tensor _th_dot(const Tensor & self, const Tensor & tensor) const = 0;
  virtual Tensor & _th_cross_kernel_out(Tensor & result, const Tensor & self, const Tensor & other, int64_t dim) const = 0;
  virtual Tensor _th_cross_kernel(const Tensor & self, const Tensor & other, int64_t dim) const = 0;
  virtual Tensor & _th_diag_out(Tensor & result, const Tensor & self, int64_t diagonal) const = 0;
  virtual Tensor _th_diag(const Tensor & self, int64_t diagonal) const = 0;
  virtual Tensor & s__th_addmm_out(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor & _th_addmm_out(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor s__th_addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor _th_addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor & _th_addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor & s__th_addmv_out(Tensor & result, const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor & _th_addmv_out(Tensor & result, const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor s__th_addmv(const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor _th_addmv(const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor & _th_addmv_(Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor & s__th_addr_out(Tensor & result, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor & _th_addr_out(Tensor & result, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor s__th_addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor _th_addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor & _th_addr_(Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor & _th_ger_out(Tensor & result, const Tensor & self, const Tensor & vec2) const = 0;
  virtual Tensor _th_ger(const Tensor & self, const Tensor & vec2) const = 0;
  virtual Tensor & _th_mv_out(Tensor & result, const Tensor & self, const Tensor & vec) const = 0;
  virtual Tensor _th_mv(const Tensor & self, const Tensor & vec) const = 0;
  virtual Tensor & _th_mm_out(Tensor & result, const Tensor & self, const Tensor & mat2) const = 0;
  virtual Tensor _th_mm(const Tensor & self, const Tensor & mat2) const = 0;
  virtual Tensor & _th_bmm_out(Tensor & result, const Tensor & self, const Tensor & mat2) const = 0;
  virtual Tensor _th_bmm(const Tensor & self, const Tensor & mat2) const = 0;
  virtual Tensor & s__th_addbmm_out(Tensor & result, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor & _th_addbmm_out(Tensor & result, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor s__th_addbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor _th_addbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor & _th_addbmm_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor & s__th_baddbmm_out(Tensor & result, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor & _th_baddbmm_out(Tensor & result, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor s__th_baddbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor _th_baddbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor & s__th_addcmul_out(Tensor & result, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const = 0;
  virtual Tensor & _th_addcmul_out(Tensor & result, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const = 0;
  virtual Tensor s__th_addcmul(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const = 0;
  virtual Tensor _th_addcmul(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const = 0;
  virtual Tensor & s__th_addcmul_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const = 0;
  virtual Tensor & _th_addcmul_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const = 0;
  virtual Tensor & s__th_addcdiv_out(Tensor & result, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const = 0;
  virtual Tensor & _th_addcdiv_out(Tensor & result, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const = 0;
  virtual Tensor s__th_addcdiv(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const = 0;
  virtual Tensor _th_addcdiv(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const = 0;
  virtual Tensor & s__th_addcdiv_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const = 0;
  virtual Tensor & _th_addcdiv_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const = 0;
  virtual std::tuple<Tensor &,Tensor &> _th_gels_out(Tensor & res1, Tensor & res2, const Tensor & self, const Tensor & A) const = 0;
  virtual std::tuple<Tensor,Tensor> _th_gels(const Tensor & self, const Tensor & A) const = 0;
  virtual std::tuple<Tensor &,Tensor &> _th_symeig_out(Tensor & res1, Tensor & res2, const Tensor & self, bool eigenvectors, bool upper) const = 0;
  virtual std::tuple<Tensor,Tensor> _th_symeig(const Tensor & self, bool eigenvectors, bool upper) const = 0;
  virtual std::tuple<Tensor &,Tensor &> _th_eig_out(Tensor & res1, Tensor & res2, const Tensor & self, bool eigenvectors) const = 0;
  virtual std::tuple<Tensor,Tensor> _th_eig(const Tensor & self, bool eigenvectors) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> _th_svd_out(Tensor & res1, Tensor & res2, Tensor & res3, const Tensor & self, bool some, bool compute_uv) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> _th_svd(const Tensor & self, bool some, bool compute_uv) const = 0;
  virtual Tensor & _th_getri_single_out(Tensor & output, const Tensor & self) const = 0;
  virtual Tensor _th_getri_single(const Tensor & self) const = 0;
  virtual Tensor & _th_potri_out(Tensor & output, const Tensor & self, bool upper) const = 0;
  virtual Tensor _th_potri(const Tensor & self, bool upper) const = 0;
  virtual std::tuple<Tensor &,Tensor &> _th_pstrf_out(Tensor & res1, Tensor & res2, const Tensor & self, bool upper, Scalar tol) const = 0;
  virtual std::tuple<Tensor,Tensor> _th_pstrf(const Tensor & self, bool upper, Scalar tol) const = 0;
  virtual std::tuple<Tensor &,Tensor &> _th_qr_out(Tensor & res1, Tensor & res2, const Tensor & self) const = 0;
  virtual std::tuple<Tensor,Tensor> _th_qr(const Tensor & self) const = 0;
  virtual std::tuple<Tensor &,Tensor &> _th_geqrf_out(Tensor & res1, Tensor & res2, const Tensor & self) const = 0;
  virtual std::tuple<Tensor,Tensor> _th_geqrf(const Tensor & self) const = 0;
  virtual Tensor & _th_orgqr_out(Tensor & result, const Tensor & self, const Tensor & input2) const = 0;
  virtual Tensor _th_orgqr(const Tensor & self, const Tensor & input2) const = 0;
  virtual Tensor & _th_ormqr_out(Tensor & result, const Tensor & self, const Tensor & input2, const Tensor & input3, bool left, bool transpose) const = 0;
  virtual Tensor _th_ormqr(const Tensor & self, const Tensor & input2, const Tensor & input3, bool left, bool transpose) const = 0;
  virtual Tensor & _th_btrisolve_out(Tensor & result, const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots) const = 0;
  virtual Tensor _th_btrisolve(const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots) const = 0;
  virtual Tensor & _th_random_(Tensor & self, int64_t from, int64_t to, Generator * generator) const = 0;
  virtual Tensor & _th_random_(Tensor & self, int64_t to, Generator * generator) const = 0;
  virtual Tensor & _th_random_(Tensor & self, Generator * generator) const = 0;
  virtual std::tuple<Tensor &,Tensor &> _th_multinomial_alias_setup_out(Tensor & J, Tensor & q, const Tensor & probs) const = 0;
  virtual std::tuple<Tensor,Tensor> _th_multinomial_alias_setup(const Tensor & probs) const = 0;
  virtual Tensor & _th_multinomial_alias_draw_out(Tensor & result, const Tensor & q, const Tensor & J, int64_t num_samples, Generator * generator) const = 0;
  virtual Tensor _th_multinomial_alias_draw(const Tensor & q, const Tensor & J, int64_t num_samples, Generator * generator) const = 0;
  virtual Tensor & _th_multinomial_out(Tensor & result, const Tensor & self, int64_t num_samples, bool replacement, Generator * generator) const = 0;
  virtual Tensor _th_multinomial(const Tensor & self, int64_t num_samples, bool replacement, Generator * generator) const = 0;
  virtual Tensor & _th_uniform_(Tensor & self, double from, double to, Generator * generator) const = 0;
  virtual Tensor & _th_normal_out(Tensor & output, const Tensor & mean, double std, Generator * generator) const = 0;
  virtual Tensor _th_normal(const Tensor & mean, double std, Generator * generator) const = 0;
  virtual Tensor & _th_normal_out(Tensor & output, double mean, const Tensor & std, Generator * generator) const = 0;
  virtual Tensor _th_normal(double mean, const Tensor & std, Generator * generator) const = 0;
  virtual Tensor & _th_normal_out(Tensor & output, const Tensor & mean, const Tensor & std, Generator * generator) const = 0;
  virtual Tensor _th_normal(const Tensor & mean, const Tensor & std, Generator * generator) const = 0;
  virtual Tensor & _th_normal_(Tensor & self, double mean, double std, Generator * generator) const = 0;
  virtual Tensor & _th_cauchy_(Tensor & self, double median, double sigma, Generator * generator) const = 0;
  virtual Tensor & _th_log_normal_(Tensor & self, double mean, double std, Generator * generator) const = 0;
  virtual Tensor & _th_exponential_(Tensor & self, double lambd, Generator * generator) const = 0;
  virtual Tensor & _th_geometric_(Tensor & self, double p, Generator * generator) const = 0;
  virtual Tensor & _th_dirichlet_grad_out(Tensor & output, const Tensor & x, const Tensor & alpha, const Tensor & total) const = 0;
  virtual Tensor _th_dirichlet_grad(const Tensor & x, const Tensor & alpha, const Tensor & total) const = 0;
  virtual Tensor _th_alias(const Tensor & self) const = 0;
  virtual Tensor & _th_copy_ignoring_overlaps_(Tensor & self, const Tensor & src) const = 0;
  virtual Tensor & _th_cat_out(Tensor & self, TensorList tensors, int64_t dim) const = 0;
  virtual Tensor _th_cat(TensorList tensors, int64_t dim) const = 0;
  virtual Tensor & _thnn_binary_cross_entropy_forward_out(Tensor & output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const = 0;
  virtual Tensor _thnn_binary_cross_entropy_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const = 0;
  virtual Tensor & _thnn_binary_cross_entropy_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const = 0;
  virtual Tensor _thnn_binary_cross_entropy_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const = 0;
  virtual Tensor & _thnn_l1_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor _thnn_l1_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor & _thnn_l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor _thnn_l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor & _thnn_mse_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor _thnn_mse_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor & _thnn_mse_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor _thnn_mse_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor & _thnn_multi_margin_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const = 0;
  virtual Tensor _thnn_multi_margin_loss_forward(const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const = 0;
  virtual Tensor & _thnn_multi_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const = 0;
  virtual Tensor _thnn_multi_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const = 0;
  virtual std::tuple<Tensor &,Tensor &> _thnn_multilabel_margin_loss_forward_out(Tensor & output, Tensor & is_target, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual std::tuple<Tensor,Tensor> _thnn_multilabel_margin_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor & _thnn_multilabel_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target) const = 0;
  virtual Tensor _thnn_multilabel_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target) const = 0;
  virtual std::tuple<Tensor &,Tensor &> _thnn_nll_loss_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const = 0;
  virtual std::tuple<Tensor,Tensor> _thnn_nll_loss_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const = 0;
  virtual Tensor & _thnn_nll_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const = 0;
  virtual Tensor _thnn_nll_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const = 0;
  virtual std::tuple<Tensor &,Tensor &> _thnn_nll_loss2d_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const = 0;
  virtual std::tuple<Tensor,Tensor> _thnn_nll_loss2d_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const = 0;
  virtual Tensor & _thnn_nll_loss2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const = 0;
  virtual Tensor _thnn_nll_loss2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const = 0;
  virtual Tensor & _thnn_smooth_l1_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor _thnn_smooth_l1_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor & _thnn_smooth_l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor _thnn_smooth_l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor & _thnn_soft_margin_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor _thnn_soft_margin_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor & _thnn_soft_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor _thnn_soft_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor & _thnn_elu_forward_out(Tensor & output, const Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale) const = 0;
  virtual Tensor _thnn_elu_forward(const Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale) const = 0;
  virtual Tensor & _thnn_elu_backward_out(Tensor & grad_input, const Tensor & grad_output, Scalar alpha, Scalar scale, Scalar input_scale, const Tensor & output) const = 0;
  virtual Tensor _thnn_elu_backward(const Tensor & grad_output, Scalar alpha, Scalar scale, Scalar input_scale, const Tensor & output) const = 0;
  virtual Tensor & _thnn_elu_(Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale) const = 0;
  virtual Tensor & _thnn_elu_forward_(Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale) const = 0;
  virtual Tensor & _thnn_glu_forward_out(Tensor & output, const Tensor & self, int64_t dim) const = 0;
  virtual Tensor _thnn_glu_forward(const Tensor & self, int64_t dim) const = 0;
  virtual Tensor & _thnn_glu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, int64_t dim) const = 0;
  virtual Tensor _thnn_glu_backward(const Tensor & grad_output, const Tensor & self, int64_t dim) const = 0;
  virtual Tensor & _thnn_hardtanh_forward_out(Tensor & output, const Tensor & self, Scalar min_val, Scalar max_val) const = 0;
  virtual Tensor _thnn_hardtanh_forward(const Tensor & self, Scalar min_val, Scalar max_val) const = 0;
  virtual Tensor & _thnn_hardtanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val) const = 0;
  virtual Tensor _thnn_hardtanh_backward(const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val) const = 0;
  virtual Tensor & _thnn_hardtanh_(Tensor & self, Scalar min_val, Scalar max_val) const = 0;
  virtual Tensor & _thnn_hardtanh_forward_(Tensor & self, Scalar min_val, Scalar max_val) const = 0;
  virtual Tensor & _thnn_leaky_relu_forward_out(Tensor & output, const Tensor & self, Scalar negative_slope) const = 0;
  virtual Tensor _thnn_leaky_relu_forward(const Tensor & self, Scalar negative_slope) const = 0;
  virtual Tensor & _thnn_leaky_relu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar negative_slope) const = 0;
  virtual Tensor _thnn_leaky_relu_backward(const Tensor & grad_output, const Tensor & self, Scalar negative_slope) const = 0;
  virtual Tensor & _thnn_leaky_relu_(Tensor & self, Scalar negative_slope) const = 0;
  virtual Tensor & _thnn_leaky_relu_forward_(Tensor & self, Scalar negative_slope) const = 0;
  virtual std::tuple<Tensor &,Tensor &> _thnn_log_sigmoid_forward_out(Tensor & output, Tensor & buffer, const Tensor & self) const = 0;
  virtual std::tuple<Tensor,Tensor> _thnn_log_sigmoid_forward(const Tensor & self) const = 0;
  virtual Tensor & _thnn_log_sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & buffer) const = 0;
  virtual Tensor _thnn_log_sigmoid_backward(const Tensor & grad_output, const Tensor & self, const Tensor & buffer) const = 0;
  virtual Tensor & _thnn_rrelu_with_noise_forward_out(Tensor & output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const = 0;
  virtual Tensor _thnn_rrelu_with_noise_forward(const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const = 0;
  virtual Tensor & _thnn_rrelu_with_noise_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training) const = 0;
  virtual Tensor _thnn_rrelu_with_noise_backward(const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training) const = 0;
  virtual Tensor & _thnn_rrelu_with_noise_(Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const = 0;
  virtual Tensor & _thnn_rrelu_with_noise_forward_(Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const = 0;
  virtual Tensor & _thnn_softplus_forward_out(Tensor & output, const Tensor & self, Scalar beta, Scalar threshold) const = 0;
  virtual Tensor _thnn_softplus_forward(const Tensor & self, Scalar beta, Scalar threshold) const = 0;
  virtual Tensor & _thnn_softplus_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output) const = 0;
  virtual Tensor _thnn_softplus_backward(const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output) const = 0;
  virtual Tensor & _thnn_softshrink_forward_out(Tensor & output, const Tensor & self, Scalar lambd) const = 0;
  virtual Tensor _thnn_softshrink_forward(const Tensor & self, Scalar lambd) const = 0;
  virtual Tensor & _thnn_softshrink_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar lambd) const = 0;
  virtual Tensor _thnn_softshrink_backward(const Tensor & grad_output, const Tensor & self, Scalar lambd) const = 0;
  virtual Tensor & _thnn_adaptive_avg_pool3d_forward_out(Tensor & output, const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor _thnn_adaptive_avg_pool3d_forward(const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor & _thnn_adaptive_avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self) const = 0;
  virtual Tensor _thnn_adaptive_avg_pool3d_backward(const Tensor & grad_output, const Tensor & self) const = 0;
  virtual Tensor & _thnn_avg_pool2d_forward_out(Tensor & output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const = 0;
  virtual Tensor _thnn_avg_pool2d_forward(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const = 0;
  virtual Tensor & _thnn_avg_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const = 0;
  virtual Tensor _thnn_avg_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const = 0;
  virtual Tensor & _thnn_avg_pool3d_forward_out(Tensor & output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const = 0;
  virtual Tensor _thnn_avg_pool3d_forward(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const = 0;
  virtual Tensor & _thnn_avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const = 0;
  virtual Tensor _thnn_avg_pool3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const = 0;
  virtual std::tuple<Tensor &,Tensor &> _thnn_max_pool2d_with_indices_forward_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const = 0;
  virtual std::tuple<Tensor,Tensor> _thnn_max_pool2d_with_indices_forward(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const = 0;
  virtual Tensor & _thnn_max_pool2d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices) const = 0;
  virtual Tensor _thnn_max_pool2d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices) const = 0;
  virtual std::tuple<Tensor &,Tensor &> _thnn_max_pool3d_with_indices_forward_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const = 0;
  virtual std::tuple<Tensor,Tensor> _thnn_max_pool3d_with_indices_forward(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const = 0;
  virtual Tensor & _thnn_max_pool3d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices) const = 0;
  virtual Tensor _thnn_max_pool3d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices) const = 0;
  virtual Tensor & _thnn_max_unpool2d_forward_out(Tensor & output, const Tensor & self, const Tensor & indices, IntArrayRef output_size) const = 0;
  virtual Tensor _thnn_max_unpool2d_forward(const Tensor & self, const Tensor & indices, IntArrayRef output_size) const = 0;
  virtual Tensor & _thnn_max_unpool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size) const = 0;
  virtual Tensor _thnn_max_unpool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size) const = 0;
  virtual Tensor & _thnn_max_unpool3d_forward_out(Tensor & output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding) const = 0;
  virtual Tensor _thnn_max_unpool3d_forward(const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding) const = 0;
  virtual Tensor & _thnn_max_unpool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding) const = 0;
  virtual Tensor _thnn_max_unpool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding) const = 0;
  virtual Tensor & _thnn_upsample_linear1d_forward_out(Tensor & output, const Tensor & self, IntArrayRef output_size, bool align_corners) const = 0;
  virtual Tensor _thnn_upsample_linear1d_forward(const Tensor & self, IntArrayRef output_size, bool align_corners) const = 0;
  virtual Tensor & _thnn_upsample_linear1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const = 0;
  virtual Tensor _thnn_upsample_linear1d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const = 0;
  virtual Tensor & _thnn_upsample_bilinear2d_forward_out(Tensor & output, const Tensor & self, IntArrayRef output_size, bool align_corners) const = 0;
  virtual Tensor _thnn_upsample_bilinear2d_forward(const Tensor & self, IntArrayRef output_size, bool align_corners) const = 0;
  virtual Tensor & _thnn_upsample_bilinear2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const = 0;
  virtual Tensor _thnn_upsample_bilinear2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const = 0;
  virtual Tensor & _thnn_upsample_bicubic2d_forward_out(Tensor & output, const Tensor & self, IntArrayRef output_size, bool align_corners) const = 0;
  virtual Tensor _thnn_upsample_bicubic2d_forward(const Tensor & self, IntArrayRef output_size, bool align_corners) const = 0;
  virtual Tensor & _thnn_upsample_bicubic2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const = 0;
  virtual Tensor _thnn_upsample_bicubic2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const = 0;
  virtual Tensor & _thnn_upsample_trilinear3d_forward_out(Tensor & output, const Tensor & self, IntArrayRef output_size, bool align_corners) const = 0;
  virtual Tensor _thnn_upsample_trilinear3d_forward(const Tensor & self, IntArrayRef output_size, bool align_corners) const = 0;
  virtual Tensor & _thnn_upsample_trilinear3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const = 0;
  virtual Tensor _thnn_upsample_trilinear3d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const = 0;
  virtual Tensor & _thnn_upsample_nearest1d_forward_out(Tensor & output, const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor _thnn_upsample_nearest1d_forward(const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor & _thnn_upsample_nearest1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const = 0;
  virtual Tensor _thnn_upsample_nearest1d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const = 0;
  virtual Tensor & _thnn_upsample_nearest2d_forward_out(Tensor & output, const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor _thnn_upsample_nearest2d_forward(const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor & _thnn_upsample_nearest2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const = 0;
  virtual Tensor _thnn_upsample_nearest2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const = 0;
  virtual Tensor & _thnn_upsample_nearest3d_forward_out(Tensor & output, const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor _thnn_upsample_nearest3d_forward(const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor & _thnn_upsample_nearest3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const = 0;
  virtual Tensor _thnn_upsample_nearest3d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const = 0;
  virtual Tensor & _thnn_sigmoid_forward_out(Tensor & output, const Tensor & self) const = 0;
  virtual Tensor _thnn_sigmoid_forward(const Tensor & self) const = 0;
  virtual Tensor & _thnn_sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output) const = 0;
  virtual Tensor _thnn_sigmoid_backward(const Tensor & grad_output, const Tensor & output) const = 0;
  virtual Tensor & _thnn_tanh_forward_out(Tensor & output, const Tensor & self) const = 0;
  virtual Tensor _thnn_tanh_forward(const Tensor & self) const = 0;
  virtual Tensor & _thnn_tanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output) const = 0;
  virtual Tensor _thnn_tanh_backward(const Tensor & grad_output, const Tensor & output) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_transpose2d_forward_out(Tensor & output, Tensor & columns, Tensor & ones, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> _thnn_conv_transpose2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_transpose2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> _thnn_conv_transpose2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_transpose3d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> _thnn_conv_transpose3d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_transpose3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & finput, const Tensor & fgrad_input) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> _thnn_conv_transpose3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv2d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> _thnn_conv2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> _thnn_conv2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask) const = 0;
  virtual Tensor & _thnn_conv_depthwise2d_forward_out(Tensor & output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const = 0;
  virtual Tensor _thnn_conv_depthwise2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor &,Tensor &> _thnn_conv_depthwise2d_backward_out(Tensor & grad_input, Tensor & grad_weight, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor,Tensor> _thnn_conv_depthwise2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, std::array<bool,2> output_mask) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv3d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> _thnn_conv3d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> _thnn_conv3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_dilated2d_forward_out(Tensor & output, Tensor & columns, Tensor & ones, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> _thnn_conv_dilated2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_dilated2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> _thnn_conv_dilated2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_dilated3d_forward_out(Tensor & output, Tensor & columns, Tensor & ones, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> _thnn_conv_dilated3d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_dilated3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> _thnn_conv_dilated3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask) const = 0;
  virtual Tensor & _thnn_col2im_forward_out(Tensor & output, const Tensor & self, IntArrayRef output_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const = 0;
  virtual Tensor _thnn_col2im_forward(const Tensor & self, IntArrayRef output_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const = 0;
  virtual Tensor & _thnn_col2im_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const = 0;
  virtual Tensor _thnn_col2im_backward(const Tensor & grad_output, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const = 0;
  virtual Tensor & _thnn_im2col_forward_out(Tensor & output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const = 0;
  virtual Tensor _thnn_im2col_forward(const Tensor & self, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const = 0;
  virtual Tensor & _thnn_im2col_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef input_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const = 0;
  virtual Tensor _thnn_im2col_backward(const Tensor & grad_output, IntArrayRef input_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const = 0;
  virtual Tensor _cast_Byte(const Tensor & self, bool non_blocking) const = 0;
  virtual Tensor _cast_Char(const Tensor & self, bool non_blocking) const = 0;
  virtual Tensor _cast_Double(const Tensor & self, bool non_blocking) const = 0;
  virtual Tensor _cast_Float(const Tensor & self, bool non_blocking) const = 0;
  virtual Tensor _cast_Int(const Tensor & self, bool non_blocking) const = 0;
  virtual Tensor _cast_Long(const Tensor & self, bool non_blocking) const = 0;
  virtual Tensor _cast_Short(const Tensor & self, bool non_blocking) const = 0;
  virtual Tensor _cast_Half(const Tensor & self, bool non_blocking) const = 0;
  virtual std::tuple<Tensor,Tensor> _cudnn_ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank, bool deterministic, bool zero_infinity) const = 0;
  virtual Tensor _cudnn_rnn_flatten_weight(TensorList weight_arr, int64_t weight_stride0, int64_t input_size, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, bool bidirectional) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _cudnn_rnn(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const Tensor & dropout_state) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor,std::vector<Tensor>> _cudnn_rnn_backward(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, const Tensor & output, const Tensor & grad_output, const Tensor & grad_hy, const Tensor & grad_cy, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const Tensor & dropout_state, const Tensor & reserve, std::array<bool,4> output_mask) const = 0;
  virtual Tensor _cudnn_init_dropout_state(double dropout, bool train, int64_t dropout_seed, const TensorOptions & options) const = 0;
  virtual int64_t _debug_has_internal_overlap(const Tensor & self) const = 0;
  virtual std::tuple<Tensor,Tensor> _fused_dropout(const Tensor & self, double p, Generator * generator) const = 0;
  virtual Tensor _masked_scale(const Tensor & self, const Tensor & mask, double scale) const = 0;
  virtual std::tuple<Tensor,Tensor> _sobol_engine_draw(const Tensor & quasi, int64_t n, const Tensor & sobolstate, int64_t dimension, int64_t num_generated, c10::optional<ScalarType> dtype) const = 0;
  virtual Tensor & _sobol_engine_ff_(Tensor & self, int64_t n, const Tensor & sobolstate, int64_t dimension, int64_t num_generated) const = 0;
  virtual Tensor & _sobol_engine_scramble_(Tensor & self, const Tensor & ltm, int64_t dimension) const = 0;
  virtual Tensor & _sobol_engine_initialize_state_(Tensor & self, int64_t dimension) const = 0;
  virtual Tensor _reshape_from_tensor(const Tensor & self, const Tensor & shape) const = 0;
  virtual Tensor _shape_as_tensor(const Tensor & self) const = 0;
  virtual Tensor dropout(const Tensor & input, double p, bool train) const = 0;
  virtual Tensor & dropout_(Tensor & self, double p, bool train) const = 0;
  virtual Tensor feature_dropout(const Tensor & input, double p, bool train) const = 0;
  virtual Tensor & feature_dropout_(Tensor & self, double p, bool train) const = 0;
  virtual Tensor alpha_dropout(const Tensor & input, double p, bool train) const = 0;
  virtual Tensor & alpha_dropout_(Tensor & self, double p, bool train) const = 0;
  virtual Tensor feature_alpha_dropout(const Tensor & input, double p, bool train) const = 0;
  virtual Tensor & feature_alpha_dropout_(Tensor & self, double p, bool train) const = 0;
  virtual Tensor & abs_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor & acos_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor avg_pool1d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const = 0;
  virtual Tensor adaptive_avg_pool1d(const Tensor & self, IntArrayRef output_size) const = 0;
  virtual std::tuple<Tensor,Tensor> adaptive_max_pool1d(const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor & add_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha) const = 0;
  virtual Tensor & addmv_out(Tensor & out, const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor & addr_out(Tensor & out, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor affine_grid_generator(const Tensor & theta, IntArrayRef size) const = 0;
  virtual Tensor affine_grid_generator_backward(const Tensor & grad, IntArrayRef size) const = 0;
  virtual Tensor & all_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim) const = 0;
  virtual Tensor & any_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim) const = 0;
  virtual Tensor arange(Scalar end, const TensorOptions & options) const = 0;
  virtual Tensor arange(Scalar start, Scalar end, const TensorOptions & options) const = 0;
  virtual Tensor arange(Scalar start, Scalar end, Scalar step, const TensorOptions & options) const = 0;
  virtual Tensor & arange_out(Tensor & out, Scalar end) const = 0;
  virtual Tensor & arange_out(Tensor & out, Scalar start, Scalar end, Scalar step) const = 0;
  virtual Tensor _dim_arange(const Tensor & like, int64_t dim) const = 0;
  virtual Tensor & asin_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor & atan_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor & _baddbmm_mkl_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor & baddbmm_out(Tensor & out, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor bartlett_window(int64_t window_length, const TensorOptions & options) const = 0;
  virtual Tensor bartlett_window(int64_t window_length, bool periodic, const TensorOptions & options) const = 0;
  virtual Tensor batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps, bool cudnn_enabled) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor,int64_t> _batch_norm_impl_index(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps, bool cudnn_enabled) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> _batch_norm_impl_index_backward(int64_t impl_index, const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var_transform, bool train, double eps, std::array<bool,3> output_mask) const = 0;
  virtual Tensor & bernoulli_out(Tensor & out, const Tensor & self, Generator * generator) const = 0;
  virtual Tensor bilinear(const Tensor & input1, const Tensor & input2, const Tensor & weight, const Tensor & bias) const = 0;
  virtual Tensor binary_cross_entropy_with_logits(const Tensor & self, const Tensor & target, const Tensor & weight, const Tensor & pos_weight, int64_t reduction) const = 0;
  virtual Tensor binary_cross_entropy_with_logits_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, const Tensor & pos_weight, int64_t reduction) const = 0;
  virtual Tensor blackman_window(int64_t window_length, const TensorOptions & options) const = 0;
  virtual Tensor blackman_window(int64_t window_length, bool periodic, const TensorOptions & options) const = 0;
  virtual Tensor & bmm_out(Tensor & out, const Tensor & self, const Tensor & mat2) const = 0;
  virtual std::vector<Tensor> broadcast_tensors(TensorList tensors) const = 0;
  virtual Tensor cat(TensorList tensors, int64_t dim) const = 0;
  virtual Tensor & cat_out(Tensor & out, TensorList tensors, int64_t dim) const = 0;
  virtual Tensor & ceil_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor chain_matmul(TensorList matrices) const = 0;
  virtual Tensor & clamp_out(Tensor & out, const Tensor & self, c10::optional<Scalar> min, c10::optional<Scalar> max) const = 0;
  virtual Tensor & clamp_max_out(Tensor & out, const Tensor & self, Scalar max) const = 0;
  virtual Tensor & clamp_min_out(Tensor & out, const Tensor & self, Scalar min) const = 0;
  virtual bool cudnn_is_acceptable(const Tensor & self) const = 0;
  virtual Tensor constant_pad_nd(const Tensor & self, IntArrayRef pad, Scalar value) const = 0;
  virtual Tensor convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups) const = 0;
  virtual Tensor _convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled) const = 0;
  virtual Tensor _convolution_nogroup(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> _convolution_double_backward(const Tensor & ggI, const Tensor & ggW, const Tensor & ggb, const Tensor & gO, const Tensor & weight, const Tensor & self, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled, std::array<bool,3> output_mask) const = 0;
  virtual Tensor conv1d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, int64_t groups) const = 0;
  virtual Tensor conv2d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, int64_t groups) const = 0;
  virtual Tensor conv3d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, int64_t groups) const = 0;
  virtual Tensor conv_tbc(const Tensor & self, const Tensor & weight, const Tensor & bias, int64_t pad) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> conv_tbc_backward(const Tensor & self, const Tensor & input, const Tensor & weight, const Tensor & bias, int64_t pad) const = 0;
  virtual Tensor conv_transpose1d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, int64_t groups, IntArrayRef dilation) const = 0;
  virtual Tensor conv_transpose2d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, int64_t groups, IntArrayRef dilation) const = 0;
  virtual Tensor conv_transpose3d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, int64_t groups, IntArrayRef dilation) const = 0;
  virtual Tensor & s_copy_(Tensor & self, const Tensor & src, bool non_blocking) const = 0;
  virtual Tensor _s_copy_from(const Tensor & self, const Tensor & dst, bool non_blocking) const = 0;
  virtual void _copy_same_type_(Tensor & self, const Tensor & src) const = 0;
  virtual Tensor & cos_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor & cosh_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor cosine_embedding_loss(const Tensor & input1, const Tensor & input2, const Tensor & target, double margin, int64_t reduction) const = 0;
  virtual Tensor cudnn_affine_grid_generator(const Tensor & theta, int64_t N, int64_t C, int64_t H, int64_t W) const = 0;
  virtual Tensor cudnn_affine_grid_generator_backward(const Tensor & grad, int64_t N, int64_t C, int64_t H, int64_t W) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> cudnn_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double exponential_average_factor, double epsilon) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> cudnn_batch_norm_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var, double epsilon) const = 0;
  virtual Tensor cudnn_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const = 0;
  virtual Tensor cudnn_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> cudnn_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) const = 0;
  virtual Tensor cudnn_convolution_backward_bias(const Tensor & grad_output) const = 0;
  virtual Tensor cudnn_convolution_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const = 0;
  virtual Tensor cudnn_convolution_transpose(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> cudnn_convolution_transpose_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) const = 0;
  virtual Tensor cudnn_convolution_transpose_backward_bias(const Tensor & grad_output) const = 0;
  virtual Tensor cudnn_convolution_transpose_backward_input(const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const = 0;
  virtual Tensor cudnn_convolution_transpose_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const = 0;
  virtual Tensor cudnn_grid_sampler(const Tensor & self, const Tensor & grid) const = 0;
  virtual std::tuple<Tensor,Tensor> cudnn_grid_sampler_backward(const Tensor & self, const Tensor & grid, const Tensor & grad_output) const = 0;
  virtual Tensor & cumsum_out(Tensor & out, const Tensor & self, int64_t dim, ScalarType dtype) const = 0;
  virtual Tensor & cumsum_out(Tensor & out, const Tensor & self, int64_t dim) const = 0;
  virtual Tensor & cumprod_out(Tensor & out, const Tensor & self, int64_t dim, ScalarType dtype) const = 0;
  virtual Tensor & cumprod_out(Tensor & out, const Tensor & self, int64_t dim) const = 0;
  virtual Tensor ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank, int64_t reduction, bool zero_infinity) const = 0;
  virtual Tensor ctc_loss(const Tensor & log_probs, const Tensor & targets, const Tensor & input_lengths, const Tensor & target_lengths, int64_t blank, int64_t reduction, bool zero_infinity) const = 0;
  virtual std::tuple<Tensor,Tensor> _ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank, bool zero_infinity) const = 0;
  virtual Tensor _ctc_loss_backward(const Tensor & grad, const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, const Tensor & neg_log_likelihood, const Tensor & log_alpha, int64_t blank, bool zero_infinity) const = 0;
  virtual Tensor & div_out(Tensor & out, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & dot_out(Tensor & out, const Tensor & self, const Tensor & tensor) const = 0;
  virtual Tensor einsum(std::string equation, TensorList tensors) const = 0;
  virtual Tensor embedding(const Tensor & weight, const Tensor & indices, int64_t padding_idx, bool scale_grad_by_freq, bool sparse) const = 0;
  virtual Tensor embedding_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq, bool sparse) const = 0;
  virtual Tensor embedding_dense_backward(const Tensor & grad_output, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq) const = 0;
  virtual Tensor & embedding_renorm_(Tensor & self, const Tensor & indices, double max_norm, double norm_type) const = 0;
  virtual Tensor embedding_sparse_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor,Tensor> embedding_bag(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq, int64_t mode, bool sparse, const Tensor & per_sample_weights) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor,Tensor> _embedding_bag(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq, int64_t mode, bool sparse, const Tensor & per_sample_weights) const = 0;
  virtual Tensor _embedding_bag_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, bool sparse, const Tensor & per_sample_weights) const = 0;
  virtual Tensor _embedding_bag_sparse_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, const Tensor & per_sample_weights) const = 0;
  virtual Tensor _embedding_bag_dense_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, const Tensor & per_sample_weights) const = 0;
  virtual Tensor _embedding_bag_per_sample_weights_backward(const Tensor & grad, const Tensor & weight, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, int64_t mode) const = 0;
  virtual Tensor empty(IntArrayRef size, const TensorOptions & options) const = 0;
  virtual Tensor _empty_affine_quantized(IntArrayRef size, const TensorOptions & options, double scale, int64_t zero_point) const = 0;
  virtual Tensor & empty_out(Tensor & out, IntArrayRef size) const = 0;
  virtual Tensor empty_like(const Tensor & self) const = 0;
  virtual Tensor empty_like(const Tensor & self, const TensorOptions & options) const = 0;
  virtual Tensor empty_strided(IntArrayRef size, IntArrayRef stride, const TensorOptions & options) const = 0;
  virtual Tensor & erf_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor & erfc_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor & exp_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor & expm1_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor eye(int64_t n, const TensorOptions & options) const = 0;
  virtual Tensor eye(int64_t n, int64_t m, const TensorOptions & options) const = 0;
  virtual Tensor & eye_out(Tensor & out, int64_t n) const = 0;
  virtual Tensor & eye_out(Tensor & out, int64_t n, int64_t m) const = 0;
  virtual Tensor & floor_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor & frac_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor full(IntArrayRef size, Scalar fill_value, const TensorOptions & options) const = 0;
  virtual Tensor & full_out(Tensor & out, IntArrayRef size, Scalar fill_value) const = 0;
  virtual Tensor full_like(const Tensor & self, Scalar fill_value) const = 0;
  virtual Tensor full_like(const Tensor & self, Scalar fill_value, const TensorOptions & options) const = 0;
  virtual Tensor from_file(std::string filename, c10::optional<bool> shared, c10::optional<int64_t> size, const TensorOptions & options) const = 0;
  virtual Tensor grid_sampler(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode) const = 0;
  virtual Tensor grid_sampler_2d(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode) const = 0;
  virtual std::tuple<Tensor,Tensor> grid_sampler_2d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode) const = 0;
  virtual Tensor grid_sampler_3d(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode) const = 0;
  virtual std::tuple<Tensor,Tensor> grid_sampler_3d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode) const = 0;
  virtual Tensor hann_window(int64_t window_length, const TensorOptions & options) const = 0;
  virtual Tensor hann_window(int64_t window_length, bool periodic, const TensorOptions & options) const = 0;
  virtual Tensor hamming_window(int64_t window_length, const TensorOptions & options) const = 0;
  virtual Tensor hamming_window(int64_t window_length, bool periodic, const TensorOptions & options) const = 0;
  virtual Tensor hamming_window(int64_t window_length, bool periodic, double alpha, const TensorOptions & options) const = 0;
  virtual Tensor hamming_window(int64_t window_length, bool periodic, double alpha, double beta, const TensorOptions & options) const = 0;
  virtual Tensor hinge_embedding_loss(const Tensor & self, const Tensor & target, double margin, int64_t reduction) const = 0;
  virtual Tensor & ger_out(Tensor & out, const Tensor & self, const Tensor & vec2) const = 0;
  virtual Tensor group_norm(const Tensor & input, int64_t num_groups, const Tensor & weight, const Tensor & bias, double eps, bool cudnn_enabled) const = 0;
  virtual Tensor _fft_with_size(const Tensor & self, int64_t signal_ndim, bool complex_input, bool complex_output, bool inverse, IntArrayRef checked_signal_sizes, bool normalized, bool onesided, IntArrayRef output_sizes) const = 0;
  virtual int64_t _cufft_get_plan_cache_size(int64_t device_index) const = 0;
  virtual int64_t _cufft_get_plan_cache_max_size(int64_t device_index) const = 0;
  virtual void _cufft_set_plan_cache_max_size(int64_t device_index, int64_t max_size) const = 0;
  virtual void _cufft_clear_plan_cache(int64_t device_index) const = 0;
  virtual Tensor instance_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool use_input_stats, double momentum, double eps, bool cudnn_enabled) const = 0;
  virtual Tensor & inverse_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor _inverse_helper(const Tensor & self) const = 0;
  virtual Tensor isnan(const Tensor & self) const = 0;
  virtual Tensor kl_div(const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor kl_div_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual std::tuple<Tensor &,Tensor &> kthvalue_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim, bool keepdim) const = 0;
  virtual Tensor layer_norm(const Tensor & input, IntArrayRef normalized_shape, const Tensor & weight, const Tensor & bias, double eps, bool cudnn_enable) const = 0;
  virtual Tensor linear(const Tensor & input, const Tensor & weight, const Tensor & bias) const = 0;
  virtual Tensor mkldnn_linear(const Tensor & input, const Tensor & weight, const Tensor & bias) const = 0;
  virtual Tensor fbgemm_linear_int8_weight(const Tensor & input, const Tensor & weight, const Tensor & packed, const Tensor & col_offsets, Scalar weight_scale, Scalar weight_zero_point, const Tensor & bias) const = 0;
  virtual std::tuple<Tensor,Tensor,double,int64_t> fbgemm_linear_quantize_weight(const Tensor & input) const = 0;
  virtual Tensor fbgemm_pack_quantized_matrix(const Tensor & input, int64_t K, int64_t N) const = 0;
  virtual bool fbgemm_is_cpu_supported() const = 0;
  virtual Tensor linspace(Scalar start, Scalar end, int64_t steps, const TensorOptions & options) const = 0;
  virtual Tensor & linspace_out(Tensor & out, Scalar start, Scalar end, int64_t steps) const = 0;
  virtual Tensor & log_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor & log10_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor & log1p_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor & log2_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor logspace(Scalar start, Scalar end, int64_t steps, double base, const TensorOptions & options) const = 0;
  virtual Tensor & logspace_out(Tensor & out, Scalar start, Scalar end, int64_t steps, double base) const = 0;
  virtual Tensor _log_softmax(const Tensor & self, int64_t dim, bool half_to_float) const = 0;
  virtual Tensor _log_softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self) const = 0;
  virtual Tensor & logsumexp_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim) const = 0;
  virtual Tensor margin_ranking_loss(const Tensor & input1, const Tensor & input2, const Tensor & target, double margin, int64_t reduction) const = 0;
  virtual Tensor & matmul_out(Tensor & out, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor matrix_rank(const Tensor & self, double tol, bool symmetric) const = 0;
  virtual Tensor matrix_rank(const Tensor & self, bool symmetric) const = 0;
  virtual std::tuple<Tensor &,Tensor &> max_out(Tensor & max, Tensor & max_values, const Tensor & self, int64_t dim, bool keepdim) const = 0;
  virtual std::tuple<Tensor,Tensor> max_pool1d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const = 0;
  virtual Tensor max_pool1d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const = 0;
  virtual Tensor max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const = 0;
  virtual Tensor mkldnn_max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const = 0;
  virtual Tensor max_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const = 0;
  virtual Tensor & mean_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim, ScalarType dtype) const = 0;
  virtual Tensor & mean_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim) const = 0;
  virtual Tensor & mean_out(Tensor & out, const Tensor & self, IntArrayRef dim, ScalarType dtype) const = 0;
  virtual std::tuple<Tensor &,Tensor &> median_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim) const = 0;
  virtual std::tuple<Tensor &,Tensor &> min_out(Tensor & min, Tensor & min_indices, const Tensor & self, int64_t dim, bool keepdim) const = 0;
  virtual Tensor mkldnn_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups) const = 0;
  virtual Tensor mkldnn_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool bias_defined) const = 0;
  virtual std::tuple<Tensor,Tensor> mkldnn_convolution_backward_weights(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool bias_defined) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> mkldnn_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, std::array<bool,3> output_mask) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> miopen_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double exponential_average_factor, double epsilon) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> miopen_batch_norm_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var, double epsilon) const = 0;
  virtual Tensor miopen_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const = 0;
  virtual Tensor miopen_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> miopen_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) const = 0;
  virtual Tensor miopen_convolution_backward_bias(const Tensor & grad_output) const = 0;
  virtual Tensor miopen_convolution_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const = 0;
  virtual Tensor miopen_convolution_transpose(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> miopen_convolution_transpose_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) const = 0;
  virtual Tensor miopen_convolution_transpose_backward_input(const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const = 0;
  virtual Tensor miopen_convolution_transpose_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const = 0;
  virtual Tensor miopen_depthwise_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const = 0;
  virtual Tensor miopen_depthwise_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> miopen_depthwise_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) const = 0;
  virtual Tensor miopen_depthwise_convolution_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const = 0;
  virtual Tensor & mm_out(Tensor & out, const Tensor & self, const Tensor & mat2) const = 0;
  virtual Tensor _sparse_mm(const Tensor & sparse, const Tensor & dense) const = 0;
  virtual std::tuple<Tensor &,Tensor &> mode_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim) const = 0;
  virtual Tensor & mul_out(Tensor & out, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & mv_out(Tensor & out, const Tensor & self, const Tensor & vec) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> native_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps) const = 0;
  virtual std::tuple<Tensor,Tensor> batch_norm_stats(const Tensor & input, double eps) const = 0;
  virtual Tensor batch_norm_elemt(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & mean, const Tensor & invstd, double eps) const = 0;
  virtual std::tuple<Tensor,Tensor> batch_norm_gather_stats(const Tensor & input, const Tensor & mean, const Tensor & invstd, const Tensor & running_mean, const Tensor & running_var, double momentum, double eps, int64_t count) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> native_batch_norm_backward(const Tensor & grad_out, const Tensor & input, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_invstd, bool train, double eps, std::array<bool,3> output_mask) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor,Tensor> batch_norm_backward_reduce(const Tensor & grad_out, const Tensor & input, const Tensor & mean, const Tensor & invstd, bool input_g, bool weight_g, bool bias_g) const = 0;
  virtual Tensor batch_norm_backward_elemt(const Tensor & grad_out, const Tensor & input, const Tensor & mean, const Tensor & invstd, const Tensor & weight, const Tensor & mean_dy, const Tensor & mean_dy_xmu) const = 0;
  virtual std::tuple<Tensor,Tensor> batch_norm_update_stats(const Tensor & input, const Tensor & running_mean, const Tensor & running_var, double momentum) const = 0;
  virtual bool _nnpack_available() const = 0;
  virtual Tensor _nnpack_spatial_convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef padding) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> _nnpack_spatial_convolution_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, std::array<bool,3> output_mask) const = 0;
  virtual Tensor _nnpack_spatial_convolution_backward_input(const Tensor & input, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding) const = 0;
  virtual Tensor _nnpack_spatial_convolution_backward_weight(const Tensor & input, IntArrayRef weightsize, const Tensor & grad_output, IntArrayRef padding) const = 0;
  virtual Tensor ones(IntArrayRef size, const TensorOptions & options) const = 0;
  virtual Tensor & ones_out(Tensor & out, IntArrayRef size) const = 0;
  virtual Tensor ones_like(const Tensor & self) const = 0;
  virtual Tensor ones_like(const Tensor & self, const TensorOptions & options) const = 0;
  virtual Tensor pairwise_distance(const Tensor & x1, const Tensor & x2, double p, double eps, bool keepdim) const = 0;
  virtual Tensor cdist(const Tensor & x1, const Tensor & x2, double p) const = 0;
  virtual Tensor _cdist_backward(const Tensor & grad, const Tensor & x1, const Tensor & x2, double p, const Tensor & cdist) const = 0;
  virtual Tensor pdist(const Tensor & self, double p) const = 0;
  virtual Tensor _pdist_forward(const Tensor & self, double p) const = 0;
  virtual Tensor _pdist_backward(const Tensor & grad, const Tensor & self, double p, const Tensor & pdist) const = 0;
  virtual Tensor cosine_similarity(const Tensor & x1, const Tensor & x2, int64_t dim, double eps) const = 0;
  virtual Tensor pixel_shuffle(const Tensor & self, int64_t upscale_factor) const = 0;
  virtual Tensor scalar_tensor(Scalar s, const TensorOptions & options) const = 0;
  virtual Tensor rand(IntArrayRef size, const TensorOptions & options) const = 0;
  virtual Tensor rand(IntArrayRef size, Generator * generator, const TensorOptions & options) const = 0;
  virtual Tensor & rand_out(Tensor & out, IntArrayRef size) const = 0;
  virtual Tensor & rand_out(Tensor & out, IntArrayRef size, Generator * generator) const = 0;
  virtual Tensor rand_like(const Tensor & self) const = 0;
  virtual Tensor rand_like(const Tensor & self, const TensorOptions & options) const = 0;
  virtual Tensor randint(int64_t high, IntArrayRef size, const TensorOptions & options) const = 0;
  virtual Tensor randint(int64_t high, IntArrayRef size, Generator * generator, const TensorOptions & options) const = 0;
  virtual Tensor randint(int64_t low, int64_t high, IntArrayRef size, const TensorOptions & options) const = 0;
  virtual Tensor randint(int64_t low, int64_t high, IntArrayRef size, Generator * generator, const TensorOptions & options) const = 0;
  virtual Tensor & randint_out(Tensor & out, int64_t high, IntArrayRef size) const = 0;
  virtual Tensor & randint_out(Tensor & out, int64_t high, IntArrayRef size, Generator * generator) const = 0;
  virtual Tensor & randint_out(Tensor & out, int64_t low, int64_t high, IntArrayRef size) const = 0;
  virtual Tensor & randint_out(Tensor & out, int64_t low, int64_t high, IntArrayRef size, Generator * generator) const = 0;
  virtual Tensor randint_like(const Tensor & self, int64_t high) const = 0;
  virtual Tensor randint_like(const Tensor & self, int64_t low, int64_t high) const = 0;
  virtual Tensor randint_like(const Tensor & self, int64_t high, const TensorOptions & options) const = 0;
  virtual Tensor randint_like(const Tensor & self, int64_t low, int64_t high, const TensorOptions & options) const = 0;
  virtual Tensor randn(IntArrayRef size, const TensorOptions & options) const = 0;
  virtual Tensor randn(IntArrayRef size, Generator * generator, const TensorOptions & options) const = 0;
  virtual Tensor & randn_out(Tensor & out, IntArrayRef size) const = 0;
  virtual Tensor & randn_out(Tensor & out, IntArrayRef size, Generator * generator) const = 0;
  virtual Tensor randn_like(const Tensor & self) const = 0;
  virtual Tensor randn_like(const Tensor & self, const TensorOptions & options) const = 0;
  virtual Tensor randperm(int64_t n, const TensorOptions & options) const = 0;
  virtual Tensor randperm(int64_t n, Generator * generator, const TensorOptions & options) const = 0;
  virtual Tensor & randperm_out(Tensor & out, int64_t n) const = 0;
  virtual Tensor & randperm_out(Tensor & out, int64_t n, Generator * generator) const = 0;
  virtual Tensor range(Scalar start, Scalar end, Scalar step, const TensorOptions & options) const = 0;
  virtual Tensor range(Scalar start, Scalar end, const TensorOptions & options) const = 0;
  virtual Tensor & range_out(Tensor & out, Scalar start, Scalar end, Scalar step) const = 0;
  virtual Tensor & reciprocal_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor & neg_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor mkldnn_reshape(const Tensor & self, IntArrayRef shape) const = 0;
  virtual Tensor & round_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor rrelu(const Tensor & self, Scalar lower, Scalar upper, bool training, Generator * generator) const = 0;
  virtual Tensor & rrelu_(Tensor & self, Scalar lower, Scalar upper, bool training, Generator * generator) const = 0;
  virtual Tensor & rsqrt_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor selu(const Tensor & self) const = 0;
  virtual Tensor & selu_(Tensor & self) const = 0;
  virtual Tensor celu(const Tensor & self, Scalar alpha) const = 0;
  virtual Tensor & celu_(Tensor & self, Scalar alpha) const = 0;
  virtual Tensor & sigmoid_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor & sin_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor & sinh_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor _softmax(const Tensor & self, int64_t dim, bool half_to_float) const = 0;
  virtual Tensor _softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self) const = 0;
  virtual Tensor & _sparse_add_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha) const = 0;
  virtual Tensor & _sparse_dense_add_out(Tensor & out, const Tensor & self, SparseTensorRef other, Scalar alpha) const = 0;
  virtual Tensor & _sparse_div_zerodim_out(Tensor & out, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _sparse_div_scalar_out(Tensor & out, const Tensor & self, Scalar other) const = 0;
  virtual Tensor & _sparse_mul_out(Tensor & out, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _sparse_mul_zerodim_out(Tensor & out, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & _sparse_mul_scalar_out(Tensor & out, const Tensor & self, Scalar other) const = 0;
  virtual Tensor & sspaddmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor stack(TensorList tensors, int64_t dim) const = 0;
  virtual Tensor & stack_out(Tensor & out, TensorList tensors, int64_t dim) const = 0;
  virtual Tensor & sum_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim, ScalarType dtype) const = 0;
  virtual Tensor & sum_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim) const = 0;
  virtual Tensor & sum_out(Tensor & out, const Tensor & self, IntArrayRef dim, ScalarType dtype) const = 0;
  virtual Tensor & sqrt_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor & std_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim) const = 0;
  virtual Tensor & prod_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim, ScalarType dtype) const = 0;
  virtual Tensor & prod_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim) const = 0;
  virtual Tensor & prod_out(Tensor & out, const Tensor & self, int64_t dim, ScalarType dtype) const = 0;
  virtual Tensor & tan_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor & tanh_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor tensordot(const Tensor & self, const Tensor & other, IntArrayRef dims_self, IntArrayRef dims_other) const = 0;
  virtual Tensor threshold(const Tensor & self, Scalar threshold, Scalar value) const = 0;
  virtual Tensor & threshold_(Tensor & self, Scalar threshold, Scalar value) const = 0;
  virtual Tensor & threshold_out(Tensor & out, const Tensor & self, Scalar threshold, Scalar value) const = 0;
  virtual Tensor threshold_backward(const Tensor & grad_output, const Tensor & self, Scalar threshold) const = 0;
  virtual Tensor one_hot(const Tensor & self, int64_t num_classes) const = 0;
  virtual Tensor _trilinear(const Tensor & i1, const Tensor & i2, const Tensor & i3, IntArrayRef expand1, IntArrayRef expand2, IntArrayRef expand3, IntArrayRef sumdim, int64_t unroll_dim) const = 0;
  virtual Tensor triplet_margin_loss(const Tensor & anchor, const Tensor & positive, const Tensor & negative, double margin, double p, double eps, bool swap, int64_t reduction) const = 0;
  virtual Tensor & trunc_out(Tensor & out, const Tensor & self) const = 0;
  virtual std::tuple<Tensor,Tensor> _unique(const Tensor & self, bool sorted, bool return_inverse) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> unique_dim(const Tensor & self, int64_t dim, bool sorted, bool return_inverse, bool return_counts) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> unique_consecutive(const Tensor & self, bool return_inverse, bool return_counts, c10::optional<int64_t> dim) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> unique_dim_consecutive(const Tensor & self, int64_t dim, bool return_inverse, bool return_counts) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> _unique2(const Tensor & self, bool sorted, bool return_inverse, bool return_counts) const = 0;
  virtual Tensor _unsafe_view(const Tensor & self, IntArrayRef size) const = 0;
  virtual Tensor & var_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim) const = 0;
  virtual Tensor _s_where(const Tensor & condition, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor norm_except_dim(const Tensor & v, int64_t pow, int64_t dim) const = 0;
  virtual Tensor _weight_norm(const Tensor & v, const Tensor & g, int64_t dim) const = 0;
  virtual std::tuple<Tensor,Tensor> _weight_norm_cuda_interface(const Tensor & v, const Tensor & g, int64_t dim) const = 0;
  virtual std::tuple<Tensor,Tensor> _weight_norm_cuda_interface_backward(const Tensor & grad_w, const Tensor & saved_v, const Tensor & saved_g, const Tensor & saved_norms, int64_t dim) const = 0;
  virtual std::tuple<Tensor,Tensor> _weight_norm_differentiable_backward(const Tensor & grad_w, const Tensor & saved_v, const Tensor & saved_g, const Tensor & saved_norms, int64_t dim) const = 0;
  virtual Tensor zeros(IntArrayRef size, const TensorOptions & options) const = 0;
  virtual Tensor & zeros_out(Tensor & out, IntArrayRef size) const = 0;
  virtual Tensor zeros_like(const Tensor & self) const = 0;
  virtual Tensor zeros_like(const Tensor & self, const TensorOptions & options) const = 0;
  virtual Tensor _standard_gamma_grad(const Tensor & self, const Tensor & output) const = 0;
  virtual Tensor _standard_gamma(const Tensor & self, Generator * generator) const = 0;
  virtual Tensor _sample_dirichlet(const Tensor & self, Generator * generator) const = 0;
  virtual Tensor poisson(const Tensor & self, Generator * generator) const = 0;
  virtual Tensor native_norm(const Tensor & self, Scalar p) const = 0;
  virtual Tensor _sparse_sum(const Tensor & self) const = 0;
  virtual Tensor _sparse_sum(const Tensor & self, ScalarType dtype) const = 0;
  virtual Tensor _sparse_sum(const Tensor & self, IntArrayRef dim) const = 0;
  virtual Tensor _sparse_sum(const Tensor & self, IntArrayRef dim, ScalarType dtype) const = 0;
  virtual Tensor _sparse_sum_backward(const Tensor & grad, const Tensor & self, IntArrayRef dim) const = 0;
  virtual Tensor & norm_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim, ScalarType dtype) const = 0;
  virtual Tensor & norm_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim) const = 0;
  virtual Tensor frobenius_norm(const Tensor & self) const = 0;
  virtual Tensor frobenius_norm(const Tensor & self, IntArrayRef dim, bool keepdim) const = 0;
  virtual Tensor & frobenius_norm_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim) const = 0;
  virtual Tensor nuclear_norm(const Tensor & self, bool keepdim) const = 0;
  virtual Tensor & nuclear_norm_out(Tensor & out, const Tensor & self, bool keepdim) const = 0;
  virtual Tensor & pow_out(Tensor & out, const Tensor & self, Scalar exponent) const = 0;
  virtual Tensor & sub_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha) const = 0;
  virtual Tensor rsub(const Tensor & self, const Tensor & other, Scalar alpha) const = 0;
  virtual Tensor rsub(const Tensor & self, Scalar other, Scalar alpha) const = 0;
  virtual Tensor & s_native_addmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor s_native_addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor & s_native_addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor _sparse_addmm(const Tensor & self, const Tensor & sparse, const Tensor & dense, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor & addmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor sparse_coo_tensor(IntArrayRef size, const TensorOptions & options) const = 0;
  virtual Tensor sparse_coo_tensor(const Tensor & indices, const Tensor & values, const TensorOptions & options) const = 0;
  virtual Tensor sparse_coo_tensor(const Tensor & indices, const Tensor & values, IntArrayRef size, const TensorOptions & options) const = 0;
  virtual Tensor _sparse_coo_tensor_unsafe(const Tensor & indices, const Tensor & values, IntArrayRef size, const TensorOptions & options) const = 0;
  virtual Tensor _sparse_coo_tensor_with_dims(int64_t sparse_dim, int64_t dense_dim, IntArrayRef size, const TensorOptions & options) const = 0;
  virtual Tensor _sparse_coo_tensor_with_dims_and_tensors(int64_t sparse_dim, int64_t dense_dim, IntArrayRef size, const Tensor & indices, const Tensor & values, const TensorOptions & options) const = 0;
  virtual Tensor to_dense_backward(const Tensor & grad, const Tensor & input) const = 0;
  virtual Tensor & hspmm_out(Tensor & out, const Tensor & mat1, const Tensor & mat2) const = 0;
  virtual Tensor hspmm(const Tensor & mat1, const Tensor & mat2) const = 0;
  virtual Tensor & copy_sparse_to_sparse_(Tensor & self, const Tensor & src, bool non_blocking) const = 0;
  virtual Tensor mkldnn_reorder_conv2d_weight(const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups) const = 0;
  virtual Tensor to_mkldnn_backward(const Tensor & grad, const Tensor & input) const = 0;
  virtual std::vector<Tensor> meshgrid(TensorList tensors) const = 0;
  virtual Tensor cartesian_prod(TensorList tensors) const = 0;
  virtual Tensor combinations(const Tensor & self, int64_t r, bool with_replacement) const = 0;
  virtual Scalar _local_scalar_dense(const Tensor & self) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> _thnn_fused_lstm_cell(const Tensor & input_gates, const Tensor & hidden_gates, const Tensor & cx, const Tensor & input_bias, const Tensor & hidden_bias) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_fused_lstm_cell_backward(const Tensor & grad_hy, const Tensor & grad_cy, const Tensor & cx, const Tensor & cy, const Tensor & workspace, bool has_bias) const = 0;
  virtual std::tuple<Tensor,Tensor> _thnn_fused_gru_cell(const Tensor & input_gates, const Tensor & hidden_gates, const Tensor & hx, const Tensor & input_bias, const Tensor & hidden_bias) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_fused_gru_cell_backward(const Tensor & grad_hy, const Tensor & workspace, bool has_bias) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> lstm(const Tensor & input, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> lstm(const Tensor & data, const Tensor & batch_sizes, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional) const = 0;
  virtual std::tuple<Tensor,Tensor> gru(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first) const = 0;
  virtual std::tuple<Tensor,Tensor> gru(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional) const = 0;
  virtual std::tuple<Tensor,Tensor> rnn_tanh(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first) const = 0;
  virtual std::tuple<Tensor,Tensor> rnn_tanh(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional) const = 0;
  virtual std::tuple<Tensor,Tensor> rnn_relu(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first) const = 0;
  virtual std::tuple<Tensor,Tensor> rnn_relu(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional) const = 0;
  virtual std::tuple<Tensor,Tensor> lstm_cell(const Tensor & input, TensorList hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh) const = 0;
  virtual Tensor gru_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh) const = 0;
  virtual Tensor rnn_tanh_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh) const = 0;
  virtual Tensor rnn_relu_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> quantized_lstm(const Tensor & input, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first) const = 0;
  virtual std::tuple<Tensor,Tensor> quantized_lstm_cell(const Tensor & input, TensorList hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh) const = 0;
  virtual Tensor quantized_gru_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh) const = 0;
  virtual Tensor quantized_rnn_relu_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh) const = 0;
  virtual Tensor quantized_rnn_tanh_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh) const = 0;
  virtual std::tuple<Tensor,Tensor> _pack_padded_sequence(const Tensor & input, const Tensor & lengths, bool batch_first) const = 0;
  virtual Tensor _pack_padded_sequence_backward(const Tensor & grad, IntArrayRef input_size, const Tensor & batch_sizes, bool batch_first) const = 0;
  virtual std::tuple<Tensor,Tensor> _pad_packed_sequence(const Tensor & data, const Tensor & batch_sizes, bool batch_first, Scalar padding_value, int64_t total_length) const = 0;
  virtual Tensor & addbmm_out(Tensor & out, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const = 0;
  virtual Tensor & diag_out(Tensor & out, const Tensor & self, int64_t diagonal) const = 0;
  virtual Tensor & cross_out(Tensor & out, const Tensor & self, const Tensor & other, c10::optional<int64_t> dim) const = 0;
  virtual Tensor & triu_out(Tensor & out, const Tensor & self, int64_t diagonal) const = 0;
  virtual Tensor & tril_out(Tensor & out, const Tensor & self, int64_t diagonal) const = 0;
  virtual Tensor tril_indices(int64_t row, int64_t col, int64_t offset, const TensorOptions & options) const = 0;
  virtual Tensor triu_indices(int64_t row, int64_t col, int64_t offset, const TensorOptions & options) const = 0;
  virtual Tensor & ne_out(Tensor & out, const Tensor & self, Scalar other) const = 0;
  virtual Tensor & ne_out(Tensor & out, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & eq_out(Tensor & out, const Tensor & self, Scalar other) const = 0;
  virtual Tensor & eq_out(Tensor & out, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & ge_out(Tensor & out, const Tensor & self, Scalar other) const = 0;
  virtual Tensor & ge_out(Tensor & out, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & le_out(Tensor & out, const Tensor & self, Scalar other) const = 0;
  virtual Tensor & le_out(Tensor & out, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & gt_out(Tensor & out, const Tensor & self, Scalar other) const = 0;
  virtual Tensor & gt_out(Tensor & out, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & lt_out(Tensor & out, const Tensor & self, Scalar other) const = 0;
  virtual Tensor & lt_out(Tensor & out, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & take_out(Tensor & out, const Tensor & self, const Tensor & index) const = 0;
  virtual Tensor & index_select_out(Tensor & out, const Tensor & self, int64_t dim, const Tensor & index) const = 0;
  virtual Tensor & masked_select_out(Tensor & out, const Tensor & self, const Tensor & mask) const = 0;
  virtual Tensor & nonzero_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor & gather_out(Tensor & out, const Tensor & self, int64_t dim, const Tensor & index, bool sparse_grad) const = 0;
  virtual Tensor _gather_sparse_backward(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & grad) const = 0;
  virtual Tensor & addcmul_out(Tensor & out, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const = 0;
  virtual Tensor & addcdiv_out(Tensor & out, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const = 0;
  virtual std::tuple<Tensor &,Tensor &> gels_out(Tensor & X, Tensor & qr, const Tensor & self, const Tensor & A) const = 0;
  virtual std::tuple<Tensor &,Tensor &> triangular_solve_out(Tensor & X, Tensor & M, const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular) const = 0;
  virtual std::tuple<Tensor,Tensor> _triangular_solve_helper(const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular) const = 0;
  virtual std::tuple<Tensor &,Tensor &> symeig_out(Tensor & e, Tensor & V, const Tensor & self, bool eigenvectors, bool upper) const = 0;
  virtual std::tuple<Tensor &,Tensor &> eig_out(Tensor & e, Tensor & v, const Tensor & self, bool eigenvectors) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> svd_out(Tensor & U, Tensor & S, Tensor & V, const Tensor & self, bool some, bool compute_uv) const = 0;
  virtual Tensor & cholesky_out(Tensor & out, const Tensor & self, bool upper) const = 0;
  virtual Tensor _cholesky_helper(const Tensor & self, bool upper) const = 0;
  virtual Tensor & cholesky_solve_out(Tensor & out, const Tensor & self, const Tensor & input2, bool upper) const = 0;
  virtual Tensor _cholesky_solve_helper(const Tensor & self, const Tensor & A, bool upper) const = 0;
  virtual std::tuple<Tensor &,Tensor &> solve_out(Tensor & solution, Tensor & lu, const Tensor & self, const Tensor & A) const = 0;
  virtual std::tuple<Tensor,Tensor> _solve_helper(const Tensor & self, const Tensor & A) const = 0;
  virtual Tensor & cholesky_inverse_out(Tensor & out, const Tensor & self, bool upper) const = 0;
  virtual std::tuple<Tensor &,Tensor &> pstrf_out(Tensor & u, Tensor & pivot, const Tensor & self, bool upper, Scalar tol) const = 0;
  virtual std::tuple<Tensor &,Tensor &> qr_out(Tensor & Q, Tensor & R, const Tensor & self) const = 0;
  virtual std::tuple<Tensor &,Tensor &> geqrf_out(Tensor & a, Tensor & tau, const Tensor & self) const = 0;
  virtual Tensor & orgqr_out(Tensor & out, const Tensor & self, const Tensor & input2) const = 0;
  virtual Tensor & ormqr_out(Tensor & out, const Tensor & self, const Tensor & input2, const Tensor & input3, bool left, bool transpose) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> _lu_with_info(const Tensor & self, bool pivot, bool check_errors) const = 0;
  virtual Tensor & lu_solve_out(Tensor & out, const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots) const = 0;
  virtual Tensor & multinomial_out(Tensor & out, const Tensor & self, int64_t num_samples, bool replacement, Generator * generator) const = 0;
  virtual std::tuple<Tensor,Tensor> _multinomial_alias_setup(const Tensor & probs) const = 0;
  virtual Tensor _multinomial_alias_draw(const Tensor & J, const Tensor & q, int64_t num_samples, Generator * generator) const = 0;
  virtual Tensor & lgamma_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor & digamma_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor & polygamma_out(Tensor & out, int64_t n, const Tensor & self) const = 0;
  virtual Tensor & erfinv_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor & atan2_out(Tensor & out, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & lerp_out(Tensor & out, const Tensor & self, const Tensor & end, Scalar weight) const = 0;
  virtual Tensor & lerp_out(Tensor & out, const Tensor & self, const Tensor & end, const Tensor & weight) const = 0;
  virtual Tensor & histc_out(Tensor & out, const Tensor & self, int64_t bins, Scalar min, Scalar max) const = 0;
  virtual Tensor & sign_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor & fmod_out(Tensor & out, const Tensor & self, Scalar other) const = 0;
  virtual Tensor & fmod_out(Tensor & out, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & remainder_out(Tensor & out, const Tensor & self, Scalar other) const = 0;
  virtual Tensor & remainder_out(Tensor & out, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & min_out(Tensor & out, const Tensor & self, const Tensor & other) const = 0;
  virtual Tensor & max_out(Tensor & out, const Tensor & self, const Tensor & other) const = 0;
  virtual std::tuple<Tensor &,Tensor &> sort_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool descending) const = 0;
  virtual std::tuple<Tensor &,Tensor &> topk_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted) const = 0;
  virtual Tensor & renorm_out(Tensor & out, const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const = 0;
  virtual Tensor & pow_out(Tensor & out, const Tensor & self, const Tensor & exponent) const = 0;
  virtual Tensor & pow_out(Tensor & out, Scalar self, const Tensor & exponent) const = 0;
  virtual Tensor & normal_out(Tensor & out, const Tensor & mean, double std, Generator * generator) const = 0;
  virtual Tensor normal(const Tensor & mean, double std, Generator * generator) const = 0;
  virtual Tensor & normal_out(Tensor & out, double mean, const Tensor & std, Generator * generator) const = 0;
  virtual Tensor normal(double mean, const Tensor & std, Generator * generator) const = 0;
  virtual Tensor & normal_out(Tensor & out, const Tensor & mean, const Tensor & std, Generator * generator) const = 0;
  virtual Tensor normal(const Tensor & mean, const Tensor & std, Generator * generator) const = 0;
  virtual Tensor & _dirichlet_grad_out(Tensor & out, const Tensor & x, const Tensor & alpha, const Tensor & total) const = 0;
  virtual Tensor _dirichlet_grad(const Tensor & x, const Tensor & alpha, const Tensor & total) const = 0;
  virtual Tensor & binary_cross_entropy_out(Tensor & out, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const = 0;
  virtual Tensor binary_cross_entropy(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const = 0;
  virtual Tensor & binary_cross_entropy_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const = 0;
  virtual Tensor binary_cross_entropy_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const = 0;
  virtual Tensor & mse_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor mse_loss(const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor & mse_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor mse_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor & l1_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor l1_loss(const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor & l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor & multi_margin_loss_out(Tensor & out, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const = 0;
  virtual Tensor multi_margin_loss(const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const = 0;
  virtual Tensor & multi_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const = 0;
  virtual Tensor multi_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const = 0;
  virtual Tensor & multilabel_margin_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor multilabel_margin_loss(const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual std::tuple<Tensor &,Tensor &> multilabel_margin_loss_forward_out(Tensor & output, Tensor & is_target, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual std::tuple<Tensor,Tensor> multilabel_margin_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor & multilabel_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target) const = 0;
  virtual Tensor multilabel_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target) const = 0;
  virtual Tensor & nll_loss_out(Tensor & out, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const = 0;
  virtual Tensor nll_loss(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const = 0;
  virtual std::tuple<Tensor &,Tensor &> nll_loss_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const = 0;
  virtual std::tuple<Tensor,Tensor> nll_loss_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const = 0;
  virtual Tensor & nll_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const = 0;
  virtual Tensor nll_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const = 0;
  virtual Tensor & nll_loss2d_out(Tensor & out, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const = 0;
  virtual Tensor nll_loss2d(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const = 0;
  virtual std::tuple<Tensor &,Tensor &> nll_loss2d_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const = 0;
  virtual std::tuple<Tensor,Tensor> nll_loss2d_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const = 0;
  virtual Tensor & nll_loss2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const = 0;
  virtual Tensor nll_loss2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const = 0;
  virtual Tensor & smooth_l1_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor smooth_l1_loss(const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor & smooth_l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor smooth_l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor & soft_margin_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor soft_margin_loss(const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor & soft_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor soft_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const = 0;
  virtual Tensor & elu_out(Tensor & out, const Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale) const = 0;
  virtual Tensor elu(const Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale) const = 0;
  virtual Tensor & elu_backward_out(Tensor & grad_input, const Tensor & grad_output, Scalar alpha, Scalar scale, Scalar input_scale, const Tensor & output) const = 0;
  virtual Tensor elu_backward(const Tensor & grad_output, Scalar alpha, Scalar scale, Scalar input_scale, const Tensor & output) const = 0;
  virtual Tensor & elu_(Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale) const = 0;
  virtual Tensor & glu_out(Tensor & out, const Tensor & self, int64_t dim) const = 0;
  virtual Tensor glu(const Tensor & self, int64_t dim) const = 0;
  virtual Tensor & glu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, int64_t dim) const = 0;
  virtual Tensor glu_backward(const Tensor & grad_output, const Tensor & self, int64_t dim) const = 0;
  virtual Tensor & hardtanh_out(Tensor & out, const Tensor & self, Scalar min_val, Scalar max_val) const = 0;
  virtual Tensor hardtanh(const Tensor & self, Scalar min_val, Scalar max_val) const = 0;
  virtual Tensor & hardtanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val) const = 0;
  virtual Tensor hardtanh_backward(const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val) const = 0;
  virtual Tensor & hardtanh_(Tensor & self, Scalar min_val, Scalar max_val) const = 0;
  virtual Tensor & leaky_relu_out(Tensor & out, const Tensor & self, Scalar negative_slope) const = 0;
  virtual Tensor leaky_relu(const Tensor & self, Scalar negative_slope) const = 0;
  virtual Tensor & leaky_relu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar negative_slope) const = 0;
  virtual Tensor leaky_relu_backward(const Tensor & grad_output, const Tensor & self, Scalar negative_slope) const = 0;
  virtual Tensor & leaky_relu_(Tensor & self, Scalar negative_slope) const = 0;
  virtual Tensor & log_sigmoid_out(Tensor & out, const Tensor & self) const = 0;
  virtual Tensor log_sigmoid(const Tensor & self) const = 0;
  virtual std::tuple<Tensor &,Tensor &> log_sigmoid_forward_out(Tensor & output, Tensor & buffer, const Tensor & self) const = 0;
  virtual std::tuple<Tensor,Tensor> log_sigmoid_forward(const Tensor & self) const = 0;
  virtual Tensor & log_sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & buffer) const = 0;
  virtual Tensor log_sigmoid_backward(const Tensor & grad_output, const Tensor & self, const Tensor & buffer) const = 0;
  virtual Tensor & rrelu_with_noise_out(Tensor & out, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const = 0;
  virtual Tensor rrelu_with_noise(const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const = 0;
  virtual Tensor & rrelu_with_noise_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training) const = 0;
  virtual Tensor rrelu_with_noise_backward(const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training) const = 0;
  virtual Tensor & rrelu_with_noise_(Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const = 0;
  virtual Tensor & softplus_out(Tensor & out, const Tensor & self, Scalar beta, Scalar threshold) const = 0;
  virtual Tensor softplus(const Tensor & self, Scalar beta, Scalar threshold) const = 0;
  virtual Tensor & softplus_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output) const = 0;
  virtual Tensor softplus_backward(const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output) const = 0;
  virtual Tensor & softshrink_out(Tensor & out, const Tensor & self, Scalar lambd) const = 0;
  virtual Tensor softshrink(const Tensor & self, Scalar lambd) const = 0;
  virtual Tensor & softshrink_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar lambd) const = 0;
  virtual Tensor softshrink_backward(const Tensor & grad_output, const Tensor & self, Scalar lambd) const = 0;
  virtual Tensor & adaptive_avg_pool2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor adaptive_avg_pool2d(const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor _adaptive_avg_pool2d(const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor _adaptive_avg_pool2d_backward(const Tensor & grad_output, const Tensor & self) const = 0;
  virtual Tensor & adaptive_avg_pool3d_out(Tensor & out, const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor adaptive_avg_pool3d(const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor & adaptive_avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self) const = 0;
  virtual Tensor adaptive_avg_pool3d_backward(const Tensor & grad_output, const Tensor & self) const = 0;
  virtual std::tuple<Tensor &,Tensor &> adaptive_max_pool2d_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef output_size) const = 0;
  virtual std::tuple<Tensor,Tensor> adaptive_max_pool2d(const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor & adaptive_max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices) const = 0;
  virtual Tensor adaptive_max_pool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices) const = 0;
  virtual std::tuple<Tensor &,Tensor &> adaptive_max_pool3d_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef output_size) const = 0;
  virtual std::tuple<Tensor,Tensor> adaptive_max_pool3d(const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor & adaptive_max_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices) const = 0;
  virtual Tensor adaptive_max_pool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices) const = 0;
  virtual Tensor & avg_pool2d_out(Tensor & out, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const = 0;
  virtual Tensor avg_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const = 0;
  virtual Tensor & avg_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const = 0;
  virtual Tensor avg_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const = 0;
  virtual Tensor & avg_pool3d_out(Tensor & out, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const = 0;
  virtual Tensor avg_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const = 0;
  virtual Tensor & avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const = 0;
  virtual Tensor avg_pool3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const = 0;
  virtual std::tuple<Tensor &,Tensor &> fractional_max_pool2d_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples) const = 0;
  virtual std::tuple<Tensor,Tensor> fractional_max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples) const = 0;
  virtual Tensor & fractional_max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices) const = 0;
  virtual Tensor fractional_max_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices) const = 0;
  virtual std::tuple<Tensor &,Tensor &> fractional_max_pool3d_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples) const = 0;
  virtual std::tuple<Tensor,Tensor> fractional_max_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples) const = 0;
  virtual Tensor & fractional_max_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices) const = 0;
  virtual Tensor fractional_max_pool3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices) const = 0;
  virtual std::tuple<Tensor &,Tensor &> max_pool2d_with_indices_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const = 0;
  virtual std::tuple<Tensor,Tensor> max_pool2d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const = 0;
  virtual Tensor & max_pool2d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices) const = 0;
  virtual Tensor max_pool2d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices) const = 0;
  virtual std::tuple<Tensor &,Tensor &> max_pool3d_with_indices_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const = 0;
  virtual std::tuple<Tensor,Tensor> max_pool3d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const = 0;
  virtual Tensor & max_pool3d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices) const = 0;
  virtual Tensor max_pool3d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices) const = 0;
  virtual Tensor & max_unpool2d_out(Tensor & out, const Tensor & self, const Tensor & indices, IntArrayRef output_size) const = 0;
  virtual Tensor max_unpool2d(const Tensor & self, const Tensor & indices, IntArrayRef output_size) const = 0;
  virtual Tensor & max_unpool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size) const = 0;
  virtual Tensor max_unpool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size) const = 0;
  virtual Tensor & max_unpool3d_out(Tensor & out, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding) const = 0;
  virtual Tensor max_unpool3d(const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding) const = 0;
  virtual Tensor & max_unpool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding) const = 0;
  virtual Tensor max_unpool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding) const = 0;
  virtual Tensor & reflection_pad1d_out(Tensor & out, const Tensor & self, IntArrayRef padding) const = 0;
  virtual Tensor reflection_pad1d(const Tensor & self, IntArrayRef padding) const = 0;
  virtual Tensor & reflection_pad1d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding) const = 0;
  virtual Tensor reflection_pad1d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding) const = 0;
  virtual Tensor & reflection_pad2d_out(Tensor & out, const Tensor & self, IntArrayRef padding) const = 0;
  virtual Tensor reflection_pad2d(const Tensor & self, IntArrayRef padding) const = 0;
  virtual Tensor & reflection_pad2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding) const = 0;
  virtual Tensor reflection_pad2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding) const = 0;
  virtual Tensor & replication_pad1d_out(Tensor & out, const Tensor & self, IntArrayRef padding) const = 0;
  virtual Tensor replication_pad1d(const Tensor & self, IntArrayRef padding) const = 0;
  virtual Tensor & replication_pad1d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding) const = 0;
  virtual Tensor replication_pad1d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding) const = 0;
  virtual Tensor & replication_pad2d_out(Tensor & out, const Tensor & self, IntArrayRef padding) const = 0;
  virtual Tensor replication_pad2d(const Tensor & self, IntArrayRef padding) const = 0;
  virtual Tensor & replication_pad2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding) const = 0;
  virtual Tensor replication_pad2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding) const = 0;
  virtual Tensor & replication_pad3d_out(Tensor & out, const Tensor & self, IntArrayRef padding) const = 0;
  virtual Tensor replication_pad3d(const Tensor & self, IntArrayRef padding) const = 0;
  virtual Tensor & replication_pad3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding) const = 0;
  virtual Tensor replication_pad3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding) const = 0;
  virtual Tensor & upsample_linear1d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners) const = 0;
  virtual Tensor upsample_linear1d(const Tensor & self, IntArrayRef output_size, bool align_corners) const = 0;
  virtual Tensor & upsample_linear1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const = 0;
  virtual Tensor upsample_linear1d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const = 0;
  virtual Tensor & upsample_bilinear2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners) const = 0;
  virtual Tensor upsample_bilinear2d(const Tensor & self, IntArrayRef output_size, bool align_corners) const = 0;
  virtual Tensor & upsample_bilinear2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const = 0;
  virtual Tensor upsample_bilinear2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const = 0;
  virtual Tensor & upsample_bicubic2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners) const = 0;
  virtual Tensor upsample_bicubic2d(const Tensor & self, IntArrayRef output_size, bool align_corners) const = 0;
  virtual Tensor & upsample_bicubic2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const = 0;
  virtual Tensor upsample_bicubic2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const = 0;
  virtual Tensor & upsample_trilinear3d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners) const = 0;
  virtual Tensor upsample_trilinear3d(const Tensor & self, IntArrayRef output_size, bool align_corners) const = 0;
  virtual Tensor & upsample_trilinear3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const = 0;
  virtual Tensor upsample_trilinear3d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const = 0;
  virtual Tensor & upsample_nearest1d_out(Tensor & out, const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor upsample_nearest1d(const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor & upsample_nearest1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const = 0;
  virtual Tensor upsample_nearest1d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const = 0;
  virtual Tensor & upsample_nearest2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor upsample_nearest2d(const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor & upsample_nearest2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const = 0;
  virtual Tensor upsample_nearest2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const = 0;
  virtual Tensor & upsample_nearest3d_out(Tensor & out, const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor upsample_nearest3d(const Tensor & self, IntArrayRef output_size) const = 0;
  virtual Tensor & upsample_nearest3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const = 0;
  virtual Tensor upsample_nearest3d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const = 0;
  virtual Tensor & sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output) const = 0;
  virtual Tensor sigmoid_backward(const Tensor & grad_output, const Tensor & output) const = 0;
  virtual Tensor & tanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output) const = 0;
  virtual Tensor tanh_backward(const Tensor & grad_output, const Tensor & output) const = 0;
  virtual Tensor & thnn_conv_transpose2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const = 0;
  virtual Tensor thnn_conv_transpose2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_transpose2d_forward_out(Tensor & output, Tensor & columns, Tensor & ones, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_transpose2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_transpose2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_transpose2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask) const = 0;
  virtual Tensor & thnn_conv_transpose3d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const = 0;
  virtual Tensor thnn_conv_transpose3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_transpose3d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_transpose3d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_transpose3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & finput, const Tensor & fgrad_input) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_transpose3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask) const = 0;
  virtual Tensor & thnn_conv2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const = 0;
  virtual Tensor thnn_conv2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv2d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask) const = 0;
  virtual Tensor & thnn_conv_depthwise2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const = 0;
  virtual Tensor thnn_conv_depthwise2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const = 0;
  virtual Tensor & thnn_conv_depthwise2d_forward_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const = 0;
  virtual Tensor thnn_conv_depthwise2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor &,Tensor &> thnn_conv_depthwise2d_backward_out(Tensor & grad_input, Tensor & grad_weight, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor,Tensor> thnn_conv_depthwise2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, std::array<bool,2> output_mask) const = 0;
  virtual Tensor & thnn_conv3d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const = 0;
  virtual Tensor thnn_conv3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv3d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv3d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask) const = 0;
  virtual Tensor & thnn_conv_dilated2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const = 0;
  virtual Tensor thnn_conv_dilated2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_dilated2d_forward_out(Tensor & output, Tensor & columns, Tensor & ones, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_dilated2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_dilated2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_dilated2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask) const = 0;
  virtual Tensor & thnn_conv_dilated3d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const = 0;
  virtual Tensor thnn_conv_dilated3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_dilated3d_forward_out(Tensor & output, Tensor & columns, Tensor & ones, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_dilated3d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const = 0;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_dilated3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones) const = 0;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_dilated3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask) const = 0;
  virtual Tensor thnn_col2im(const Tensor & self, IntArrayRef output_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const = 0;
  virtual Tensor thnn_col2im_backward(const Tensor & grad_output, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const = 0;
  virtual Tensor thnn_im2col(const Tensor & self, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const = 0;
  virtual Tensor thnn_im2col_backward(const Tensor & grad_output, IntArrayRef input_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const = 0;
};

} // namespace at
