/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ssh;

import com.intellij.cvsSupport2.connections.ssh.SSHPasswordProvider;
import com.intellij.cvsSupport2.connections.ssh.SolveableAuthenticationException;
import com.intellij.cvsSupport2.connections.ssh.SshAuthentication;
import com.intellij.openapi.util.io.FileUtil;
import com.trilead.ssh2.Connection;
import java.io.File;
import java.io.IOException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;

public class SshPublicKeyAuthentication
implements SshAuthentication {
    private final String myLogin;
    private final File myFile;
    private final SSHPasswordProvider myPasswordProvider;
    private final String myCvsRootAsString;

    public SshPublicKeyAuthentication(File file, String login, SSHPasswordProvider passwordProvider, String cvsRootAsString) {
        this.myFile = file;
        this.myLogin = login;
        this.myPasswordProvider = passwordProvider;
        this.myCvsRootAsString = cvsRootAsString;
    }

    @Override
    public void authenticate(Connection connection) throws AuthenticationException {
        char[] keyChars;
        try {
            keyChars = FileUtil.loadFileText((File)this.myFile);
        }
        catch (IOException e) {
            throw new SolveableAuthenticationException("Cannot load public key file.");
        }
        try {
            String password = this.myPasswordProvider.getPPKPasswordForCvsRoot(this.myCvsRootAsString);
            if (!connection.authenticateWithPublicKey(this.myLogin, keyChars, password)) {
                throw new SolveableAuthenticationException("Authentication rejected.");
            }
        }
        catch (IOException e) {
            throw new SolveableAuthenticationException(e.getMessage(), e);
        }
    }

    @Override
    public String getLogin() {
        return this.myLogin;
    }
}

