/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;

class Chooser {
    static final boolean useNativeSelect = true;

    Chooser() {
    }

    public static void selectInput(Frame frame, String string, File file, Callback callback) {
        Chooser.selectImpl(frame, string, file, callback, 0);
    }

    public static void selectOutput(Frame frame, String string, File file, Callback callback) {
        Chooser.selectImpl(frame, string, file, callback, 1);
    }

    protected static void selectImpl(Frame frame, String string, File file, Callback callback, int n) {
        File file2 = null;
        FileDialog fileDialog = new FileDialog(frame, string, n);
        if (file != null) {
            fileDialog.setDirectory(file.getParent());
            fileDialog.setFile(file.getName());
        }
        fileDialog.setVisible(true);
        String string2 = fileDialog.getDirectory();
        String string3 = fileDialog.getFile();
        if (string3 != null) {
            file2 = new File(string2, string3);
        }
        callback.handle(file2);
    }

    public static void selectFolder(Frame frame, String string, File file, Callback callback) {
        File file2 = null;
        if (System.getProperty("os.name").contains("Mac")) {
            FileDialog fileDialog = new FileDialog(frame, string, 0);
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            fileDialog.setVisible(true);
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            String string2 = fileDialog.getFile();
            if (string2 != null) {
                file2 = new File(fileDialog.getDirectory(), fileDialog.getFile());
            }
        } else {
            int n;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(string);
            jFileChooser.setFileSelectionMode(1);
            if (file != null) {
                jFileChooser.setSelectedFile(file);
            }
            if ((n = jFileChooser.showOpenDialog(frame)) == 0) {
                file2 = jFileChooser.getSelectedFile();
            }
        }
        callback.handle(file2);
    }

    static abstract class Callback {
        Callback() {
        }

        void handle(final File file) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.select(file);
                }
            });
        }

        abstract void select(File var1);
    }
}

