/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.pdf;

import java.util.Optional;
import org.apache.commons.lang3.time.FastDateFormat;
import org.pdfsam.module.RequiredPdfData;
import org.pdfsam.pdf.PdfDocumentDescriptor;
import org.pdfsam.pdf.PdfLoader;
import org.sejda.model.pdf.PdfMetadataKey;
import org.sejda.model.pdf.PdfVersion;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDDocumentInformation;

class DefaultSAMBoxLoader
implements PdfLoader<PDDocument> {
    private static FastDateFormat FORMATTER = FastDateFormat.getDateTimeInstance((int)0, (int)2);

    DefaultSAMBoxLoader() {
    }

    @Override
    public void accept(PDDocument document, PdfDocumentDescriptor descriptor) {
        descriptor.pages(document.getNumberOfPages());
        descriptor.setVersion(this.getVersion(document.getVersion()));
        PDDocumentInformation info = document.getDocumentInformation();
        descriptor.putInformation(PdfMetadataKey.TITLE.getKey(), info.getTitle());
        descriptor.putInformation(PdfMetadataKey.AUTHOR.getKey(), info.getAuthor());
        descriptor.putInformation(PdfMetadataKey.CREATOR.getKey(), info.getCreator());
        descriptor.putInformation(PdfMetadataKey.SUBJECT.getKey(), info.getSubject());
        descriptor.putInformation(PdfMetadataKey.KEYWORDS.getKey(), info.getKeywords());
        descriptor.putInformation("Producer", info.getProducer());
        Optional.ofNullable(info.getCreationDate()).map(arg_0 -> ((FastDateFormat)FORMATTER).format(arg_0)).ifPresent(c -> descriptor.putInformation("FormattedCreationDate", c));
    }

    @Override
    public RequiredPdfData key() {
        return RequiredPdfData.DEFAULT;
    }

    private PdfVersion getVersion(String version) {
        for (PdfVersion current : PdfVersion.values()) {
            if (!current.getVersionString().equals(version)) continue;
            return current;
        }
        return null;
    }
}

