/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.module;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.pdfsam.module.Module;
import org.pdfsam.module.ModuleUsage;
import org.pdfsam.module.PreferencesUsageDataStore;
import org.pdfsam.module.UsageService;

class StatefulPreferencesUsageService
implements UsageService {
    private PreferencesUsageDataStore dataStore;
    private Map<String, Module> modulesMap;

    @Inject
    StatefulPreferencesUsageService(List<Module> modules, PreferencesUsageDataStore dataStore) {
        this.modulesMap = modules.stream().collect(Collectors.toMap(Module::id, m -> m));
        this.dataStore = dataStore;
    }

    @Override
    public void incrementUsageFor(String moduleId) {
        this.dataStore.incrementUsageFor(moduleId);
    }

    @Override
    public List<Module> getMostUsed() {
        List<ModuleUsage> used = this.dataStore.getUsages();
        used.sort((a, b) -> Long.compare(b.getTotalUsed(), a.getTotalUsed()));
        return used.stream().map(u -> this.modulesMap.get(u.getModuleId())).filter(m -> m != null).collect(Collectors.toList());
    }

    @Override
    public List<Module> getMostRecentlyUsed() {
        List<ModuleUsage> used = this.dataStore.getUsages();
        used.sort((a, b) -> Long.compare(b.getLastSeen(), a.getLastSeen()));
        return used.stream().map(u -> this.modulesMap.get(u.getModuleId())).filter(m -> m != null).collect(Collectors.toList());
    }

    @Override
    public void clear() {
        this.dataStore.clear();
    }

    @Override
    public long getTotalUsage() {
        return this.dataStore.getTotalUsage();
    }
}

