/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.helper.swing;

import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.netbeans.installer.utils.FileProxy;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.exceptions.DownloadException;
import org.netbeans.installer.utils.helper.Pair;

public class NbiPanel
extends JPanel {
    private List<Pair<Integer, ImageIcon>> images;
    public static final int ANCHOR_TOP_LEFT = 1;
    public static final int ANCHOR_TOP_RIGHT = 2;
    public static final int ANCHOR_BOTTOM_LEFT = 3;
    public static final int ANCHOR_BOTTOM_RIGHT = 4;
    public static final int ANCHOR_LEFT = 5;
    public static final int ANCHOR_RIGHT = 6;
    public static final int ANCHOR_BOTTOM = 7;
    public static final int ANCHOR_TOP = 8;
    public static final int ANCHOR_FULL = 9;

    public NbiPanel() {
        this.setLayout(new GridBagLayout());
        this.images = new ArrayList<Pair<Integer, ImageIcon>>();
    }

    public void setBackgroundImage(String backgroundImageURI, int anchor) {
        if (backgroundImageURI != null) {
            try {
                File file = FileProxy.getInstance().getFile(backgroundImageURI, true);
                ImageIcon backgroundImage = new ImageIcon(file.getAbsolutePath());
                this.setBackgroundImage(backgroundImage, anchor);
            }
            catch (DownloadException e) {
                LogManager.log(e);
            }
        }
    }

    public void setBackgroundImage(ImageIcon backgroundImage, int anchor) {
        if (backgroundImage != null) {
            this.images.add(new Pair<Integer, ImageIcon>(anchor, backgroundImage));
        }
    }

    public ImageIcon getBackgroundImage(int anchor) {
        for (Pair<Integer, ImageIcon> pair : this.images) {
            if (pair.getFirst() != anchor) continue;
            return pair.getSecond();
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        for (Pair<Integer, ImageIcon> pair : this.images) {
            int anchor = pair.getFirst();
            Image backgroundImage = pair.getSecond().getImage();
            if (backgroundImage == null) continue;
            switch (anchor) {
                case 1: {
                    graphics.drawImage(backgroundImage, 0, 0, this);
                    break;
                }
                case 2: {
                    graphics.drawImage(backgroundImage, this.getWidth() - backgroundImage.getWidth(this), 0, this);
                    break;
                }
                case 3: {
                    graphics.drawImage(backgroundImage, 0, this.getHeight() - backgroundImage.getHeight(this), this);
                    break;
                }
                case 4: {
                    graphics.drawImage(backgroundImage, this.getWidth() - backgroundImage.getWidth(this), this.getHeight() - backgroundImage.getHeight(this), this);
                    break;
                }
                case 5: {
                    graphics.drawImage(backgroundImage, 0, (this.getHeight() - backgroundImage.getHeight(this)) / 2, this);
                    break;
                }
                case 6: {
                    graphics.drawImage(backgroundImage, this.getWidth() - backgroundImage.getWidth(this), (this.getHeight() - backgroundImage.getHeight(this)) / 2, this);
                    break;
                }
                case 7: {
                    graphics.drawImage(backgroundImage, (this.getWidth() - backgroundImage.getWidth(this)) / 2, this.getHeight() - backgroundImage.getHeight(this), this);
                    break;
                }
                case 8: {
                    graphics.drawImage(backgroundImage, this.getWidth() - backgroundImage.getWidth(this), 0, this);
                    break;
                }
                case 9: {
                    graphics.drawImage(backgroundImage, 0, 0, this.getWidth(), this.getHeight(), 0, 0, backgroundImage.getWidth(this), backgroundImage.getHeight(this), this);
                }
            }
        }
    }
}

