/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.search.SearchPattern;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class FindDialogMemory {
    private static final int maxFileNamePatternCount = 10;
    private static FindDialogMemory singleton;
    private List<String> fileNamePatterns;
    private boolean wholeWords;
    private boolean caseSensitive;
    private boolean preserveCase;
    private SearchPattern.MatchType matchType;
    private boolean textPatternSpecified;
    private boolean replacePatternSpecified;
    private String scopeTypeId;
    private boolean fileNamePatternSpecified;
    private boolean searchInArchives;
    private boolean searchInGenerated;
    private boolean filePathRegex;
    private boolean useIgnoreList;
    private List<String> ignoreList;
    private String textSandboxContent;
    private String pathSandboxContent;
    private String resultsColumnWidths;
    private String resultsColumnWidthsDetails;
    private String resultsColumnWidthsReplacing;
    private int replaceResultsDivider;
    private String resultsViewMode;
    private String provider;
    private boolean openInNewTab;
    private static Preferences prefs;
    private static final String PREFS_NODE = "FindDialogMemory";
    private static final String PROP_WHOLE_WORDS = "whole_words";
    private static final String PROP_CASE_SENSITIVE = "case_sensitive";
    private static final String PROP_PRESERVE_CASE = "preserve_case";
    private static final String PROP_MATCH_TYPE = "match_type";
    private static final String PROP_SCOPE_TYPE_ID = "scope_type_id";
    private static final String PROP_FILENAME_PATTERN_SPECIFIED = "filename_specified";
    private static final String PROP_FILENAME_PATTERN_PREFIX = "filename_pattern_";
    private static final String PROP_REPLACE_PATTERN_PREFIX = "replace_pattern_";
    private static final String PROP_SEARCH_IN_ARCHIVES = "search_in_archives";
    private static final String PROP_SEARCH_IN_GENERATED = "search_in_generated";
    private static final String PROP_FILE_PATH_REGEX = "file_path_regex";
    private static final String PROP_USE_IGNORE_LIST = "use_ignore_list";
    private static final String PROP_IGNORE_LIST_PREFIX = "ignore_list_";
    private static final String PROP_TEXT_SANDBOX_CONTENT = "text_sandbox_content";
    private static final String PROP_PATH_SANDBOX_CONTENT = "path_sandbox_content";
    private static final String PROP_RESULTS_COLUMN_WIDTHS = "results_column_widths";
    private static final String PROP_RESULTS_COLUMN_WIDTHS_DETAILS = "results_column_widths_details";
    private static final String PROP_RESULTS_COLUMN_WIDTHS_REPLACING = "results_column_widths_replacing";
    private static final String PROP_REPLACE_RESULTS_DIVIDER = "replace_results_divider";
    private static final String PROP_RESULTS_VIEW_MODE = "results_view_mode";
    private static final String PROP_PROVIDER = "provider";
    private static final String PROP_OPEN_IN_NEW_TAB = "open_in_new_tab";

    private FindDialogMemory() {
        prefs = NbPreferences.forModule(FindDialogMemory.class).node(PREFS_NODE);
        this.load();
    }

    public static FindDialogMemory getDefault() {
        if (singleton == null) {
            singleton = new FindDialogMemory();
        }
        return singleton;
    }

    private void load() {
        String item;
        int i;
        this.wholeWords = prefs.getBoolean(PROP_WHOLE_WORDS, false);
        this.caseSensitive = prefs.getBoolean(PROP_CASE_SENSITIVE, false);
        try {
            String name = prefs.get(PROP_MATCH_TYPE, SearchPattern.MatchType.LITERAL.name());
            this.matchType = SearchPattern.MatchType.valueOf(name);
        }
        catch (Exception e) {
            this.matchType = SearchPattern.MatchType.LITERAL;
        }
        this.preserveCase = prefs.getBoolean(PROP_PRESERVE_CASE, false);
        this.scopeTypeId = prefs.get(PROP_SCOPE_TYPE_ID, "open projects");
        this.fileNamePatternSpecified = prefs.getBoolean(PROP_FILENAME_PATTERN_SPECIFIED, false);
        this.searchInArchives = prefs.getBoolean(PROP_SEARCH_IN_ARCHIVES, false);
        this.searchInGenerated = prefs.getBoolean(PROP_SEARCH_IN_GENERATED, false);
        this.filePathRegex = prefs.getBoolean(PROP_FILE_PATH_REGEX, false);
        this.useIgnoreList = prefs.getBoolean(PROP_USE_IGNORE_LIST, false);
        this.textSandboxContent = prefs.get(PROP_TEXT_SANDBOX_CONTENT, this.getText("TextPatternSandbox.textPane.text.default"));
        this.pathSandboxContent = prefs.get(PROP_PATH_SANDBOX_CONTENT, this.getText("PathPatternSandbox.textPane.text.default"));
        this.resultsColumnWidths = prefs.get(PROP_RESULTS_COLUMN_WIDTHS, "100:-1:-1:-1:|0:");
        this.resultsColumnWidthsDetails = prefs.get(PROP_RESULTS_COLUMN_WIDTHS_DETAILS, "100:-1:-1:-1:-1:|0:");
        this.resultsColumnWidthsReplacing = prefs.get(PROP_RESULTS_COLUMN_WIDTHS_REPLACING, "100:-1:-1:-1:-1:|0:");
        this.replaceResultsDivider = prefs.getInt(PROP_REPLACE_RESULTS_DIVIDER, -1);
        this.resultsViewMode = prefs.get(PROP_RESULTS_VIEW_MODE, null);
        this.provider = prefs.get(PROP_PROVIDER, null);
        this.openInNewTab = prefs.getBoolean(PROP_OPEN_IN_NEW_TAB, true);
        this.fileNamePatterns = new ArrayList<String>(10);
        this.ignoreList = new ArrayList<String>();
        for (i = 0; i < 10; ++i) {
            String fileNamePattern = prefs.get(PROP_FILENAME_PATTERN_PREFIX + i, null);
            if (fileNamePattern == null) continue;
            this.fileNamePatterns.add(fileNamePattern);
        }
        if (this.fileNamePatterns.isEmpty()) {
            FindDialogMemory.addDefaultFileNamePatterns(this.fileNamePatterns);
        }
        i = 0;
        while ((item = prefs.get(PROP_IGNORE_LIST_PREFIX + i, null)) != null) {
            this.ignoreList.add(item);
            ++i;
        }
    }

    public void storeFileNamePattern(String pattern) {
        int index = this.fileNamePatterns.indexOf(pattern);
        if (index != -1) {
            if (index == this.fileNamePatterns.size() - 1) {
                return;
            }
            this.fileNamePatterns.remove(index);
        } else if (this.fileNamePatterns.size() == 10) {
            this.fileNamePatterns.remove(0);
        }
        this.fileNamePatterns.add(pattern);
        for (int i = 0; i < this.fileNamePatterns.size(); ++i) {
            prefs.put(PROP_FILENAME_PATTERN_PREFIX + i, this.fileNamePatterns.get(i));
        }
    }

    public List<String> getFileNamePatterns() {
        return this.fileNamePatterns != null ? this.fileNamePatterns : Collections.emptyList();
    }

    private static void addDefaultFileNamePatterns(List<String> l) {
        String[] patterns = new String[]{"*.properties", "*.txt", "*.php", "*.xml", "*.java"};
        int free = 10 - l.size();
        for (int i = 0; i < free && i < patterns.length; ++i) {
            l.add(patterns[i]);
        }
    }

    public boolean isWholeWords() {
        return this.wholeWords;
    }

    public void setWholeWords(boolean wholeWords) {
        this.wholeWords = wholeWords;
        prefs.putBoolean(PROP_WHOLE_WORDS, wholeWords);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isPreserveCase() {
        return this.preserveCase;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        prefs.putBoolean(PROP_CASE_SENSITIVE, caseSensitive);
    }

    public void setPreserveCase(boolean preserveCase) {
        this.preserveCase = preserveCase;
        prefs.putBoolean(PROP_PRESERVE_CASE, preserveCase);
    }

    public SearchPattern.MatchType getMatchType() {
        return this.matchType;
    }

    public void setMatchType(SearchPattern.MatchType matchType) {
        this.matchType = matchType;
        prefs.put(PROP_MATCH_TYPE, matchType.name());
    }

    public String getScopeTypeId() {
        return this.scopeTypeId;
    }

    public void setScopeTypeId(String scopeTypeId) {
        this.scopeTypeId = scopeTypeId;
        prefs.put(PROP_SCOPE_TYPE_ID, scopeTypeId);
    }

    public boolean isTextPatternSpecified() {
        return this.textPatternSpecified;
    }

    void setTextPatternSpecified(boolean specified) {
        this.textPatternSpecified = specified;
    }

    public boolean isReplacePatternSpecified() {
        return this.replacePatternSpecified;
    }

    public void setReplacePatternSpecified(boolean replacePatternSpecified) {
        this.replacePatternSpecified = replacePatternSpecified;
    }

    boolean isFileNamePatternSpecified() {
        return this.fileNamePatternSpecified;
    }

    public void setFileNamePatternSpecified(boolean specified) {
        this.fileNamePatternSpecified = specified;
        prefs.putBoolean(PROP_FILENAME_PATTERN_SPECIFIED, specified);
    }

    boolean isSearchInArchives() {
        return this.searchInArchives;
    }

    void setSearchInArchives(boolean searchInArchives) {
        this.searchInArchives = searchInArchives;
        prefs.putBoolean(PROP_SEARCH_IN_GENERATED, searchInArchives);
    }

    boolean isSearchInGenerated() {
        return this.searchInGenerated;
    }

    void setSearchInGenerated(boolean searchInGenerated) {
        this.searchInGenerated = searchInGenerated;
        prefs.putBoolean(PROP_SEARCH_IN_GENERATED, searchInGenerated);
    }

    boolean isFilePathRegex() {
        return this.filePathRegex;
    }

    void setFilePathRegex(boolean filePathRegex) {
        this.filePathRegex = filePathRegex;
        prefs.putBoolean(PROP_FILE_PATH_REGEX, filePathRegex);
    }

    boolean IsUseIgnoreList() {
        return this.useIgnoreList;
    }

    void setUseIgnoreList(boolean useIgnoreList) {
        this.useIgnoreList = useIgnoreList;
        prefs.putBoolean(PROP_USE_IGNORE_LIST, useIgnoreList);
    }

    String getTextSandboxContent() {
        return this.textSandboxContent;
    }

    void setTextSandboxContent(String textSandboxContent) {
        this.textSandboxContent = textSandboxContent;
        prefs.put(PROP_TEXT_SANDBOX_CONTENT, textSandboxContent);
    }

    String getPathSandboxContent() {
        return this.pathSandboxContent;
    }

    void setPathSandboxContent(String pathSandboxContent) {
        this.pathSandboxContent = pathSandboxContent;
        prefs.put(PROP_PATH_SANDBOX_CONTENT, pathSandboxContent);
    }

    List<String> getIgnoreList() {
        if (this.ignoreList == null) {
            return Collections.emptyList();
        }
        return this.ignoreList;
    }

    void setIgnoreList(List<String> ignoreList) {
        this.ignoreList = ignoreList;
        int i = 0;
        while (prefs.get(PROP_IGNORE_LIST_PREFIX + i, null) != null) {
            prefs.remove(PROP_IGNORE_LIST_PREFIX + i);
            ++i;
        }
        for (int j = 0; j < ignoreList.size(); ++j) {
            prefs.put(PROP_IGNORE_LIST_PREFIX + j, ignoreList.get(j));
        }
    }

    private String getText(String key) {
        return NbBundle.getMessage(FindDialogMemory.class, (String)key);
    }

    public String getResultsColumnWidths() {
        return this.resultsColumnWidths;
    }

    public void setResultsColumnWidths(String resultsColumnWidths) {
        this.resultsColumnWidths = resultsColumnWidths;
        prefs.put(PROP_RESULTS_COLUMN_WIDTHS, resultsColumnWidths);
    }

    public String getResultsColumnWidthsDetails() {
        return this.resultsColumnWidthsDetails;
    }

    public void setResultsColumnWidthsDetails(String resultsColumnWidthsDetails) {
        this.resultsColumnWidthsDetails = resultsColumnWidthsDetails;
        prefs.put(PROP_RESULTS_COLUMN_WIDTHS_DETAILS, resultsColumnWidthsDetails);
    }

    public String getResultsColumnWidthsReplacing() {
        return this.resultsColumnWidthsReplacing;
    }

    public void setResultsColumnWidthsReplacing(String resultsColumnWidthsReplacing) {
        this.resultsColumnWidthsReplacing = resultsColumnWidthsReplacing;
        prefs.put(PROP_RESULTS_COLUMN_WIDTHS_REPLACING, resultsColumnWidthsReplacing);
    }

    public int getReplaceResultsDivider() {
        return this.replaceResultsDivider;
    }

    public void setReplaceResultsDivider(int splitDividerLocation) {
        this.replaceResultsDivider = splitDividerLocation;
        prefs.putInt(PROP_REPLACE_RESULTS_DIVIDER, splitDividerLocation);
    }

    public String getResultsViewMode() {
        return this.resultsViewMode;
    }

    public void setResultsViewMode(String resultsViewMode) {
        this.resultsViewMode = resultsViewMode;
        prefs.put(PROP_RESULTS_VIEW_MODE, resultsViewMode);
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
        prefs.put(PROP_PROVIDER, provider);
    }

    public boolean isOpenInNewTab() {
        return this.openInNewTab;
    }

    public void setOpenInNewTab(boolean openInNewTab) {
        this.openInNewTab = openInNewTab;
        prefs.putBoolean(PROP_OPEN_IN_NEW_TAB, openInNewTab);
    }
}

