/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.properties;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.netbeans.jellytools.JellyVersion;
import org.netbeans.jellytools.properties.PropertySheetOperator;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.JTableOperator;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;
import org.openide.nodes.Node;

public class Property {
    public static final String STRING_RENDERER = "org.openide.explorer.propertysheet.RendererFactory$StringRenderer";
    public static final String CHECKBOX_RENDERER = "org.openide.explorer.propertysheet.RendererFactory$CheckboxRenderer";
    public static final String COMBOBOX_RENDERER = "org.openide.explorer.propertysheet.RendererFactory$ComboboxRenderer";
    public static final String RADIOBUTTON_RENDERER = "org.openide.explorer.propertysheet.RendererFactory$RadioButtonRenderer";
    public static final String SET_RENDERER = "org.openide.explorer.propertysheet.RendererFactory$SetRenderer";
    protected Node.Property property;
    protected PropertySheetOperator propertySheetOper;

    public Property(PropertySheetOperator propertySheetOper, String name) {
        this.propertySheetOper = propertySheetOper;
        this.property = this.waitProperty(propertySheetOper, name);
    }

    public Property(PropertySheetOperator propertySheetOper, int index) {
        this.propertySheetOper = propertySheetOper;
        this.property = this.waitProperty(propertySheetOper, index);
    }

    private Node.Property waitProperty(final PropertySheetOperator propSheetOper, final String name) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object param) {
                    Node.Property property = null;
                    JTableOperator table = propSheetOper.tblSheet();
                    for (int row = 0; row < table.getRowCount(); ++row) {
                        if (!(table.getValueAt(row, 1) instanceof Node.Property)) continue;
                        property = (Node.Property)table.getValueAt(row, 1);
                        if (!propSheetOper.getComparator().equals(property.getDisplayName(), name)) continue;
                        return property;
                    }
                    return null;
                }

                public String getDescription() {
                    return "Wait property " + name;
                }
            });
            return (Node.Property)waiter.waitAction(null);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted.", (Throwable)e);
        }
    }

    private Node.Property waitProperty(final PropertySheetOperator propSheetOper, final int index) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object param) {
                    JTableOperator table = propSheetOper.tblSheet();
                    if (table.getRowCount() <= index) {
                        return null;
                    }
                    Object property = table.getValueAt(index, 1);
                    if (property instanceof Node.Property) {
                        return (Node.Property)property;
                    }
                    throw new JemmyException("On row " + index + " in table there is no property");
                }

                public String getDescription() {
                    return "Wait property on row " + index + " in property sheet.";
                }
            });
            return (Node.Property)waiter.waitAction(null);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted.", (Throwable)e);
        }
    }

    public String getName() {
        return this.property.getDisplayName();
    }

    public String getValue() {
        return this.getPropertyEditor().getAsText();
    }

    public void setValue(final String textValue) {
        this.propertySheetOper.getOutput().printTrace("Setting value \"" + textValue + "\" of property \"" + this.getName() + "\".");
        if (!this.isEnabled()) {
            throw new JemmyException("Property \"" + this.getName() + "\" is read only.");
        }
        final PropertyEditor pe = this.getPropertyEditor();
        new QueueTool().invokeSmoothly(new Runnable(){

            @Override
            public void run() {
                try {
                    pe.setAsText(textValue);
                    Property.this.property.setValue(pe.getValue());
                }
                catch (IllegalAccessException iae) {
                    ErrorManager.getDefault().notify(256, (Throwable)iae);
                }
                catch (IllegalArgumentException iare) {
                    ErrorManager.getDefault().notify(256, (Throwable)iare);
                }
                catch (InvocationTargetException ite) {
                    ErrorManager.getDefault().notify(256, (Throwable)ite);
                }
                catch (Exception e) {
                    throw new JemmyException("Exception while setting value of property.", (Throwable)e);
                }
            }
        });
    }

    public void setValue(int index) {
        String[] tags = this.getPropertyEditor().getTags();
        if (tags == null) {
            throw new JemmyException("Property doesn't support changing value by index.");
        }
        this.setValue(tags[index]);
    }

    public void openEditor() {
        final JTableOperator table = this.propertySheetOper.tblSheet();
        table.makeComponentVisible();
        table.requestFocus();
        table.waitHasFocus();
        new Thread(new Runnable(){

            @Override
            public void run() {
                new QueueTool().invokeSmoothly(new Runnable(){

                    @Override
                    public void run() {
                        ((JTable)table.getSource()).changeSelection(Property.this.getRow(), 0, false, false);
                        if (Property.this.supportsCustomEditor()) {
                            Action customEditorAction = ((JComponent)table.getSource()).getActionMap().get("invokeCustomEditor");
                            customEditorAction.actionPerformed(new ActionEvent(table.getSource(), 0, null));
                        }
                    }
                });
            }
        }, "Thread to open custom editor no block").start();
    }

    public boolean supportsCustomEditor() {
        return this.getPropertyEditor().supportsCustomEditor();
    }

    public void setDefaultValue() {
        try {
            this.property.restoreDefaultValue();
        }
        catch (Exception e) {
            throw new JemmyException("Exception while restoring default value.", (Throwable)e);
        }
    }

    public boolean isEnabled() {
        return this.property.canWrite();
    }

    public boolean canEditAsText() {
        if (this.property.canRead() && this.property.canWrite()) {
            Boolean val = (Boolean)this.property.getValue("canEditAsText");
            if (val != null) {
                return val;
            }
            PropertyEditor pe = this.getPropertyEditor();
            if (pe instanceof EnhancedPropertyEditor && pe.getTags() != null) {
                return ((EnhancedPropertyEditor)pe).supportsEditingTaggedValues();
            }
            return pe.getTags() == null;
        }
        return false;
    }

    public String getRendererName() {
        return this.getRenderer().getClass().getName();
    }

    private Component getRenderer() {
        JTableOperator table = this.propertySheetOper.tblSheet();
        int row = this.getRow();
        TableCellRenderer renderer = table.getCellRenderer(row, 1);
        Component comp = renderer.getTableCellRendererComponent((JTable)table.getSource(), table.getValueAt(row, 1), false, false, row, 1);
        try {
            Class<?> clazz = Class.forName("org.openide.explorer.propertysheet.RendererPropertyDisplayer");
            Method findInnermostRendererMethod = clazz.getDeclaredMethod("findInnermostRenderer", JComponent.class);
            findInnermostRendererMethod.setAccessible(true);
            comp = (Component)findInnermostRendererMethod.invoke(null, comp);
        }
        catch (Exception e) {
            throw new JemmyException("RendererPropertyDisplayer.findInnermostRenderer() by reflection failed.", (Throwable)e);
        }
        return comp;
    }

    public String getShortDescription() {
        return this.property.getShortDescription();
    }

    public int getRow() {
        JTableOperator table = this.propertySheetOper.tblSheet();
        for (int row = 0; row < table.getRowCount(); ++row) {
            if (!(table.getValueAt(row, 1) instanceof Node.Property) || this.property != (Node.Property)table.getValueAt(row, 1)) continue;
            return row;
        }
        throw new JemmyException("Cannot determine row number of property \"" + this.getName() + "\"");
    }

    private PropertyEditor getPropertyEditor() {
        final AtomicReference atomicReference = new AtomicReference();
        new QueueTool().invokeSmoothly(new Runnable(){

            @Override
            public void run() {
                try {
                    Class<?> clazz = Class.forName("org.openide.explorer.propertysheet.PropUtils");
                    Method getPropertyEditorMethod = clazz.getDeclaredMethod("getPropertyEditor", Node.Property.class);
                    getPropertyEditorMethod.setAccessible(true);
                    atomicReference.set((PropertyEditor)getPropertyEditorMethod.invoke(null, Property.this.property));
                }
                catch (Exception e) {
                    throw new JemmyException("PropUtils.getPropertyEditor() by reflection failed.", (Throwable)e);
                }
            }
        });
        return (PropertyEditor)atomicReference.get();
    }

    static {
        JellyVersion.checkJemmyVersion();
    }
}

