/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.Utilities;
import org.netbeans.modules.hudson.ui.actions.Bundle;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;

public class PersistInstanceAction
extends AbstractAction
implements ContextAwareAction {
    private final Collection<? extends HudsonInstance> instances;

    public PersistInstanceAction() {
        this(Collections.emptyList());
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new PersistInstanceAction(actionContext.lookupAll(HudsonInstance.class));
    }

    private PersistInstanceAction(Collection<? extends HudsonInstance> instances) {
        super(Bundle.LBL_Persist_Instance());
        this.instances = instances;
        for (HudsonInstance hudsonInstance : instances) {
            if (!hudsonInstance.isPersisted()) continue;
            this.setEnabled(false);
            break;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (HudsonInstance hudsonInstance : this.instances) {
            Utilities.persistInstance((HudsonInstance)hudsonInstance);
        }
    }
}

