/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.parser;

import com.sun.xml.rpc.spi.tools.WSDLDocument;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import com.sun.xml.rpc.util.localization.Localizer;
import com.sun.xml.rpc.util.xml.NullEntityResolver;
import com.sun.xml.rpc.util.xml.XmlUtil;
import com.sun.xml.rpc.wsdl.document.Binding;
import com.sun.xml.rpc.wsdl.document.BindingFault;
import com.sun.xml.rpc.wsdl.document.BindingInput;
import com.sun.xml.rpc.wsdl.document.BindingOperation;
import com.sun.xml.rpc.wsdl.document.BindingOutput;
import com.sun.xml.rpc.wsdl.document.Definitions;
import com.sun.xml.rpc.wsdl.document.Documentation;
import com.sun.xml.rpc.wsdl.document.Fault;
import com.sun.xml.rpc.wsdl.document.Import;
import com.sun.xml.rpc.wsdl.document.Input;
import com.sun.xml.rpc.wsdl.document.Message;
import com.sun.xml.rpc.wsdl.document.MessagePart;
import com.sun.xml.rpc.wsdl.document.Operation;
import com.sun.xml.rpc.wsdl.document.OperationStyle;
import com.sun.xml.rpc.wsdl.document.Output;
import com.sun.xml.rpc.wsdl.document.Port;
import com.sun.xml.rpc.wsdl.document.PortType;
import com.sun.xml.rpc.wsdl.document.Service;
import com.sun.xml.rpc.wsdl.document.Types;
import com.sun.xml.rpc.wsdl.document.WSDLConstants;
import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import com.sun.xml.rpc.wsdl.document.schema.SchemaKinds;
import com.sun.xml.rpc.wsdl.framework.Entity;
import com.sun.xml.rpc.wsdl.framework.Extensible;
import com.sun.xml.rpc.wsdl.framework.ParseException;
import com.sun.xml.rpc.wsdl.framework.ParserContext;
import com.sun.xml.rpc.wsdl.framework.ParserListener;
import com.sun.xml.rpc.wsdl.parser.ExtensionHandler;
import com.sun.xml.rpc.wsdl.parser.HTTPExtensionHandler;
import com.sun.xml.rpc.wsdl.parser.MIMEExtensionHandler;
import com.sun.xml.rpc.wsdl.parser.SOAPExtensionHandler;
import com.sun.xml.rpc.wsdl.parser.SchemaExtensionHandler;
import com.sun.xml.rpc.wsdl.parser.SchemaParser;
import com.sun.xml.rpc.wsdl.parser.Util;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WSDLParser
implements com.sun.xml.rpc.spi.tools.WSDLParser {
    private boolean _followImports;
    private String _targetNamespaceURI;
    private Map _extensionHandlers = new HashMap();
    private ArrayList _listeners;
    private boolean _useWSIBasicProfile = false;
    private LocalizableMessageFactory _messageFactory = null;
    private Localizer _localizer;
    private HashSet hSet = new HashSet();

    public WSDLParser() {
        this.register(new SOAPExtensionHandler());
        this.register(new HTTPExtensionHandler());
        this.register(new MIMEExtensionHandler());
        this.register(new SchemaExtensionHandler());
    }

    public void register(ExtensionHandler h) {
        this._extensionHandlers.put(h.getNamespaceURI(), h);
        h.setExtensionHandlers(this._extensionHandlers);
    }

    public void unregister(ExtensionHandler h) {
        this._extensionHandlers.put(h.getNamespaceURI(), null);
        h.setExtensionHandlers(null);
    }

    public void unregister(String uri) {
        this._extensionHandlers.put(uri, null);
    }

    public boolean getFollowImports() {
        return this._followImports;
    }

    public void setFollowImports(boolean b) {
        this._followImports = b;
    }

    public WSDLDocument getWSDLDocument(URL wsdlURL) {
        return this.getWSDLDocumentInternal(wsdlURL);
    }

    private com.sun.xml.rpc.wsdl.document.WSDLDocument getWSDLDocumentInternal(URL wsdlURL) {
        BufferedInputStream wsdlInputStream = null;
        try {
            wsdlInputStream = new BufferedInputStream(wsdlURL.openStream());
        }
        catch (IOException e) {
            throw new ParseException("parsing.ioException", new LocalizableExceptionAdapter(e));
        }
        InputSource wsdlDocumentSource = new InputSource(wsdlInputStream);
        this.setFollowImports(true);
        this.addParserListener(new ParserListener(){

            public void ignoringExtension(QName name, QName parent) {
                if (parent.equals(WSDLConstants.QNAME_TYPES) && name.getLocalPart().equals("schema") && !name.getNamespaceURI().equals("")) {
                    WSDLParser.this.warn("wsdlmodeler.warning.ignoringUnrecognizedSchemaExtension", name.getNamespaceURI());
                }
            }

            public void doneParsingEntity(QName element, Entity entity) {
            }
        });
        com.sun.xml.rpc.wsdl.document.WSDLDocument wsdlDoc = this.parse(wsdlDocumentSource, true);
        Iterator importedDocs = wsdlDoc.getDefinitions().imports();
        wsdlDoc = this.parseImportedDocuments(importedDocs, wsdlDoc);
        try {
            ((InputStream)wsdlInputStream).close();
        }
        catch (IOException ioe) {
            throw new ParseException("parsing.ioException", new LocalizableExceptionAdapter(ioe));
        }
        return wsdlDoc;
    }

    private com.sun.xml.rpc.wsdl.document.WSDLDocument parseImportedDocuments(Iterator imports, com.sun.xml.rpc.wsdl.document.WSDLDocument wsdlDoc) {
        Definitions wsdlDefinitions = wsdlDoc.getDefinitions();
        Iterator iter = imports;
        while (iter.hasNext()) {
            Import mport = (Import)iter.next();
            try {
                com.sun.xml.rpc.wsdl.document.WSDLDocument importDoc = this.getWSDLDocumentInternal(new URL(mport.getLocation()));
                Definitions definitions = importDoc.getDefinitions();
                Iterator siter = definitions.services();
                while (siter.hasNext()) {
                    wsdlDefinitions.addServiceOveride((Service)siter.next());
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return wsdlDoc;
    }

    public void addParserListener(ParserListener l) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(l);
    }

    public void removeParserListener(ParserListener l) {
        if (this._listeners == null) {
            return;
        }
        this._listeners.remove(l);
    }

    public com.sun.xml.rpc.wsdl.document.WSDLDocument parse(InputSource source) {
        return this.parse(source, false);
    }

    public com.sun.xml.rpc.wsdl.document.WSDLDocument parse(InputSource source, boolean useWSIBasicProfile) {
        this._useWSIBasicProfile = useWSIBasicProfile;
        this._messageFactory = new LocalizableMessageFactory("com.sun.xml.rpc.resources.wsdl");
        this._localizer = new Localizer();
        com.sun.xml.rpc.wsdl.document.WSDLDocument document = new com.sun.xml.rpc.wsdl.document.WSDLDocument();
        document.setSystemId(source.getSystemId());
        ParserContext context = new ParserContext(document, this._listeners);
        context.setFollowImports(this._followImports);
        document.setDefinitions(this.parseDefinitions(context, source, null));
        return document;
    }

    protected Definitions parseDefinitions(ParserContext context, InputSource source, String expectedTargetNamespaceURI) {
        context.pushWSDLLocation();
        context.setWSDLLocation(source.getSystemId());
        Definitions definitions = this.parseDefinitionsNoImport(context, source, expectedTargetNamespaceURI);
        this.processImports(context, source, definitions);
        context.popWSDLLocation();
        return definitions;
    }

    protected void processImports(ParserContext context, InputSource source, Definitions definitions) {
        Iterator iter = definitions.imports();
        while (iter.hasNext()) {
            Import i = (Import)iter.next();
            String location = i.getLocation();
            if (location == null) continue;
            String adjustedLocation = source.getSystemId() == null ? (context.getDocument().getSystemId() == null ? location : Util.processSystemIdWithBase(context.getDocument().getSystemId(), location)) : Util.processSystemIdWithBase(source.getSystemId(), location);
            try {
                if (context.getDocument().isImportedDocument(adjustedLocation)) continue;
                context.getDocument().addImportedEntity(this.parseDefinitions(context, new InputSource(adjustedLocation), i.getNamespace()));
                context.getDocument().addImportedDocument(adjustedLocation);
            }
            catch (ParseException e) {
                if (e.getKey().equals("parsing.incorrectRootElement")) {
                    if (this._useWSIBasicProfile) {
                        this.warn("warning.wsi.r2001", adjustedLocation);
                    }
                    try {
                        SchemaParser parser = new SchemaParser();
                        context.getDocument().addImportedEntity(parser.parseSchema(context, new InputSource(adjustedLocation), i.getNamespace()));
                        continue;
                    }
                    catch (ParseException e2) {
                        if (e2.getKey().equals("parsing.incorrectRootElement")) {
                            Util.fail("parsing.unknownImportedDocumentType", location);
                            continue;
                        }
                        throw e2;
                    }
                }
                throw e;
            }
        }
    }

    protected Definitions parseDefinitionsNoImport(ParserContext context, InputSource source, String expectedTargetNamespaceURI) {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            builderFactory.setValidating(false);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException e) throws SAXParseException {
                    throw e;
                }

                public void fatalError(SAXParseException e) throws SAXParseException {
                    throw e;
                }

                public void warning(SAXParseException err) throws SAXParseException {
                }
            });
            builder.setEntityResolver(new NullEntityResolver());
            try {
                Document document = builder.parse(source);
                return this.parseDefinitionsNoImport(context, document, expectedTargetNamespaceURI);
            }
            catch (IOException e) {
                if (source.getSystemId() != null) {
                    throw new ParseException("parsing.ioExceptionWithSystemId", source.getSystemId(), new LocalizableExceptionAdapter(e));
                }
                throw new ParseException("parsing.ioException", new LocalizableExceptionAdapter(e));
            }
            catch (SAXException e) {
                if (source.getSystemId() != null) {
                    throw new ParseException("parsing.saxExceptionWithSystemId", source.getSystemId(), new LocalizableExceptionAdapter(e));
                }
                throw new ParseException("parsing.saxException", new LocalizableExceptionAdapter(e));
            }
        }
        catch (ParserConfigurationException e) {
            throw new ParseException("parsing.parserConfigException", new LocalizableExceptionAdapter(e));
        }
        catch (FactoryConfigurationError e) {
            throw new ParseException("parsing.factoryConfigException", new LocalizableExceptionAdapter(e));
        }
    }

    protected Definitions parseDefinitionsNoImport(ParserContext context, Document doc, String expectedTargetNamespaceURI) {
        this._targetNamespaceURI = null;
        Element root = doc.getDocumentElement();
        Util.verifyTagNSRootElement(root, WSDLConstants.QNAME_DEFINITIONS);
        return this.parseDefinitionsNoImport(context, root, expectedTargetNamespaceURI);
    }

    protected Definitions parseDefinitionsNoImport(ParserContext context, Element e, String expectedTargetNamespaceURI) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Definitions definitions = new Definitions(context.getDocument());
        String name = XmlUtil.getAttributeOrNull(e, "name");
        definitions.setName(name);
        this._targetNamespaceURI = XmlUtil.getAttributeOrNull(e, "targetNamespace");
        if (expectedTargetNamespaceURI != null && !expectedTargetNamespaceURI.equals(this._targetNamespaceURI) && this._useWSIBasicProfile) {
            this.warn("warning.wsi.r2002", new Object[]{this._targetNamespaceURI, expectedTargetNamespaceURI});
        }
        definitions.setTargetNamespaceURI(this._targetNamespaceURI);
        boolean gotDocumentation = false;
        boolean gotTypes = false;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                definitions.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_TYPES)) {
                if (gotTypes) {
                    Util.fail("parsing.onlyOneTypesAllowed", "definitions");
                }
                definitions.setTypes(this.parseTypes(context, definitions, e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_MESSAGE)) {
                Message message = this.parseMessage(context, definitions, e2);
                definitions.add(message);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_PORT_TYPE)) {
                PortType portType = this.parsePortType(context, definitions, e2);
                definitions.add(portType);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_BINDING)) {
                Binding binding = this.parseBinding(context, definitions, e2);
                definitions.add(binding);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_SERVICE)) {
                Service service = this.parseService(context, definitions, e2);
                definitions.add(service);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_IMPORT)) {
                definitions.add(this.parseImport(context, definitions, e2));
                continue;
            }
            if (this._useWSIBasicProfile && XmlUtil.matchesTagNS(e2, SchemaConstants.QNAME_IMPORT)) {
                this.warn("warning.wsi.r2003");
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, definitions, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_DEFINITIONS, definitions);
        return definitions;
    }

    protected Message parseMessage(ParserContext context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Message message = new Message(definitions);
        String name = Util.getRequiredAttribute(e, "name");
        message.setName(name);
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                message.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_PART)) {
                MessagePart part = this.parseMessagePart(context, e2);
                message.add(part);
                continue;
            }
            Util.fail("parsing.invalidElement", e2.getTagName(), e2.getNamespaceURI());
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_MESSAGE, message);
        return message;
    }

    protected MessagePart parseMessagePart(ParserContext context, Element e) {
        context.push();
        context.registerNamespaces(e);
        MessagePart part = new MessagePart();
        String partName = Util.getRequiredAttribute(e, "name");
        part.setName(partName);
        String elementAttr = XmlUtil.getAttributeOrNull(e, "element");
        String typeAttr = XmlUtil.getAttributeOrNull(e, "type");
        if (elementAttr != null) {
            if (typeAttr != null) {
                Util.fail("parsing.onlyOneOfElementOrTypeRequired", partName);
            }
            part.setDescriptor(context.translateQualifiedName(elementAttr));
            part.setDescriptorKind(SchemaKinds.XSD_ELEMENT);
        } else if (typeAttr != null) {
            part.setDescriptor(context.translateQualifiedName(typeAttr));
            part.setDescriptorKind(SchemaKinds.XSD_TYPE);
        } else {
            Util.fail("parsing.elementOrTypeRequired", partName);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_PART, part);
        return part;
    }

    protected PortType parsePortType(ParserContext context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        PortType portType = new PortType(definitions);
        String name = Util.getRequiredAttribute(e, "name");
        portType.setName(name);
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                portType.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_OPERATION)) {
                Operation op = this.parsePortTypeOperation(context, e2);
                portType.add(op);
                continue;
            }
            Util.fail("parsing.invalidElement", e2.getTagName(), e2.getNamespaceURI());
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_PORT_TYPE, portType);
        return portType;
    }

    protected Operation parsePortTypeOperation(ParserContext context, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Operation operation = new Operation();
        String name = Util.getRequiredAttribute(e, "name");
        operation.setName(name);
        String parameterOrderAttr = XmlUtil.getAttributeOrNull(e, "parameterOrder");
        operation.setParameterOrder(parameterOrderAttr);
        boolean gotDocumentation = false;
        boolean gotInput = false;
        boolean gotOutput = false;
        boolean gotFault = false;
        boolean inputBeforeOutput = false;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            Element e3;
            Iterator iter2;
            boolean gotDocumentation2;
            String nameAttr;
            String messageAttr;
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                operation.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_INPUT)) {
                if (gotInput) {
                    Util.fail("parsing.tooManyElements", new Object[]{"input", "operation", name});
                }
                context.push();
                context.registerNamespaces(e2);
                Input input = new Input();
                messageAttr = Util.getRequiredAttribute(e2, "message");
                input.setMessage(context.translateQualifiedName(messageAttr));
                nameAttr = XmlUtil.getAttributeOrNull(e2, "name");
                input.setName(nameAttr);
                operation.setInput(input);
                gotInput = true;
                if (gotOutput) {
                    inputBeforeOutput = false;
                }
                gotDocumentation2 = false;
                iter2 = XmlUtil.getAllChildren(e2);
                while (iter2.hasNext() && (e3 = Util.nextElement(iter2)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                        }
                        gotDocumentation2 = true;
                        input.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    Util.fail("parsing.invalidElement", e3.getTagName(), e3.getNamespaceURI());
                }
                context.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_OUTPUT)) {
                if (gotOutput) {
                    Util.fail("parsing.tooManyElements", new Object[]{"output", "operation", name});
                }
                context.push();
                context.registerNamespaces(e2);
                Output output = new Output();
                messageAttr = Util.getRequiredAttribute(e2, "message");
                output.setMessage(context.translateQualifiedName(messageAttr));
                nameAttr = XmlUtil.getAttributeOrNull(e2, "name");
                output.setName(nameAttr);
                operation.setOutput(output);
                gotOutput = true;
                if (gotInput) {
                    inputBeforeOutput = true;
                }
                gotDocumentation2 = false;
                iter2 = XmlUtil.getAllChildren(e2);
                while (iter2.hasNext() && (e3 = Util.nextElement(iter2)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                        }
                        gotDocumentation2 = true;
                        output.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    Util.fail("parsing.invalidElement", e3.getTagName(), e3.getNamespaceURI());
                }
                context.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_FAULT)) {
                context.push();
                context.registerNamespaces(e2);
                Fault fault = new Fault();
                messageAttr = Util.getRequiredAttribute(e2, "message");
                fault.setMessage(context.translateQualifiedName(messageAttr));
                nameAttr = XmlUtil.getAttributeOrNull(e2, "name");
                fault.setName(nameAttr);
                operation.addFault(fault);
                gotFault = true;
                gotDocumentation2 = false;
                iter2 = XmlUtil.getAllChildren(e2);
                while (iter2.hasNext() && (e3 = Util.nextElement(iter2)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                        }
                        gotDocumentation2 = true;
                        fault.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    Util.fail("parsing.invalidElement", e3.getTagName(), e3.getNamespaceURI());
                }
                context.pop();
                continue;
            }
            Util.fail("parsing.invalidElement", e2.getTagName(), e2.getNamespaceURI());
        }
        if (gotInput && !gotOutput && !gotFault) {
            operation.setStyle(OperationStyle.ONE_WAY);
        } else if (gotInput && gotOutput && inputBeforeOutput) {
            operation.setStyle(OperationStyle.REQUEST_RESPONSE);
        } else if (gotInput && gotOutput && !inputBeforeOutput) {
            operation.setStyle(OperationStyle.SOLICIT_RESPONSE);
        } else if (gotOutput && !gotInput && !gotFault) {
            operation.setStyle(OperationStyle.NOTIFICATION);
        } else {
            Util.fail("parsing.invalidOperationStyle", name);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_OPERATION, operation);
        return operation;
    }

    protected Binding parseBinding(ParserContext context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Binding binding = new Binding(definitions);
        String name = Util.getRequiredAttribute(e, "name");
        binding.setName(name);
        String typeAttr = Util.getRequiredAttribute(e, "type");
        binding.setPortType(context.translateQualifiedName(typeAttr));
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                binding.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_OPERATION)) {
                BindingOperation op = this.parseBindingOperation(context, e2);
                binding.add(op);
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, binding, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_BINDING, binding);
        return binding;
    }

    protected BindingOperation parseBindingOperation(ParserContext context, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        BindingOperation operation = new BindingOperation();
        String name = Util.getRequiredAttribute(e, "name");
        operation.setName(name);
        boolean gotDocumentation = false;
        boolean gotInput = false;
        boolean gotOutput = false;
        boolean gotFault = false;
        boolean inputBeforeOutput = false;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            Iterator iter2;
            String nameAttr;
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                operation.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_INPUT)) {
                Element e3;
                if (gotInput) {
                    Util.fail("parsing.tooManyElements", new Object[]{"input", "operation", name});
                }
                Iterator itere2 = XmlUtil.getAllChildren(e2);
                Element ee = Util.nextElement(itere2);
                if (this.hSet.isEmpty()) {
                    this.hSet.add(ee.getAttribute("use"));
                } else if (!this.hSet.contains(ee.getAttribute("use")) && ee.getAttribute("use") != "") {
                    this.hSet.add(ee.getAttribute("use"));
                }
                context.push();
                context.registerNamespaces(e2);
                BindingInput input = new BindingInput();
                String nameAttr2 = XmlUtil.getAttributeOrNull(e2, "name");
                input.setName(nameAttr2);
                operation.setInput(input);
                gotInput = true;
                if (gotOutput) {
                    inputBeforeOutput = false;
                }
                boolean gotDocumentation2 = false;
                Iterator iter22 = XmlUtil.getAllChildren(e2);
                while (iter22.hasNext() && (e3 = Util.nextElement(iter22)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                        }
                        gotDocumentation2 = true;
                        input.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    this.checkNotWsdlElement(e3);
                    if (this.handleExtension(context, input, e3)) continue;
                    this.checkNotWsdlRequired(e3);
                }
                context.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_OUTPUT)) {
                Element e3;
                if (gotOutput) {
                    Util.fail("parsing.tooManyElements", new Object[]{"output", "operation", name});
                }
                context.push();
                context.registerNamespaces(e2);
                BindingOutput output = new BindingOutput();
                nameAttr = XmlUtil.getAttributeOrNull(e2, "name");
                output.setName(nameAttr);
                operation.setOutput(output);
                gotOutput = true;
                if (gotInput) {
                    inputBeforeOutput = true;
                }
                boolean gotDocumentation2 = false;
                iter2 = XmlUtil.getAllChildren(e2);
                while (iter2.hasNext() && (e3 = Util.nextElement(iter2)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                        }
                        gotDocumentation2 = true;
                        output.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    this.checkNotWsdlElement(e3);
                    if (this.handleExtension(context, output, e3)) continue;
                    this.checkNotWsdlRequired(e3);
                }
                context.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_FAULT)) {
                Element e3;
                context.push();
                context.registerNamespaces(e2);
                BindingFault fault = new BindingFault();
                nameAttr = Util.getRequiredAttribute(e2, "name");
                fault.setName(nameAttr);
                operation.addFault(fault);
                gotFault = true;
                boolean gotDocumentation2 = false;
                iter2 = XmlUtil.getAllChildren(e2);
                while (iter2.hasNext() && (e3 = Util.nextElement(iter2)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                        }
                        gotDocumentation2 = true;
                        fault.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    this.checkNotWsdlElement(e3);
                    if (this.handleExtension(context, fault, e3)) continue;
                    this.checkNotWsdlRequired(e3);
                }
                context.pop();
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, operation, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        if (gotInput && !gotOutput && !gotFault) {
            operation.setStyle(OperationStyle.ONE_WAY);
        } else if (gotInput && gotOutput && inputBeforeOutput) {
            operation.setStyle(OperationStyle.REQUEST_RESPONSE);
        } else if (gotInput && gotOutput && !inputBeforeOutput) {
            operation.setStyle(OperationStyle.SOLICIT_RESPONSE);
        } else if (gotOutput && !gotInput && !gotFault) {
            operation.setStyle(OperationStyle.NOTIFICATION);
        } else {
            Util.fail("parsing.invalidOperationStyle", name);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_OPERATION, operation);
        return operation;
    }

    protected Import parseImport(ParserContext context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Import anImport = new Import();
        String namespace = Util.getRequiredAttribute(e, "namespace");
        anImport.setNamespace(namespace);
        String location = Util.getRequiredAttribute(e, "location");
        anImport.setLocation(location);
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                anImport.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            Util.fail("parsing.invalidElement", e2.getTagName(), e2.getNamespaceURI());
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_IMPORT, anImport);
        return anImport;
    }

    protected Service parseService(ParserContext context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Service service = new Service(definitions);
        String name = Util.getRequiredAttribute(e, "name");
        service.setName(name);
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                service.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_PORT)) {
                Port port = this.parsePort(context, definitions, e2);
                service.add(port);
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, service, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_SERVICE, service);
        return service;
    }

    protected Port parsePort(ParserContext context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Port port = new Port(definitions);
        String name = Util.getRequiredAttribute(e, "name");
        port.setName(name);
        String bindingAttr = Util.getRequiredAttribute(e, "binding");
        port.setBinding(context.translateQualifiedName(bindingAttr));
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                port.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, port, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_PORT, port);
        return port;
    }

    protected Types parseTypes(ParserContext context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Types types = new Types();
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                types.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (this._useWSIBasicProfile && XmlUtil.matchesTagNS(e2, SchemaConstants.QNAME_IMPORT)) {
                this.warn("warning.wsi.r2003");
                continue;
            }
            this.checkNotWsdlElement(e2);
            try {
                if (this.handleExtension(context, types, e2)) continue;
                this.checkNotWsdlRequired(e2);
            }
            catch (ParseException pe) {
                if (!pe.getKey().equals("parsing.incorrectRootElement")) continue;
                if (this._useWSIBasicProfile) {
                    this.warn("warning.wsi.r2004");
                }
                throw pe;
            }
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_TYPES, types);
        return types;
    }

    protected boolean handleExtension(ParserContext context, Extensible entity, Element e) {
        ExtensionHandler h = (ExtensionHandler)this._extensionHandlers.get(e.getNamespaceURI());
        if (h == null) {
            context.fireIgnoringExtension(new QName(e.getNamespaceURI(), e.getLocalName()), ((Entity)((Object)entity)).getElementName());
            return false;
        }
        return h.doHandleExtension(context, entity, e);
    }

    protected void checkNotWsdlElement(Element e) {
        if (e.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/")) {
            Util.fail("parsing.invalidWsdlElement", e.getTagName());
        }
    }

    protected void checkNotWsdlRequired(Element e) {
        String required = XmlUtil.getAttributeNSOrNull(e, "required", "http://schemas.xmlsoap.org/wsdl/");
        if (required != null && required.equals("true")) {
            Util.fail("parsing.requiredExtensibilityElement", e.getTagName(), e.getNamespaceURI());
        }
    }

    protected Documentation getDocumentationFor(Element e) {
        String s = XmlUtil.getTextForNode(e);
        if (s == null) {
            return null;
        }
        return new Documentation(s);
    }

    protected void error(String key) {
        System.err.println(this._localizer.localize(this._messageFactory.getMessage(key)));
    }

    public HashSet getUse() {
        return this.hSet;
    }

    protected void warn(String key) {
        System.err.println(this._localizer.localize(this._messageFactory.getMessage(key)));
    }

    protected void warn(String key, String arg) {
        System.err.println(this._localizer.localize(this._messageFactory.getMessage(key, arg)));
    }

    protected void warn(String key, Object[] args) {
        System.err.println(this._localizer.localize(this._messageFactory.getMessage(key, args)));
    }
}

