/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.editor.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.text.Document;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.smarty.editor.completion.TplCompletionItem;
import org.netbeans.modules.php.smarty.editor.completion.entries.SmartyCodeCompletionOffer;

public class TplCompletionQuery
extends UserTask {
    private Document document;
    private CompletionResult completionResult;

    public TplCompletionQuery(Document document) {
        this.document = document;
    }

    public CompletionResult query() throws ParseException {
        Source source = Source.create((Document)this.document);
        ParserManager.parse(Collections.singleton(source), (UserTask)this);
        return this.completionResult;
    }

    public void run(ResultIterator resultIterator) throws Exception {
        String resultMimeType = resultIterator.getSnapshot().getMimeType();
        if (resultMimeType.equals("text/x-tpl")) {
            this.completionResult = this.query(resultIterator);
        }
    }

    private CompletionResult query(ResultIterator resultIterator) {
        return new CompletionResult(SmartyCodeCompletionOffer.getFunctions(), SmartyCodeCompletionOffer.getVariableModifiers(), SmartyCodeCompletionOffer.getFunctionParameters());
    }

    public static class CompletionResult {
        private ArrayList<TplCompletionItem> functions;
        private ArrayList<TplCompletionItem> variableModifiers;
        private HashMap<String, ArrayList<TplCompletionItem>> functionParams;

        CompletionResult(ArrayList<TplCompletionItem> functions, ArrayList<TplCompletionItem> variableModifiers, HashMap<String, ArrayList<TplCompletionItem>> functionParams) {
            this.functions = functions;
            this.variableModifiers = variableModifiers;
            this.functionParams = functionParams;
        }

        public ArrayList<TplCompletionItem> getFunctions() {
            return this.functions;
        }

        public ArrayList<TplCompletionItem> getVariableModifiers() {
            return this.variableModifiers;
        }

        public ArrayList<TplCompletionItem> getParamsForCommand(ArrayList<String> commands) {
            ArrayList<TplCompletionItem> availableItems = new ArrayList<TplCompletionItem>((Collection)this.functionParams.get(commands.get(0)));
            Iterator it = availableItems.iterator();
            block0: while (it.hasNext()) {
                TplCompletionItem tplCompletionItem = (TplCompletionItem)it.next();
                for (String command : commands) {
                    if (!tplCompletionItem.getItemText().equals(command)) continue;
                    it.remove();
                    continue block0;
                }
            }
            return availableItems;
        }
    }
}

