/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.features;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.filters.JavaTypeFilter;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.lib.profiler.ui.swing.SmallButton;
import org.netbeans.lib.profiler.ui.swing.TextArea;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.api.project.ProjectContentsSupport;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.features.Bundle;
import org.netbeans.modules.profiler.v2.features.FeatureMode;
import org.netbeans.modules.profiler.v2.impl.ClassMethodList;
import org.netbeans.modules.profiler.v2.impl.ClassMethodSelector;
import org.netbeans.modules.profiler.v2.impl.FilterSelector;
import org.netbeans.modules.profiler.v2.impl.ProjectsSelector;
import org.netbeans.modules.profiler.v2.ui.SettingsPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

final class MethodsFeatureModes {
    MethodsFeatureModes() {
    }

    private static String getFlatValues(String[] values) {
        StringBuilder convertedValue = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            String filterValue = values[i].trim();
            if (i != values.length - 1 && !filterValue.endsWith(",")) {
                filterValue = filterValue + ",";
            }
            convertedValue.append(filterValue);
        }
        return convertedValue.toString();
    }

    private static Component createStrut(JComponent c, int width, boolean before) {
        Insets i;
        Border b = c.getBorder();
        Insets insets = i = b != null ? b.getBorderInsets(c) : null;
        int w = i == null ? width : Math.max(width - (before ? i.left : i.right), 0);
        return Box.createHorizontalStrut(w);
    }

    static abstract class CustomClassesMode
    extends MethodsMode {
        private static final String CLASSES_FLAG = "CLASSES_FLAG";
        private static final String FILTER_FLAG = "FILTER_FLAG";
        private static final String FILTER_MODE_FLAG = "FILTER_MODE_FLAG";
        private static final int MIN_ROWS = 2;
        private static final int MAX_ROWS = 15;
        private static final int DEFAULT_ROWS = 3;
        private static final int MIN_COLUMNS = 10;
        private static final int MAX_COLUMNS = 100;
        private static final int DEFAULT_COLUMNS = 40;
        private JComponent ui;
        private TextArea classesArea;
        private TextArea filterArea;
        private JRadioButton includeChoice;
        private JRadioButton excludeChoice;

        CustomClassesMode() {
        }

        @Override
        String getID() {
            return "CustomMethodsMode";
        }

        @Override
        String getName() {
            return Bundle.MethodsFeatureModes_definedClasses();
        }

        @Override
        void configureSettings(ProfilingSettings settings) {
            assert (SwingUtilities.isEventDispatchThread());
            super.configureSettings(settings);
            settings.setProfilingType(16);
            settings.setCPUProfilingType(settings.getSamplingInterval() <= 0 ? 0 : 1);
            String[] rootsLines = this.readFlag(CLASSES_FLAG, "").split("\\n");
            String[] rootsValues = GenericFilter.values((String)MethodsFeatureModes.getFlatValues(rootsLines));
            ClientUtils.SourceCodeSelection[] roots = rootsValues.length == 1 && rootsValues[0].isEmpty() ? new ClientUtils.SourceCodeSelection[]{} : new ClientUtils.SourceCodeSelection[rootsValues.length];
            for (int i = 0; i < roots.length; ++i) {
                roots[i] = new ClientUtils.SourceCodeSelection(rootsValues[i], "*", null);
            }
            settings.addRootMethods(roots);
            String filter = this.readFlag(FILTER_FLAG, "");
            if (filter.isEmpty() || "*".equals(filter) || "**".equals(filter)) {
                settings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter());
            } else {
                int filterType = Boolean.parseBoolean(this.readFlag(FILTER_MODE_FLAG, Boolean.TRUE.toString())) ? 10 : 20;
                String filterValue = MethodsFeatureModes.getFlatValues(filter.split("\\n"));
                settings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter(filterValue, filterType));
            }
            settings.setStackDepthLimit(Integer.MAX_VALUE);
        }

        @Override
        void confirmSettings() {
            if (this.ui != null) {
                assert (SwingUtilities.isEventDispatchThread());
                String classes = this.classesArea.showsHint() ? "" : this.classesArea.getText().trim();
                this.storeFlag(CLASSES_FLAG, classes.isEmpty() ? null : classes);
                String filter = this.filterArea.showsHint() ? "" : this.filterArea.getText().trim();
                this.storeFlag(FILTER_FLAG, filter.isEmpty() ? null : filter);
                boolean filterMode = this.includeChoice.isSelected();
                this.storeFlag(FILTER_MODE_FLAG, filterMode ? null : Boolean.FALSE.toString());
            }
        }

        @Override
        boolean pendingChanges() {
            if (this.ui != null) {
                String filter;
                String classes;
                assert (SwingUtilities.isEventDispatchThread());
                String string = classes = this.classesArea.showsHint() ? "" : this.classesArea.getText().trim();
                if (!classes.equals(this.readFlag(CLASSES_FLAG, ""))) {
                    return true;
                }
                String string2 = filter = this.filterArea.showsHint() ? "" : this.filterArea.getText().trim();
                if (!filter.equals(this.readFlag(FILTER_FLAG, ""))) {
                    return true;
                }
                if (Boolean.parseBoolean(this.readFlag(FILTER_MODE_FLAG, Boolean.TRUE.toString())) != this.includeChoice.isSelected()) {
                    return true;
                }
            }
            return false;
        }

        @Override
        boolean currentSettingsValid() {
            assert (SwingUtilities.isEventDispatchThread());
            return !(this.ui != null ? this.classesArea.showsHint() || this.classesArea.getText().trim().isEmpty() : this.readFlag(CLASSES_FLAG, "").isEmpty());
        }

        @Override
        JComponent getUI() {
            if (this.ui == null) {
                JPanel p = new JPanel(new GridBagLayout());
                p.setOpaque(false);
                SettingsPanel classesPanel = new SettingsPanel();
                classesPanel.add(new JLabel(Bundle.MethodsFeatureModes_classesLbl()));
                GridBagConstraints c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 0;
                c.fill = 0;
                c.insets = new Insets(0, 0, 0, 5);
                c.anchor = 18;
                p.add((Component)classesPanel, c);
                class Resizer {
                    private TextArea area1;
                    private TextArea area2;
                    private JComponent container1;
                    private JComponent container2;

                    Resizer() {
                    }

                    void setContext(TextArea area1, TextArea area2, JComponent container1, JComponent container2) {
                        this.area1 = area1;
                        this.area2 = area2;
                        this.container1 = container1;
                        this.container2 = container2;
                    }

                    void resize() {
                        this.area1.setColumns(CustomClassesMode.this.readColumns1());
                        this.area2.setColumns(CustomClassesMode.this.readColumns2());
                        int rows = CustomClassesMode.this.readRows();
                        this.area1.setRows(rows);
                        this.area2.setRows(rows);
                        this.area1.invalidate();
                        this.area2.invalidate();
                        this.container1.setPreferredSize(null);
                        this.container1.setPreferredSize(this.container1.getPreferredSize());
                        this.container1.setMinimumSize(this.container1.getPreferredSize());
                        this.container2.setPreferredSize(null);
                        this.container2.setPreferredSize(this.container2.getPreferredSize());
                        this.container2.setMinimumSize(this.container2.getPreferredSize());
                        JRootPane root = SwingUtilities.getRootPane(this.container1);
                        root.doLayout();
                        root.repaint();
                        this.area1.setColumns(0);
                        this.area2.setColumns(0);
                    }
                }
                final Resizer resizer = new Resizer();
                this.classesArea = new TextArea(this.readFlag(CLASSES_FLAG, "")){
                    {
                        super(x0);
                    }

                    protected void changed() {
                        CustomClassesMode.this.settingsChanged();
                    }

                    protected boolean changeSize(boolean vertical, boolean direction) {
                        if (vertical) {
                            int rows = CustomClassesMode.this.readRows();
                            rows = direction ? Math.min(rows + 1, 15) : Math.max(rows - 1, 2);
                            CustomClassesMode.this.storeRows(rows);
                        } else {
                            int cols = CustomClassesMode.this.readColumns1();
                            cols = direction ? Math.min(cols + 3, 100) : Math.max(cols - 3, 10);
                            CustomClassesMode.this.storeColumns1(cols);
                        }
                        resizer.resize();
                        return true;
                    }

                    protected boolean resetSize() {
                        CustomClassesMode.this.storeRows(3);
                        CustomClassesMode.this.storeColumns1(40);
                        resizer.resize();
                        return true;
                    }

                    protected void customizePopup(JPopupMenu popup) {
                        popup.addSeparator();
                        popup.add(this.createResizeMenu());
                    }

                    public Point getToolTipLocation(MouseEvent event) {
                        Container scroll = this.getParent().getParent();
                        return SwingUtilities.convertPoint(scroll, 0, scroll.getHeight(), (Component)((Object)this));
                    }
                };
                this.classesArea.setFont(new Font("Monospaced", 0, this.classesArea.getFont().getSize()));
                this.classesArea.setRows(this.readRows());
                this.classesArea.setColumns(this.readColumns1());
                JScrollPane classesScroll = new JScrollPane((Component)this.classesArea);
                classesScroll.setPreferredSize(classesScroll.getPreferredSize());
                classesScroll.setMinimumSize(classesScroll.getPreferredSize());
                this.classesArea.setColumns(0);
                this.classesArea.setHint(Bundle.MethodsFeatureModes_classesHint());
                this.classesArea.setToolTipText(Bundle.MethodsFeatureModes_classesTooltip());
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 0;
                c.gridheight = 0;
                c.weightx = 0.5;
                c.weighty = 1.0;
                c.fill = 3;
                c.insets = new Insets(0, 0, 0, 10);
                c.anchor = 18;
                p.add((Component)classesScroll, c);
                boolean filterMode = Boolean.TRUE.toString().equals(this.readFlag(FILTER_MODE_FLAG, Boolean.TRUE.toString()));
                ButtonGroup bg = new ButtonGroup();
                SettingsPanel filterPanel = new SettingsPanel();
                this.includeChoice = new JRadioButton(Bundle.MethodsFeatureModes_includeCalls()){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        CustomClassesMode.this.settingsChanged();
                    }
                };
                this.includeChoice.setToolTipText(Bundle.MethodsFeatureModes_includeTooltip());
                Border b = this.includeChoice.getBorder();
                Insets i = b != null ? b.getBorderInsets(this.includeChoice) : null;
                this.includeChoice.setOpaque(false);
                bg.add(this.includeChoice);
                this.includeChoice.setSelected(filterMode);
                filterPanel.add(this.includeChoice);
                c = new GridBagConstraints();
                c.gridx = 2;
                c.gridy = 0;
                c.fill = 0;
                c.insets = i == null ? new Insets(0, 0, 0, 0) : new Insets(0, 1 - i.left, 0, 1 - i.right);
                c.anchor = 18;
                p.add((Component)filterPanel, c);
                this.excludeChoice = new JRadioButton(Bundle.MethodsFeatureModes_excludeCalls()){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        CustomClassesMode.this.settingsChanged();
                    }
                };
                this.excludeChoice.setToolTipText(Bundle.MethodsFeatureModes_excludeTooltip());
                b = this.excludeChoice.getBorder();
                i = b != null ? b.getBorderInsets(this.excludeChoice) : null;
                this.excludeChoice.setOpaque(false);
                bg.add(this.excludeChoice);
                this.excludeChoice.setSelected(!filterMode);
                c = new GridBagConstraints();
                c.gridx = 2;
                c.gridy = 1;
                c.fill = 0;
                c.insets = i == null ? new Insets(0, 0, 0, 0) : new Insets(1 - i.top, 1 - i.left, 0, 1 - i.right);
                c.anchor = 18;
                p.add((Component)this.excludeChoice, c);
                this.filterArea = new TextArea(this.readFlag(FILTER_FLAG, "")){
                    {
                        super(x0);
                    }

                    protected void changed() {
                        CustomClassesMode.this.settingsChanged();
                    }

                    protected boolean changeSize(boolean vertical, boolean direction) {
                        if (vertical) {
                            int rows = CustomClassesMode.this.readRows();
                            rows = direction ? Math.min(rows + 1, 15) : Math.max(rows - 1, 2);
                            CustomClassesMode.this.storeRows(rows);
                        } else {
                            int cols = CustomClassesMode.this.readColumns2();
                            cols = direction ? Math.min(cols + 3, 100) : Math.max(cols - 3, 10);
                            CustomClassesMode.this.storeColumns2(cols);
                        }
                        resizer.resize();
                        return true;
                    }

                    protected boolean resetSize() {
                        CustomClassesMode.this.storeRows(3);
                        CustomClassesMode.this.storeColumns2(40);
                        resizer.resize();
                        return true;
                    }

                    protected void customizePopup(JPopupMenu popup) {
                        popup.addSeparator();
                        popup.add(this.createResizeMenu());
                    }

                    public Point getToolTipLocation(MouseEvent event) {
                        Container scroll = this.getParent().getParent();
                        return SwingUtilities.convertPoint(scroll, 0, scroll.getHeight(), (Component)((Object)this));
                    }
                };
                this.filterArea.setFont(new Font("Monospaced", 0, this.classesArea.getFont().getSize()));
                this.filterArea.setRows(this.readRows());
                this.filterArea.setColumns(this.readColumns2());
                JScrollPane filterScroll = new JScrollPane((Component)this.filterArea);
                filterScroll.setPreferredSize(filterScroll.getPreferredSize());
                filterScroll.setMinimumSize(filterScroll.getPreferredSize());
                this.filterArea.setColumns(0);
                this.filterArea.setHint(Bundle.MethodsFeatureModes_filterHint());
                this.filterArea.setToolTipText(Bundle.MethodsFeatureModes_filterTooltip());
                c = new GridBagConstraints();
                c.gridx = 3;
                c.gridy = 0;
                c.gridheight = 0;
                c.weightx = 0.5;
                c.weighty = 1.0;
                c.fill = 3;
                c.insets = new Insets(0, 4, 0, 1);
                c.anchor = 18;
                p.add((Component)filterScroll, c);
                resizer.setContext(this.classesArea, this.filterArea, classesScroll, filterScroll);
                this.ui = p;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CustomClassesMode.this.settingsChanged();
                    }
                });
            }
            return this.ui;
        }

        private int readRows() {
            return NbPreferences.forModule(MethodsFeatureModes.class).getInt("MethodsFeatureModes.rows", 3);
        }

        private void storeRows(int rows) {
            NbPreferences.forModule(MethodsFeatureModes.class).putInt("MethodsFeatureModes.rows", rows);
        }

        private int readColumns1() {
            return NbPreferences.forModule(MethodsFeatureModes.class).getInt("MethodsFeatureModes.columns1", 40);
        }

        private void storeColumns1(int columns) {
            NbPreferences.forModule(MethodsFeatureModes.class).putInt("MethodsFeatureModes.columns1", columns);
        }

        private int readColumns2() {
            return NbPreferences.forModule(MethodsFeatureModes.class).getInt("MethodsFeatureModes.columns2", 40);
        }

        private void storeColumns2(int columns) {
            NbPreferences.forModule(MethodsFeatureModes.class).putInt("MethodsFeatureModes.columns2", columns);
        }
    }

    static abstract class SelectedMethodsMode
    extends InstrMethodsMode {
        SelectedMethodsMode() {
        }

        abstract void selectForProfiling(Collection<SourceMethodInfo> var1);

        @Override
        String getID() {
            return "SelectedMethodsMode";
        }

        @Override
        String getName() {
            return Bundle.MethodsFeatureModes_selectedMethods();
        }

        @Override
        protected int getOutgoingCallsMaximum() {
            return 99;
        }

        @Override
        protected String noSelectionString() {
            return Bundle.MethodsFeatureModes_noMethodSelected();
        }

        @Override
        protected String oneSelectionString() {
            return Bundle.MethodsFeatureModes_oneMethodSelected();
        }

        @Override
        protected String multipleSelectionsString(int count) {
            return Bundle.MethodsFeatureModes_multipleMethodsSelected(count);
        }

        @Override
        protected Icon getAddIcon() {
            String iconMask = "LanguageIcons.Method";
            Image baseIcon = Icons.getImage((String)iconMask);
            Image addBadge = Icons.getImage((String)"GeneralIcons.BadgeAdd");
            Image addImage = ImageUtilities.mergeImages((Image)baseIcon, (Image)addBadge, (int)0, (int)0);
            return ImageUtilities.image2Icon((Image)addImage);
        }

        @Override
        protected String getAddTooltip() {
            return Bundle.MethodsFeatureModes_addMethod();
        }

        @Override
        protected void performAddSelection() {
            this.selectForProfiling(ClassMethodSelector.selectMethods(this.getSession()));
        }

        @Override
        protected void performEditSelection(Component invoker) {
            ClassMethodList.showMethods(this.getSession(), this.getSelection(), invoker);
        }
    }

    static abstract class SelectedClassesMode
    extends InstrMethodsMode {
        SelectedClassesMode() {
        }

        abstract void selectForProfiling(Collection<SourceClassInfo> var1);

        @Override
        String getID() {
            return "SelectedClassesMode";
        }

        @Override
        String getName() {
            return Bundle.MethodsFeatureModes_selectedClasses();
        }

        @Override
        protected int getOutgoingCallsMaximum() {
            return 10;
        }

        @Override
        protected String noSelectionString() {
            return Bundle.MethodsFeatureModes_noClassSelected();
        }

        @Override
        protected String oneSelectionString() {
            return Bundle.MethodsFeatureModes_oneClassSelected();
        }

        @Override
        protected String multipleSelectionsString(int count) {
            return Bundle.MethodsFeatureModes_multipleClassesSelected(count);
        }

        @Override
        protected Icon getAddIcon() {
            String iconMask = "LanguageIcons.Class";
            Image baseIcon = Icons.getImage((String)iconMask);
            Image addBadge = Icons.getImage((String)"GeneralIcons.BadgeAdd");
            Image addImage = ImageUtilities.mergeImages((Image)baseIcon, (Image)addBadge, (int)0, (int)0);
            return ImageUtilities.image2Icon((Image)addImage);
        }

        @Override
        protected String getAddTooltip() {
            return Bundle.MethodsFeatureModes_addClass();
        }

        @Override
        protected void performAddSelection() {
            this.selectForProfiling(ClassMethodSelector.selectClasses(this.getSession()));
        }

        @Override
        protected void performEditSelection(Component invoker) {
            ClassMethodList.showClasses(this.getSession(), this.getSelection(), invoker);
        }
    }

    private static abstract class InstrMethodsMode
    extends MethodsMode {
        private static final String CORE_JAVA_FILTER = "apple.laf.**, apple.awt.**, com.apple.**, com.sun.**, java.**, javax.**, sun.**, sunw.**, org.omg.CORBA.**, org.omg.CosNaming.**, COM.rsa.**";
        private static final String OUTGOING_CALLS_ENABLED_FLAG = "OUTGOING_CALLS_ENABLED_FLAG";
        private static final String OUTGOING_CALLS_FLAG = "OUTGOING_CALLS_FLAG";
        private static final String SKIP_JAVA_FLAG = "SKIP_JAVA_FLAG";
        private static final String FILTER_CALLS_FLAG = "FILTER_CALLS_FLAG";
        private static final String FILTER_CALLS_VALUE_FLAG = "FILTER_CALLS_VALUE_FLAG";
        private static final String SELECTION_FLAG = "SELECTION_FLAG";
        private static final Integer OUTGOING_CALLS_DEFAULT = 5;
        private FeatureMode.Selection selection;
        private FilterSelector.FilterName filterName;
        private String filterValue;
        private boolean lastOutgoingSelected;
        private JComponent ui;
        private JPanel selectionContent;
        private JPanel noSelectionContent;
        private JLabel outgoingLabel;
        private JCheckBox outgoingChoice;
        private JLabel outgoingHint;
        private JSpinner outgoingSpinner;
        private JButton addSelectionButton;
        private JButton editSelectionLink;
        private JButton filterLink;

        private InstrMethodsMode() {
        }

        abstract void selectionChanging();

        abstract void selectionChanged();

        abstract ProfilerSession getSession();

        @Override
        void initialize() {
            String filter;
            String excludeJava = this.readFlag(SKIP_JAVA_FLAG, null);
            if (excludeJava != null) {
                boolean _excludeJava = Boolean.TRUE.toString().equals(excludeJava);
                this.storeFlag(SKIP_JAVA_FLAG, null);
                if (!_excludeJava) {
                    this.storeFlag(FILTER_CALLS_FLAG, FilterSelector.FilterName.NO_FILTER.name());
                }
            }
            if ((filter = this.readFlag(FILTER_CALLS_FLAG, null)) != null) {
                this.filterName = FilterSelector.FilterName.valueOf(filter);
            }
            if (this.filterName == null) {
                this.filterName = FilterSelector.FilterName.EXCLUDE_JAVA_FILTER;
            }
            this.filterValue = this.readFlag(FILTER_CALLS_VALUE_FLAG, "");
        }

        @Override
        void configureSettings(ProfilingSettings settings) {
            assert (SwingUtilities.isEventDispatchThread());
            super.configureSettings(settings);
            settings.setProfilingType(16);
            settings.setCPUProfilingType(settings.getSamplingInterval() <= 0 ? 0 : 1);
            String filterType = this.readFlag(FILTER_CALLS_FLAG, FilterSelector.FilterName.EXCLUDE_JAVA_FILTER.name());
            if (FilterSelector.FilterName.NO_FILTER.name().equals(filterType)) {
                settings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter());
            } else if (FilterSelector.FilterName.EXCLUDE_JAVA_FILTER.name().equals(filterType)) {
                settings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter(CORE_JAVA_FILTER, 20));
            } else {
                String filterStrings = this.readFlag(FILTER_CALLS_VALUE_FLAG, CORE_JAVA_FILTER);
                if (filterStrings.isEmpty() || "*".equals(filterStrings) || "**".equals(filterStrings)) {
                    settings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter());
                } else {
                    filterStrings = MethodsFeatureModes.getFlatValues(filterStrings.split("\\n"));
                    if (FilterSelector.FilterName.EXCLUDE_CUSTOM_FILTER.name().equals(filterType)) {
                        settings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter(filterStrings, 20));
                    } else if (FilterSelector.FilterName.INCLUDE_CUSTOM_FILTER.name().equals(filterType)) {
                        settings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter(filterStrings, 10));
                    }
                }
            }
            HashSet<ClientUtils.SourceCodeSelection> _sel = this.getSelection();
            ClientUtils.SourceCodeSelection[] classes = _sel.toArray(new ClientUtils.SourceCodeSelection[0]);
            settings.addRootMethods(classes);
            if (Boolean.parseBoolean(this.readFlag(OUTGOING_CALLS_ENABLED_FLAG, Boolean.TRUE.toString()))) {
                settings.setStackDepthLimit(Integer.parseInt(this.readFlag(OUTGOING_CALLS_FLAG, OUTGOING_CALLS_DEFAULT.toString())));
            } else {
                settings.setStackDepthLimit(Integer.MAX_VALUE);
            }
        }

        @Override
        void confirmSettings() {
            if (this.ui != null) {
                assert (SwingUtilities.isEventDispatchThread());
                this.storeFlag(OUTGOING_CALLS_ENABLED_FLAG, this.lastOutgoingSelected ? null : Boolean.FALSE.toString());
                String outgoingCalls = this.outgoingSpinner.getValue().toString();
                this.storeFlag(OUTGOING_CALLS_FLAG, OUTGOING_CALLS_DEFAULT.toString().equals(outgoingCalls) ? null : outgoingCalls);
                String filter = FilterSelector.FilterName.EXCLUDE_JAVA_FILTER.equals((Object)this.filterName) ? null : this.filterName.name();
                this.storeFlag(FILTER_CALLS_FLAG, filter);
                this.storeFlag(FILTER_CALLS_VALUE_FLAG, this.filterValue.isEmpty() ? null : this.filterValue);
                this.saveSelection();
            }
        }

        @Override
        boolean pendingChanges() {
            if (this.ui != null) {
                assert (SwingUtilities.isEventDispatchThread());
                if (Boolean.parseBoolean(this.readFlag(OUTGOING_CALLS_ENABLED_FLAG, Boolean.TRUE.toString())) != this.lastOutgoingSelected) {
                    return true;
                }
                if (!this.outgoingSpinner.getValue().toString().equals(this.readFlag(OUTGOING_CALLS_FLAG, OUTGOING_CALLS_DEFAULT.toString()))) {
                    return true;
                }
                String filter = this.readFlag(FILTER_CALLS_FLAG, FilterSelector.FilterName.EXCLUDE_JAVA_FILTER.name());
                if (!filter.equals(this.filterName.name())) {
                    return true;
                }
                if (!this.readFlag(FILTER_CALLS_VALUE_FLAG, "").equals(this.filterValue)) {
                    return true;
                }
                if (!this.initSelection(false).equals(this.getSelection())) {
                    return true;
                }
            }
            return false;
        }

        @Override
        boolean currentSettingsValid() {
            assert (SwingUtilities.isEventDispatchThread());
            if (this.ui != null) {
                if ((FilterSelector.FilterName.EXCLUDE_CUSTOM_FILTER.equals((Object)this.filterName) || FilterSelector.FilterName.INCLUDE_CUSTOM_FILTER.equals((Object)this.filterName)) && this.filterValue.isEmpty()) {
                    return false;
                }
            } else {
                String filter = this.readFlag(FILTER_CALLS_FLAG, FilterSelector.FilterName.EXCLUDE_JAVA_FILTER.name());
                if ((FilterSelector.FilterName.EXCLUDE_CUSTOM_FILTER.name().equals(filter) || FilterSelector.FilterName.INCLUDE_CUSTOM_FILTER.name().equals(filter)) && this.readFlag(FILTER_CALLS_VALUE_FLAG, "").isEmpty()) {
                    return false;
                }
            }
            return !this.getSelection().isEmpty();
        }

        HashSet<ClientUtils.SourceCodeSelection> getSelection() {
            if (this.selection == null) {
                this.selection = this.initSelection(true);
            }
            return this.selection;
        }

        private FeatureMode.Selection initSelection(boolean events) {
            FeatureMode.Selection sel = new FeatureMode.Selection(){

                @Override
                protected void changing() {
                    InstrMethodsMode.this.selectionChanging();
                }

                @Override
                protected void changed() {
                    InstrMethodsMode.this.selectionChanged();
                    InstrMethodsMode.this.updateSelectionCustomizer();
                }
            };
            sel.disableEvents();
            String _sel = this.readFlag(SELECTION_FLAG, null);
            if (_sel != null) {
                for (String s : _sel.split(" ")) {
                    sel.add(ClientUtils.stringToSelection((String)s));
                }
            }
            if (events) {
                sel.enableEvents();
            }
            return sel;
        }

        private void saveSelection() {
            if (this.selection != null) {
                StringBuilder b = new StringBuilder();
                for (ClientUtils.SourceCodeSelection sel : this.selection) {
                    b.append(ClientUtils.selectionToString((ClientUtils.SourceCodeSelection)sel));
                    b.append(" ");
                }
                String sel = b.toString();
                this.storeFlag(SELECTION_FLAG, sel.isEmpty() ? null : sel);
            }
        }

        protected abstract int getOutgoingCallsMaximum();

        protected abstract String noSelectionString();

        protected abstract String oneSelectionString();

        protected abstract String multipleSelectionsString(int var1);

        protected abstract Icon getAddIcon();

        protected abstract String getAddTooltip();

        protected abstract void performAddSelection();

        protected abstract void performEditSelection(Component var1);

        @Override
        JComponent getUI() {
            if (this.ui == null) {
                this.ui = new SettingsPanel();
                this.selectionContent = new SettingsPanel();
                this.editSelectionLink = new JButton(){

                    @Override
                    public void setText(String text) {
                        super.setText(Bundle.MethodsFeatureModes_editLink(text));
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        InstrMethodsMode.this.performEditSelection(InstrMethodsMode.this.ui);
                    }

                    @Override
                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    @Override
                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.editSelectionLink.setContentAreaFilled(false);
                this.editSelectionLink.setBorderPainted(true);
                this.editSelectionLink.setMargin(new Insets(0, 0, 0, 0));
                this.editSelectionLink.setBorder(BorderFactory.createEmptyBorder());
                this.editSelectionLink.setCursor(Cursor.getPredefinedCursor(12));
                this.selectionContent.add(this.editSelectionLink);
                this.selectionContent.add(Box.createHorizontalStrut(8));
                Component separator = Box.createHorizontalStrut(1);
                separator.setBackground(Color.GRAY);
                if (separator instanceof JComponent) {
                    ((JComponent)separator).setOpaque(true);
                }
                Dimension d = separator.getMaximumSize();
                d.height = 20;
                separator.setMaximumSize(d);
                this.selectionContent.add(separator);
                this.outgoingLabel = new JLabel(Bundle.MethodsFeatureModes_outgoingCalls());
                this.lastOutgoingSelected = Boolean.parseBoolean(this.readFlag(OUTGOING_CALLS_ENABLED_FLAG, Boolean.TRUE.toString()));
                this.outgoingChoice = new JCheckBox(Bundle.MethodsFeatureModes_outgoingCalls(), this.lastOutgoingSelected){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        InstrMethodsMode.this.lastOutgoingSelected = this.isSelected();
                        InstrMethodsMode.this.updateControls();
                        InstrMethodsMode.this.settingsChanged();
                    }
                };
                this.outgoingChoice.setToolTipText(Bundle.MethodsFeatureModes_limitCallTreeToolTip());
                this.outgoingChoice.setOpaque(false);
                this.selectionContent.add(MethodsFeatureModes.createStrut(this.outgoingChoice, 8, true));
                this.selectionContent.add(this.outgoingLabel);
                this.selectionContent.add(this.outgoingChoice);
                Insets i = this.outgoingChoice.getBorder().getBorderInsets(this.outgoingChoice);
                this.outgoingLabel.setBorder(BorderFactory.createEmptyBorder(0, i.left, 0, i.right));
                this.selectionContent.add(MethodsFeatureModes.createStrut(this.outgoingChoice, 5, false));
                this.outgoingHint = new GrayLabel(Bundle.MethodsFeatureModes_unlimitedCalls());
                this.outgoingHint.setEnabled(false);
                this.outgoingHint.setVisible(!this.outgoingChoice.isSelected());
                this.selectionContent.add(this.outgoingHint);
                int outgoingCalls = Integer.parseInt(this.readFlag(OUTGOING_CALLS_FLAG, OUTGOING_CALLS_DEFAULT.toString()));
                this.outgoingSpinner = new JExtendedSpinner(new SpinnerNumberModel(outgoingCalls, 1, this.getOutgoingCallsMaximum(), 1)){

                    public Dimension getPreferredSize() {
                        return this.getMinimumSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getMinimumSize();
                    }

                    protected void fireStateChanged() {
                        InstrMethodsMode.this.settingsChanged();
                        super.fireStateChanged();
                    }
                };
                this.outgoingSpinner.setToolTipText(Bundle.MethodsFeatureModes_limitCallTreeToolTip());
                this.outgoingSpinner.setVisible(this.outgoingChoice.isSelected());
                this.selectionContent.add(this.outgoingSpinner);
                this.selectionContent.add(Box.createHorizontalStrut(10));
                if (UIUtils.isOracleLookAndFeel()) {
                    this.selectionContent.add(Box.createHorizontalStrut(4));
                }
                JLabel filterLabel = new JLabel(Bundle.MethodsFeatureModes_filterOutgoingCalls());
                filterLabel.setToolTipText(Bundle.MethodsFeatureModes_filterOutgoingTooltip());
                this.selectionContent.add(filterLabel);
                this.selectionContent.add(MethodsFeatureModes.createStrut(filterLabel, 5, false));
                this.filterLink = new JButton(){

                    @Override
                    public void setText(String text) {
                        super.setText(Bundle.MethodsFeatureModes_editLink(text));
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        InstrMethodsMode.this.performEditFilter(this);
                    }

                    @Override
                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    @Override
                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.filterLink.setContentAreaFilled(false);
                this.filterLink.setBorderPainted(true);
                this.filterLink.setMargin(new Insets(0, 0, 0, 0));
                this.filterLink.setBorder(BorderFactory.createEmptyBorder());
                this.filterLink.setCursor(Cursor.getPredefinedCursor(12));
                this.selectionContent.add(this.filterLink);
                this.updateControls();
                this.noSelectionContent = new SettingsPanel();
                GrayLabel noSelectionHint = new GrayLabel(this.noSelectionString());
                noSelectionHint.setEnabled(false);
                this.noSelectionContent.add((Component)noSelectionHint);
                this.noSelectionContent.add(Box.createHorizontalStrut(5));
                this.addSelectionButton = new SmallButton(this.getAddIcon()){

                    protected void fireActionPerformed(ActionEvent e) {
                        InstrMethodsMode.this.performAddSelection();
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.addSelectionButton.setToolTipText(this.getAddTooltip());
                this.noSelectionContent.add(this.addSelectionButton);
                this.updateSelectionCustomizer();
            }
            return this.ui;
        }

        private void updateSelectionCustomizer() {
            if (this.ui != null) {
                JPanel content;
                int count = this.getSelection().size();
                JPanel jPanel = content = count == 0 ? this.noSelectionContent : this.selectionContent;
                if (this.ui.getComponentCount() > 0 && content == this.ui.getComponent(0)) {
                    content = null;
                }
                if (count > 0) {
                    this.editSelectionLink.setText(count == 1 ? this.oneSelectionString() : this.multipleSelectionsString(count));
                }
                if (content != null) {
                    this.ui.removeAll();
                    this.ui.add(content);
                    this.ui.doLayout();
                    this.ui.repaint();
                }
            }
        }

        private void updateControls() {
            boolean outgoingRequired = FilterSelector.FilterName.NO_FILTER.equals((Object)this.filterName) || FilterSelector.FilterName.EXCLUDE_JAVA_FILTER.equals((Object)this.filterName);
            this.outgoingLabel.setVisible(outgoingRequired);
            this.outgoingChoice.setVisible(!outgoingRequired);
            if (outgoingRequired) {
                this.outgoingChoice.setSelected(true);
            } else {
                this.outgoingChoice.setSelected(this.lastOutgoingSelected);
            }
            boolean outgoingDefined = this.outgoingChoice.isSelected();
            this.outgoingSpinner.setVisible(outgoingDefined);
            this.outgoingHint.setVisible(!outgoingDefined);
            this.filterLink.setText(this.filterName.toString());
        }

        private void performEditFilter(Component invoker) {
            new FilterSelector(){

                @Override
                protected void filterChanged(FilterSelector.FilterName filterName, String filterValue) {
                    InstrMethodsMode.this.filterName = filterName;
                    InstrMethodsMode.this.filterValue = filterValue;
                    InstrMethodsMode.this.updateControls();
                    InstrMethodsMode.this.settingsChanged();
                }
            }.show(invoker.getParent(), this.filterName, this.filterValue);
        }
    }

    static abstract class ProjectClassesMode
    extends SampledMethodsMode {
        private final Collection<Lookup.Provider> selectedProjects = new HashSet<Lookup.Provider>();
        private static final String PROJECTS_FLAG = "PROJECTS_FLAG";
        private JComponent ui;
        private JButton editProjectLink;

        abstract Lookup.Provider getProject();

        ProjectClassesMode() {
            Collection<File> files = this.createFilesFromStorage();
            if (files.isEmpty()) {
                this.selectedProjects.add(this.getProject());
            } else {
                for (File file : files) {
                    Lookup.Provider project;
                    if (!file.exists()) continue;
                    FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                    Lookup.Provider provider = project = fo == null ? null : ProjectUtilities.getProject((FileObject)fo);
                    if (fo == null) continue;
                    this.selectedProjects.add(project);
                }
                this.verifySelectedProjects(false);
            }
        }

        @Override
        String getID() {
            return "ProjectClassesMode";
        }

        @Override
        String getName() {
            return Bundle.MethodsFeatureModes_projectClasses();
        }

        @Override
        void configureSettings(ProfilingSettings settings) {
            super.configureSettings(settings);
            StringBuilder filter = new StringBuilder();
            for (Lookup.Provider project : this.selectedProjects) {
                ProjectContentsSupport pcs = ProjectContentsSupport.get((Lookup.Provider)project);
                filter.append(pcs.getInstrumentationFilter(false));
                filter.append(" ");
                pcs.reset();
            }
            String s = filter.toString().replace(". ", ".* ").replace(".,", ".*,").trim();
            JavaTypeFilter f = new JavaTypeFilter(s, 10);
            settings.setInstrumentationFilter((GenericFilter)f);
        }

        @Override
        void confirmSettings() {
            if (this.ui != null) {
                assert (SwingUtilities.isEventDispatchThread());
                this.saveSelection();
            }
        }

        @Override
        boolean pendingChanges() {
            if (this.ui != null) {
                assert (SwingUtilities.isEventDispatchThread());
                if (!this.filesEquals(this.createFilesFromSelection(), this.createFilesFromStorage())) {
                    return true;
                }
            }
            return false;
        }

        @Override
        boolean currentSettingsValid() {
            assert (SwingUtilities.isEventDispatchThread());
            return !this.selectedProjects.isEmpty();
        }

        private void saveSelection() {
            Collection<File> files = this.createFilesFromSelection();
            if (files.isEmpty()) {
                this.storeFlag(PROJECTS_FLAG, null);
            } else {
                StringBuilder sb = new StringBuilder();
                for (File file : files) {
                    try {
                        sb.append(file.getCanonicalPath());
                    }
                    catch (IOException ex) {
                        sb.append(file.getAbsolutePath());
                    }
                    sb.append(File.pathSeparatorChar);
                }
                this.storeFlag(PROJECTS_FLAG, sb.toString());
            }
        }

        private Collection<File> createFilesFromStorage() {
            HashSet<File> files = new HashSet<File>();
            String s = this.readFlag(PROJECTS_FLAG, null);
            if (s != null) {
                String[] sa;
                for (String _s : sa = s.split(File.pathSeparator)) {
                    files.add(new File(_s));
                }
            }
            return files;
        }

        private Collection<File> createFilesFromSelection() {
            HashSet<File> files = new HashSet<File>();
            if (this.selectedProjects.size() > 1 || !this.selectedProjects.contains(this.getProject())) {
                for (Lookup.Provider project : this.selectedProjects) {
                    files.add(FileUtil.toFile((FileObject)ProjectUtilities.getProjectDirectory((Lookup.Provider)project)));
                }
            }
            return files;
        }

        private boolean filesEquals(Collection<File> files1, Collection<File> files2) {
            if (files1.size() != files2.size()) {
                return false;
            }
            for (File file1 : files1) {
                if (files2.contains(file1)) continue;
                return false;
            }
            return true;
        }

        private void verifySelectedProjects(boolean refreshLink) {
            if (this.selectedProjects.size() == 1 && this.selectedProjects.contains(this.getProject())) {
                return;
            }
            List<Lookup.Provider> projects = Arrays.asList(ProjectUtilities.getOpenedProjects());
            Iterator<Lookup.Provider> iterator = this.selectedProjects.iterator();
            while (iterator.hasNext()) {
                if (projects.contains(iterator.next())) continue;
                iterator.remove();
            }
            if (this.selectedProjects.isEmpty()) {
                this.selectedProjects.add(this.getProject());
            }
            if (refreshLink) {
                this.refreshProjectsLink();
            }
        }

        @Override
        JComponent getUI() {
            if (this.ui == null) {
                final ChangeListener projectsListener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProjectClassesMode.this.verifySelectedProjects(true);
                            }
                        });
                    }
                };
                this.ui = new SettingsPanel(){

                    @Override
                    public void addNotify() {
                        super.addNotify();
                        ProjectUtilities.addOpenProjectsListener((ChangeListener)projectsListener);
                    }

                    @Override
                    public void removeNotify() {
                        ProjectUtilities.removeOpenProjectsListener((ChangeListener)projectsListener);
                        super.removeNotify();
                    }
                };
                this.editProjectLink = new JButton(){

                    @Override
                    public void setText(String text) {
                        super.setText(Bundle.MethodsFeatureModes_editLink(text));
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        ProjectClassesMode.this.performEditProject();
                    }

                    @Override
                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    @Override
                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.editProjectLink.setContentAreaFilled(false);
                this.editProjectLink.setBorderPainted(true);
                this.editProjectLink.setMargin(new Insets(0, 0, 0, 0));
                this.editProjectLink.setBorder(BorderFactory.createEmptyBorder());
                this.editProjectLink.setCursor(Cursor.getPredefinedCursor(12));
                this.refreshProjectsLink();
                this.ui.add(this.editProjectLink);
            }
            return this.ui;
        }

        private void performEditProject() {
            new ProjectsSelector(this.selectedProjects){

                @Override
                protected void selectionChanged(Collection<Lookup.Provider> selected) {
                    ProjectClassesMode.this.selectedProjects.clear();
                    ProjectClassesMode.this.selectedProjects.addAll(selected);
                    ProjectClassesMode.this.refreshProjectsLink();
                    ProjectClassesMode.this.settingsChanged();
                }
            }.show(this.ui);
        }

        private void refreshProjectsLink() {
            if (this.editProjectLink == null) {
                return;
            }
            if (this.selectedProjects.size() == 1) {
                this.editProjectLink.setText(Bundle.MethodsFeatureModes_selectedProject(ProjectUtilities.getDisplayName((Lookup.Provider)this.selectedProjects.iterator().next())));
            } else {
                this.editProjectLink.setText(Bundle.MethodsFeatureModes_selectedProjects(this.selectedProjects.size()));
            }
        }
    }

    static abstract class AllClassesMode
    extends SampledMethodsMode {
        AllClassesMode() {
        }

        @Override
        String getID() {
            return "AllClassesMode";
        }

        @Override
        String getName() {
            return Bundle.MethodsFeatureModes_allClasses();
        }

        @Override
        void configureSettings(ProfilingSettings settings) {
            super.configureSettings(settings);
            settings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter());
        }
    }

    private static abstract class SampledMethodsMode
    extends MethodsMode {
        private SampledMethodsMode() {
        }

        @Override
        void configureSettings(ProfilingSettings settings) {
            super.configureSettings(settings);
            settings.setProfilingType(64);
            settings.setCPUProfilingType(2);
        }

        @Override
        void confirmSettings() {
        }

        @Override
        boolean pendingChanges() {
            return false;
        }

        @Override
        boolean currentSettingsValid() {
            return true;
        }

        @Override
        JComponent getUI() {
            return null;
        }
    }

    private static abstract class MethodsMode
    extends FeatureMode {
        private MethodsMode() {
        }

        void initialize() {
        }

        @Override
        void configureSettings(ProfilingSettings settings) {
        }
    }
}

