/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.api.jstesting;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.clientproject.spi.jstesting.CoverageImplementation;
import org.openide.util.Parameters;

public final class Coverage {
    public static final String PROP_ENABLED = "ENABLED";
    private final CoverageImplementation delegate;

    private Coverage(CoverageImplementation delegate) {
        assert (delegate != null);
        this.delegate = delegate;
    }

    @CheckForNull
    public static Coverage forProject(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        CoverageImplementation coverageImplementation = (CoverageImplementation)project.getLookup().lookup(CoverageImplementation.class);
        if (coverageImplementation == null) {
            return null;
        }
        return new Coverage(coverageImplementation);
    }

    public boolean isEnabled() {
        return this.delegate.isEnabled();
    }

    public void setFiles(@NonNull List<File> files) {
        Parameters.notNull((CharSequence)"files", files);
        this.delegate.setFiles(files);
    }

    public void addPropertyChangeListener(@NullAllowed PropertyChangeListener listener) {
        this.delegate.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@NullAllowed PropertyChangeListener listener) {
        this.delegate.removePropertyChangeListener(listener);
    }

    public static final class Line {
        private final int number;
        private final int hitCount;

        public Line(int number, int hitCount) {
            if (number < 0) {
                throw new IllegalArgumentException("Line number cannot be less than 0, given: " + number);
            }
            if (hitCount < 0) {
                throw new IllegalArgumentException("Hit count cannot be less than 0, given: " + hitCount);
            }
            this.number = number;
            this.hitCount = hitCount;
        }

        public int getNumber() {
            return this.number;
        }

        public int getHitCount() {
            return this.hitCount;
        }

        public String toString() {
            return "Line{number=" + this.number + ", hitCount=" + this.hitCount + '}';
        }
    }

    public static final class FileMetrics {
        private final int lineCount;
        private final int statements;
        private final int coveredStatements;

        public FileMetrics(int lineCount, int statements, int coveredStatements) {
            if (lineCount < 0) {
                throw new IllegalArgumentException("Line count cannot be less than 0, given: " + lineCount);
            }
            if (statements < 0) {
                throw new IllegalArgumentException("Number of statements cannot be less than 0, given: " + statements);
            }
            if (coveredStatements < 0) {
                throw new IllegalArgumentException("Number of covered statements cannot be less than 0, given: " + coveredStatements);
            }
            this.lineCount = lineCount;
            this.statements = statements;
            this.coveredStatements = coveredStatements;
        }

        public int getLineCount() {
            return this.lineCount;
        }

        public int getStatements() {
            return this.statements;
        }

        public int getCoveredStatements() {
            return this.coveredStatements;
        }

        public String toString() {
            return "FileMetrics{lineCount=" + this.lineCount + ", statements=" + this.statements + ", coveredStatements=" + this.coveredStatements + '}';
        }
    }

    public static final class File {
        private final String path;
        private final FileMetrics fileMetrics;
        private final List<Line> lines;

        public File(@NonNull String path, @NonNull FileMetrics fileMetrics, @NonNull List<Line> lines) {
            Parameters.notNull((CharSequence)"path", (Object)path);
            Parameters.notNull((CharSequence)"fileMetrics", (Object)fileMetrics);
            Parameters.notNull((CharSequence)"lines", lines);
            this.path = path;
            this.fileMetrics = fileMetrics;
            this.lines = lines;
        }

        public String getPath() {
            return this.path;
        }

        public FileMetrics getMetrics() {
            return this.fileMetrics;
        }

        public List<Line> getLines() {
            return new ArrayList<Line>(this.lines);
        }

        public String toString() {
            return "File{path=" + this.path + ", fileMetrics=" + this.fileMetrics + ", lines=" + this.lines + '}';
        }
    }
}

