/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.spi.accessibility;

import java.util.Collection;
import org.netbeans.validation.api.Problem;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public abstract class GlobalValidationCallback {
    private static final Object LOCK = new Object();
    private static GlobalValidationCallback INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GlobalValidationCallback getDefault() {
        Object object = LOCK;
        synchronized (object) {
            if (INSTANCE == null) {
                INSTANCE = new ProxyGlobalCallback();
            }
        }
        return INSTANCE;
    }

    public void onValidationTrigger(Object source, Object triggeringEvent) {
    }

    public void onValidationFinished(Object source, Object triggeringEvent) {
    }

    public abstract void onProblem(Object var1, Problem var2);

    public abstract void onProblemCleared(Object var1, Problem var2);

    private static final class ProxyGlobalCallback
    extends GlobalValidationCallback {
        private ProxyGlobalCallback() {
        }

        Collection<? extends GlobalValidationCallback> registered() {
            return Lookup.getDefault().lookupAll(GlobalValidationCallback.class);
        }

        @Override
        public void onProblem(Object component, Problem problem) {
            for (GlobalValidationCallback globalValidationCallback : this.registered()) {
                try {
                    globalValidationCallback.onProblem(component, problem);
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        }

        @Override
        public void onProblemCleared(Object component, Problem problem) {
            for (GlobalValidationCallback globalValidationCallback : this.registered()) {
                try {
                    globalValidationCallback.onProblemCleared(component, problem);
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        }
    }
}

