/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.conversion;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.validation.api.AbstractValidator;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.conversion.Converter;

final class StringToDocumentConverter
extends Converter<String, Document> {
    StringToDocumentConverter() {
        super(String.class, Document.class);
    }

    @Override
    public Validator<Document> convert(Validator<String> from) {
        return new DocValidator(from);
    }

    private static class DocValidator
    extends AbstractValidator<Document> {
        private Validator<String> wrapped;

        private DocValidator(Validator<String> from) {
            super(Document.class);
            this.wrapped = from;
        }

        @Override
        public void validate(Problems problems, String compName, Document model) {
            try {
                String text = model.getText(0, model.getLength());
                this.wrapped.validate(problems, compName, text);
            }
            catch (BadLocationException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public String toString() {
            return "DocValidator for [" + this.wrapped + "]";
        }
    }
}

