/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.shared.utils.io.IOUtil;

class Expand {
    private File source;
    private File dest;
    private boolean overwrite = false;
    private static final int BUFFER_SIZE = 18;

    Expand() {
    }

    public void setSrc(File sourceArchive) {
        this.source = sourceArchive;
    }

    public void setDest(File destinationDirectory) {
        this.dest = destinationDirectory;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void execute() throws Exception {
        this.expandFile(this.source, this.dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expandFile(File srcFile, File destination) throws Exception {
        if (this.source == null) {
            throw new NullPointerException("Source Archive must not be null!");
        }
        File destDir = destination;
        if (destDir == null) {
            destDir = new File(System.getProperty("user.dir"));
        }
        ZipInputStream in = null;
        try {
            in = new ZipInputStream(new FileInputStream(srcFile));
            ZipEntry zipEntry = in.getNextEntry();
            while (zipEntry != null) {
                String zipEntryName = zipEntry.getName();
                Date zipEntryDate = new Date(zipEntry.getTime());
                this.extractFile(this.source, destDir, in, zipEntryName, zipEntryDate, zipEntry.isDirectory());
                zipEntry = in.getNextEntry();
            }
            in.close();
            in = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void extractFile(File archive, File destDir, InputStream compressedInputStream, String entryName, Date entryDate, boolean isDirectory) throws Exception {
        block5: {
            File targetFile;
            block6: {
                targetFile = new File(destDir, entryName);
                if (!targetFile.getAbsolutePath().startsWith(destDir.getAbsolutePath())) {
                    throw new IOException("Entry '" + entryName + "' outside the target directory.");
                }
                if (this.overwrite && targetFile.exists() && targetFile.isDirectory() != isDirectory) {
                    this.deleteFileOrDir(targetFile);
                }
                if (targetFile.exists() && !this.overwrite && targetFile.lastModified() > entryDate.getTime()) break block5;
                if (!isDirectory) break block6;
                targetFile.mkdirs();
                break block5;
            }
            byte[] buffer = new byte[18];
            FileOutputStream out = null;
            try {
                int len;
                out = new FileOutputStream(targetFile);
                while ((len = compressedInputStream.read(buffer)) >= 0) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
                ((OutputStream)out).close();
                out = null;
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                throw throwable;
            }
            IOUtil.close(out);
            targetFile.setLastModified(entryDate.getTime());
        }
    }

    private void deleteFileOrDir(File targetFile) throws IOException {
        if (targetFile.isDirectory()) {
            FileUtils.deleteDirectory(targetFile);
        } else {
            FileUtils.delete(targetFile);
        }
    }
}

