/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.discovery;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.logstash.plugins.discovery.MetadataAdapter;
import org.logstash.plugins.discovery.ReflectionUtils;
import org.logstash.plugins.discovery.Utils;
import org.logstash.plugins.discovery.Vfs;

public final class JavaReflectionAdapter
implements MetadataAdapter<Class> {
    @Override
    public List<String> getClassAnnotationNames(Class aClass) {
        return this.getAnnotationNames(aClass.getDeclaredAnnotations());
    }

    @Override
    public Class getOfCreateClassObject(Vfs.File file) {
        return this.getOfCreateClassObject(file, new ClassLoader[0]);
    }

    public Class getOfCreateClassObject(Vfs.File file, ClassLoader ... loaders) {
        String name = file.getRelativePath().replace("/", ".").replace(".class", "");
        return ReflectionUtils.forName(name, loaders);
    }

    @Override
    public String getClassName(Class cls) {
        return cls.getName();
    }

    @Override
    public String getSuperclassName(Class cls) {
        Class superclass = cls.getSuperclass();
        return superclass != null ? superclass.getName() : "";
    }

    @Override
    public List<String> getInterfacesNames(Class cls) {
        Class<?>[] classes = cls.getInterfaces();
        ArrayList<String> names = new ArrayList<String>(classes != null ? classes.length : 0);
        if (classes != null) {
            for (Class<?> cls1 : classes) {
                names.add(cls1.getName());
            }
        }
        return names;
    }

    @Override
    public boolean acceptsInput(String file) {
        return file.endsWith(".class");
    }

    private List<String> getAnnotationNames(Annotation[] annotations) {
        ArrayList<String> names = new ArrayList<String>(annotations.length);
        for (Annotation annotation : annotations) {
            names.add(annotation.annotationType().getName());
        }
        return names;
    }

    public static String getName(Class type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dim = 0;
                while (cl.isArray()) {
                    ++dim;
                    cl = cl.getComponentType();
                }
                return cl.getName() + Utils.repeat("[]", dim);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }
}

