/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import com.beust.jcommander.IStringConverterFactory;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.PrintStream;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import morfologik.tools.CustomParameterConverters;
import morfologik.tools.ExitStatus;
import morfologik.tools.ExitStatusException;

public abstract class CliTool
implements Callable<ExitStatus> {
    protected static final String ARG_OVERWRITE = "--overwrite";
    protected static final String ARG_VALIDATE = "--validate";
    @Parameter(names={"--exit"}, hidden=true, arity=1, description="Call System.exit() at the end of command processing.")
    private boolean callSystemExit = true;
    @Parameter(names={"-h", "--help"}, help=true, hidden=true, description="Help about options and switches.")
    private boolean help;

    public CliTool() {
        if (!this.getClass().isAnnotationPresent(Parameters.class)) {
            throw new RuntimeException();
        }
    }

    public void setCallSystemExit(boolean flag) {
        this.callSystemExit = flag;
    }

    protected static void main(String[] args, CliTool ... commands) {
        if (commands.length == 1) {
            CliTool.main(args, commands[0]);
        } else {
            JCommander jc = new JCommander();
            for (CliTool command : commands) {
                jc.addCommand((Object)command);
            }
            jc.addConverterFactory((IStringConverterFactory)new CustomParameterConverters());
            jc.setProgramName("");
            ExitStatus exitStatus = ExitStatus.SUCCESS;
            try {
                jc.parse(args);
                String commandName = jc.getParsedCommand();
                if (commandName == null) {
                    CliTool.helpDisplayCommandOptions(System.err, jc);
                } else {
                    CliTool command;
                    List objects = ((JCommander)jc.getCommands().get(commandName)).getObjects();
                    if (objects.size() != 1) {
                        throw new RuntimeException();
                    }
                    command = (CliTool)CliTool.class.cast(objects.get(0));
                    exitStatus = (ExitStatus)((Object)command.call());
                    if (command.callSystemExit) {
                        System.exit(exitStatus.code);
                    }
                }
            }
            catch (ExitStatusException e) {
                System.err.println(e.getMessage());
                if (e.getCause() != null) {
                    e.getCause().printStackTrace(System.err);
                }
                exitStatus = e.exitStatus;
            }
            catch (MissingCommandException e) {
                System.err.println("Invalid argument: " + (Object)((Object)e));
                System.err.println();
                CliTool.helpDisplayCommandOptions(System.err, jc);
                exitStatus = ExitStatus.ERROR_INVALID_ARGUMENTS;
            }
            catch (ParameterException e) {
                System.err.println("Invalid argument: " + e.getMessage());
                System.err.println();
                if (jc.getParsedCommand() == null) {
                    CliTool.helpDisplayCommandOptions(System.err, jc);
                } else {
                    CliTool.helpDisplayCommandOptions(System.err, jc.getParsedCommand(), jc);
                }
                exitStatus = ExitStatus.ERROR_INVALID_ARGUMENTS;
            }
            catch (Throwable t) {
                System.err.println("An unhandled exception occurred. Stack trace below.");
                t.printStackTrace(System.err);
                ExitStatus exitStatus2 = ExitStatus.ERROR_OTHER;
            }
        }
    }

    protected static void main(String[] args, CliTool command) {
        JCommander jc = new JCommander((Object)command);
        jc.addConverterFactory((IStringConverterFactory)new CustomParameterConverters());
        jc.setProgramName(command.getClass().getAnnotation(Parameters.class).commandNames()[0]);
        ExitStatus exitStatus = ExitStatus.SUCCESS;
        try {
            jc.parse(args);
            if (command.help) {
                CliTool.helpDisplayCommandOptions(System.err, jc);
            } else {
                exitStatus = (ExitStatus)((Object)command.call());
            }
        }
        catch (ExitStatusException e) {
            System.err.println(e.getMessage());
            if (e.getCause() != null) {
                e.getCause().printStackTrace(System.err);
            }
            exitStatus = e.exitStatus;
        }
        catch (MissingCommandException e) {
            System.err.println("Invalid argument: " + (Object)((Object)e));
            System.err.println();
            CliTool.helpDisplayCommandOptions(System.err, jc);
            exitStatus = ExitStatus.ERROR_INVALID_ARGUMENTS;
        }
        catch (ParameterException e) {
            System.err.println("Invalid argument: " + e.getMessage());
            System.err.println();
            if (jc.getParsedCommand() == null) {
                CliTool.helpDisplayCommandOptions(System.err, jc);
            } else {
                CliTool.helpDisplayCommandOptions(System.err, jc.getParsedCommand(), jc);
            }
            exitStatus = ExitStatus.ERROR_INVALID_ARGUMENTS;
        }
        catch (Throwable t) {
            System.err.println("An unhandled exception occurred. Stack trace below.");
            t.printStackTrace(System.err);
            exitStatus = ExitStatus.ERROR_OTHER;
        }
        if (command.callSystemExit) {
            System.exit(exitStatus.code);
        }
    }

    protected static void printf(String msg, Object ... args) {
        System.out.println(String.format(Locale.ROOT, msg, args));
    }

    protected static <T> T checkNotNull(T arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        return arg;
    }

    private static void helpDisplayCommandOptions(PrintStream pw, String command, JCommander jc) {
        StringBuilder sb = new StringBuilder();
        jc = (JCommander)jc.getCommands().get(command);
        jc.usage(sb, "");
        pw.print(sb);
    }

    private static void helpDisplayCommandOptions(PrintStream pw, JCommander jc) {
        StringBuilder sb = new StringBuilder();
        jc.usage(sb, "");
        pw.print(sb);
    }
}

