/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.definitions;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003\u001a\f\u0010\b\u001a\u00020\t*\u00020\u0007H\u0002\u001a\f\u0010\n\u001a\u00020\t*\u00020\u0007H\u0002\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\u0001*\u00020\f\u00a8\u0006\r"}, d2={"scriptDefinitionByFileName", "Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinition;", "project", "Lcom/intellij/openapi/project/Project;", "fileName", "", "findScriptDefinition", "Lcom/intellij/openapi/vfs/VirtualFile;", "isKotlinFileType", "", "isNonScript", "scriptDefinition", "Lcom/intellij/psi/PsiFile;", "kotlin-scripting-compiler-impl"})
public final class DefinitionsKt {
    @Nullable
    public static final KotlinScriptDefinition scriptDefinition(@NotNull PsiFile $this$scriptDefinition) {
        Intrinsics.checkParameterIsNotNull((Object)$this$scriptDefinition, (String)"$this$scriptDefinition");
        if (!($this$scriptDefinition instanceof KtFile)) {
            return null;
        }
        VirtualFile virtualFile = ((KtFile)$this$scriptDefinition).getVirtualFile();
        if (virtualFile == null) {
            PsiFile psiFile = ((KtFile)$this$scriptDefinition).getOriginalFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"originalFile");
            virtualFile = psiFile.getVirtualFile();
        }
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        if (DefinitionsKt.isNonScript(file)) {
            return null;
        }
        Project project = ((KtFile)$this$scriptDefinition).getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
        return DefinitionsKt.scriptDefinitionByFileName(project, string);
    }

    @Nullable
    public static final KotlinScriptDefinition findScriptDefinition(@NotNull VirtualFile $this$findScriptDefinition, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)$this$findScriptDefinition, (String)"$this$findScriptDefinition");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (!$this$findScriptDefinition.isValid() || DefinitionsKt.isNonScript($this$findScriptDefinition)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile($this$findScriptDefinition);
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        if ((KtFile)psiFile == null) {
            return null;
        }
        String string = $this$findScriptDefinition.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        return DefinitionsKt.scriptDefinitionByFileName(project, string);
    }

    @NotNull
    public static final KotlinScriptDefinition scriptDefinitionByFileName(@NotNull Project project, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        ScriptDefinitionProvider scriptDefinitionProvider = ScriptDefinitionProvider.Companion.getInstance(project);
        if (scriptDefinitionProvider == null) {
            throw (Throwable)new IllegalStateException("Unable to get script definition: ScriptDefinitionProvider is not configured.");
        }
        ScriptDefinitionProvider scriptDefinitionProvider2 = scriptDefinitionProvider;
        KotlinScriptDefinition kotlinScriptDefinition = scriptDefinitionProvider2.findScriptDefinition(fileName);
        if (kotlinScriptDefinition == null) {
            kotlinScriptDefinition = scriptDefinitionProvider2.getDefaultScriptDefinition();
        }
        return kotlinScriptDefinition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isNonScript(@NotNull VirtualFile $this$isNonScript) {
        if ($this$isNonScript.isDirectory()) return true;
        if (Intrinsics.areEqual((Object)$this$isNonScript.getExtension(), (Object)"kt")) return true;
        String string = $this$isNonScript.getExtension();
        JavaClassFileType javaClassFileType = JavaClassFileType.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)javaClassFileType, (String)"JavaClassFileType.INSTANCE");
        if (Intrinsics.areEqual((Object)string, (Object)javaClassFileType.getDefaultExtension())) return true;
        if (DefinitionsKt.isKotlinFileType($this$isNonScript)) return false;
        return true;
    }

    private static final boolean isKotlinFileType(@NotNull VirtualFile $this$isKotlinFileType) {
        FileTypeRegistry typeRegistry = FileTypeRegistry.getInstance();
        return Intrinsics.areEqual((Object)typeRegistry.getFileTypeByFile($this$isKotlinFileType), (Object)KotlinFileType.INSTANCE) || Intrinsics.areEqual((Object)typeRegistry.getFileTypeByFileName($this$isKotlinFileType.getName()), (Object)KotlinFileType.INSTANCE);
    }
}

