import { constIdentity, toString, constant, identity } from './function';
export const URI = 'IO';
/**
 * @since 1.0.0
 */
export class IO {
    constructor(run) {
        this.run = run;
    }
    map(f) {
        return new IO(() => f(this.run()));
    }
    ap(fab) {
        return new IO(() => fab.run()(this.run()));
    }
    /**
     * Flipped version of `ap`
     */
    ap_(fb) {
        return fb.ap(this);
    }
    /**
     * Combine two effectful actions, keeping only the result of the first
     * @since 1.6.0
     */
    applyFirst(fb) {
        return fb.ap(this.map(constant));
    }
    /**
     * Combine two effectful actions, keeping only the result of the second
     * @since 1.5.0
     */
    applySecond(fb) {
        return fb.ap(this.map(constIdentity));
    }
    chain(f) {
        return new IO(() => f(this.run()).run());
    }
    inspect() {
        return this.toString();
    }
    toString() {
        return `new IO(${toString(this.run)})`;
    }
}
const map = (fa, f) => {
    return fa.map(f);
};
const of = (a) => {
    return new IO(() => a);
};
const ap = (fab, fa) => {
    return fa.ap(fab);
};
const chain = (fa, f) => {
    return fa.chain(f);
};
/**
 * @since 1.0.0
 */
export const getSemigroup = (S) => {
    return {
        concat: (x, y) => new IO(() => {
            const xr = x.run();
            const yr = y.run();
            return S.concat(xr, yr);
        })
    };
};
/**
 * @since 1.0.0
 */
export const getMonoid = (M) => {
    return Object.assign({}, getSemigroup(M), { empty: of(M.empty) });
};
const fromIO = identity;
/**
 * @since 1.0.0
 */
export const io = {
    URI,
    map,
    of,
    ap,
    chain,
    fromIO
};
