import { getFunctorComposition } from './Functor';
import { fromEither, none, some } from './Option';
export function getCompactableComposition(F, G) {
    const FC = getFunctorComposition(F, G);
    const CC = Object.assign({}, FC, { compact: fga => F.map(fga, G.compact), separate: fge => {
            const left = CC.compact(FC.map(fge, e => e.fold(some, () => none)));
            const right = CC.compact(FC.map(fge, fromEither));
            return { left, right };
        } });
    return CC;
}
