"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var rendering_1 = require("../series/rendering");
/** The type of tooltip to use */
var TooltipType;
(function (TooltipType) {
    /** Vertical cursor parallel to x axis */
    TooltipType["VerticalCursor"] = "vertical";
    /** Vertical and horizontal cursors */
    TooltipType["Crosshairs"] = "cross";
    /** Follor the mouse coordinates */
    TooltipType["Follow"] = "follow";
    /** Hide every tooltip */
    TooltipType["None"] = "none";
})(TooltipType = exports.TooltipType || (exports.TooltipType = {}));
/**
 * Get the cursor position depending on the chart rotation
 * @param xPos x position relative to chart
 * @param yPos y position relative to chart
 * @param chartRotation the chart rotation
 * @param chartDimension the chart dimension
 */
function getValidXPosition(xPos, yPos, chartRotation, chartDimension) {
    switch (chartRotation) {
        case 0:
            return xPos;
        case 180:
            return chartDimension.width - xPos;
        case 90:
            return yPos;
        case -90:
            return chartDimension.height - yPos;
    }
}
exports.getValidXPosition = getValidXPosition;
function getValidYPosition(xPos, yPos, chartRotation, chartDimension) {
    switch (chartRotation) {
        case 0:
            return yPos;
        case 180:
            return chartDimension.height - yPos;
        case -90:
            return xPos;
        case 90:
            return chartDimension.width - xPos;
    }
}
exports.getValidYPosition = getValidYPosition;
function isCrosshairTooltipType(type) {
    return type === TooltipType.VerticalCursor || type === TooltipType.Crosshairs;
}
exports.isCrosshairTooltipType = isCrosshairTooltipType;
function isFollowTooltipType(type) {
    return type === TooltipType.Follow;
}
exports.isFollowTooltipType = isFollowTooltipType;
function areIndexedGeometryArraysEquals(arr1, arr2) {
    if (arr1.length !== arr2.length) {
        return false;
    }
    for (var i = arr1.length; i--;) {
        return areIndexedGeomsEquals(arr1[i], arr2[i]);
    }
    return true;
}
exports.areIndexedGeometryArraysEquals = areIndexedGeometryArraysEquals;
function areIndexedGeomsEquals(ig1, ig2) {
    if (rendering_1.isPointGeometry(ig1) && rendering_1.isPointGeometry(ig2)) {
        return arePointsEqual(ig1, ig2);
    }
    if (rendering_1.isBarGeometry(ig1) && rendering_1.isBarGeometry(ig2)) {
        return areBarEqual(ig1, ig2);
    }
    return false;
}
exports.areIndexedGeomsEquals = areIndexedGeomsEquals;
function arePointsEqual(ig1, ig2) {
    return (ig1.geometryId.specId === ig2.geometryId.specId &&
        ig1.color === ig2.color &&
        ig1.x === ig2.x &&
        ig1.transform.x === ig2.transform.x &&
        ig1.transform.y === ig2.transform.y &&
        ig1.y === ig2.y &&
        ig1.radius === ig2.radius);
}
exports.arePointsEqual = arePointsEqual;
function areBarEqual(ig1, ig2) {
    return (ig1.geometryId.specId === ig2.geometryId.specId &&
        ig1.color === ig2.color &&
        ig1.x === ig2.x &&
        ig1.y === ig2.y &&
        ig1.width === ig2.width &&
        ig1.height === ig2.height);
}
exports.areBarEqual = areBarEqual;
//# sourceMappingURL=interactions.js.map