"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var classnames_1 = __importDefault(require("classnames"));
var mobx_react_1 = require("mobx-react");
var react_1 = __importDefault(require("react"));
var TooltipsComponent = /** @class */ (function (_super) {
    __extends(TooltipsComponent, _super);
    function TooltipsComponent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TooltipsComponent.prototype.render = function () {
        var _a = this.props.chartStore, isTooltipVisible = _a.isTooltipVisible, tooltipData = _a.tooltipData, tooltipPosition = _a.tooltipPosition;
        if (!isTooltipVisible.get()) {
            return react_1.default.createElement("div", { className: "elasticChartsTooltip elasticChartsTooltip--hidden" });
        }
        return (react_1.default.createElement("div", { className: "elasticChartsTooltip", style: { transform: tooltipPosition.transform } },
            react_1.default.createElement("p", { className: "elasticChartsTooltip__header" }, tooltipData[0] && tooltipData[0].value),
            react_1.default.createElement("div", { className: "elasticChartsTooltip__table" },
                react_1.default.createElement("table", null,
                    react_1.default.createElement("tbody", null, tooltipData.slice(1).map(function (_a, index) {
                        var name = _a.name, value = _a.value, color = _a.color, isHighlighted = _a.isHighlighted;
                        var classes = classnames_1.default({
                            elasticChartsTooltip__rowHighlighted: isHighlighted,
                        });
                        return (react_1.default.createElement("tr", { key: "row-" + index, className: classes },
                            react_1.default.createElement("td", { className: "elasticChartsTooltip__label", style: {
                                    borderLeftColor: color,
                                } }, name),
                            react_1.default.createElement("td", null, value)));
                    }))))));
    };
    TooltipsComponent.displayName = 'Tooltips';
    return TooltipsComponent;
}(react_1.default.Component));
exports.Tooltips = mobx_react_1.inject('chartStore')(mobx_react_1.observer(TooltipsComponent));
//# sourceMappingURL=tooltips.js.map