"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var debounce_1 = __importDefault(require("lodash/debounce"));
var mobx_react_1 = require("mobx-react");
var react_1 = __importDefault(require("react"));
var resize_observer_polyfill_1 = __importDefault(require("resize-observer-polyfill"));
var Resizer = /** @class */ (function (_super) {
    __extends(Resizer, _super);
    function Resizer(props) {
        var _this = _super.call(this, props) || this;
        _this.onResize = function (entries) {
            entries.forEach(function (_a) {
                var _b = _a.contentRect, width = _b.width, height = _b.height;
                _this.props.chartStore.updateParentDimensions(width, height, 0, 0);
            });
        };
        _this.containerRef = react_1.default.createRef();
        _this.ro = new resize_observer_polyfill_1.default(debounce_1.default(_this.onResize, 200));
        return _this;
    }
    Resizer.prototype.componentDidMount = function () {
        this.ro.observe(this.containerRef.current);
    };
    Resizer.prototype.componentWillUnmount = function () {
        this.ro.unobserve(this.containerRef.current);
    };
    Resizer.prototype.render = function () {
        return (react_1.default.createElement("div", { ref: this.containerRef, style: {
                zIndex: -10000000,
                position: 'absolute',
                bottom: 0,
                top: 0,
                left: 0,
                right: 0,
                boxSizing: 'border-box',
            } }));
    };
    return Resizer;
}(react_1.default.Component));
exports.ChartResizer = mobx_react_1.inject('chartStore')(mobx_react_1.observer(Resizer));
//# sourceMappingURL=chart_resizer.js.map