"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var classnames_1 = __importDefault(require("classnames"));
var mobx_react_1 = require("mobx-react");
var react_1 = __importStar(require("react"));
var specs_parser_1 = require("../specs/specs_parser");
var chart_state_1 = require("../state/chart_state");
var annotation_tooltips_1 = require("./annotation_tooltips");
var chart_resizer_1 = require("./chart_resizer");
var crosshair_1 = require("./crosshair");
var highlighter_1 = require("./highlighter");
var legend_1 = require("./legend");
var legend_button_1 = require("./legend_button");
var reactive_chart_1 = require("./react_canvas/reactive_chart");
var reactive_chart_2 = require("./svg/reactive_chart");
var tooltips_1 = require("./tooltips");
var Chart = /** @class */ (function (_super) {
    __extends(Chart, _super);
    function Chart(props) {
        var _this = _super.call(this, props) || this;
        _this.chartSpecStore = new chart_state_1.ChartStore();
        return _this;
    }
    Chart.prototype.render = function () {
        var _a = this.props, renderer = _a.renderer, size = _a.size, className = _a.className;
        var containerStyle;
        if (size) {
            containerStyle = {
                position: 'relative',
                width: size[0],
                height: size[1],
            };
        }
        else {
            containerStyle = {};
        }
        var chartClass = classnames_1.default('elasticCharts', className);
        return (react_1.default.createElement(mobx_react_1.Provider, { chartStore: this.chartSpecStore },
            react_1.default.createElement(react_1.Fragment, null,
                react_1.default.createElement(specs_parser_1.SpecsParser, null, this.props.children),
                react_1.default.createElement("div", { style: containerStyle, className: chartClass },
                    react_1.default.createElement(chart_resizer_1.ChartResizer, null),
                    react_1.default.createElement(crosshair_1.Crosshair, null),
                    renderer === 'svg' && react_1.default.createElement(reactive_chart_2.ReactiveChart, null),
                    renderer === 'canvas' && react_1.default.createElement(reactive_chart_1.ReactiveChart, null),
                    react_1.default.createElement(tooltips_1.Tooltips, null),
                    react_1.default.createElement(annotation_tooltips_1.AnnotationTooltip, null),
                    react_1.default.createElement(legend_1.Legend, null),
                    react_1.default.createElement(legend_button_1.LegendButton, null),
                    react_1.default.createElement(highlighter_1.Highlighter, null)))));
    };
    Chart.defaultProps = {
        renderer: 'canvas',
    };
    return Chart;
}(react_1.default.Component));
exports.Chart = Chart;
//# sourceMappingURL=chart.js.map