/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import org.gradle.internal.serialize.ExceptionReplacingObjectInputStream;
import org.gradle.internal.serialize.ExceptionReplacingObjectOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Message {
    private static final Logger LOGGER = LoggerFactory.getLogger(Message.class);

    public static void send(Object message, OutputStream outputSteam) throws IOException {
        ExceptionReplacingObjectOutputStream oos = new ExceptionReplacingObjectOutputStream(outputSteam);
        try {
            oos.writeObject(message);
        }
        finally {
            oos.flush();
        }
    }

    public static Object receive(InputStream inputSteam, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        ExceptionReplacingObjectInputStream ois = new ExceptionReplacingObjectInputStream(inputSteam, classLoader);
        return ((ObjectInputStream)((Object)ois)).readObject();
    }
}

