/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.CacheableInvocation;
import org.gradle.api.internal.artifacts.transform.ExecutionGraphDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.PrecomputedTransformationResult;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.TransformationNode;
import org.gradle.api.internal.artifacts.transform.TransformationNodeRegistry;
import org.gradle.api.internal.artifacts.transform.TransformationOperation;
import org.gradle.api.internal.artifacts.transform.TransformationResult;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

class TransformingAsyncArtifactListener
implements ResolvedArtifactSet.AsyncArtifactListener {
    private final Map<ComponentArtifactIdentifier, TransformationResult> artifactResults;
    private final Map<File, TransformationResult> fileResults;
    private final ExecutionGraphDependenciesResolver dependenciesResolver;
    private final TransformationNodeRegistry transformationNodeRegistry;
    private final BuildOperationQueue<RunnableBuildOperation> actions;
    private final ResolvedArtifactSet.AsyncArtifactListener delegate;
    private final Transformation transformation;

    TransformingAsyncArtifactListener(Transformation transformation, ResolvedArtifactSet.AsyncArtifactListener delegate, BuildOperationQueue<RunnableBuildOperation> actions, Map<ComponentArtifactIdentifier, TransformationResult> artifactResults, Map<File, TransformationResult> fileResults, ExecutionGraphDependenciesResolver dependenciesResolver, TransformationNodeRegistry transformationNodeRegistry) {
        this.artifactResults = artifactResults;
        this.actions = actions;
        this.transformation = transformation;
        this.delegate = delegate;
        this.fileResults = fileResults;
        this.dependenciesResolver = dependenciesResolver;
        this.transformationNodeRegistry = transformationNodeRegistry;
    }

    @Override
    public void artifactAvailable(ResolvableArtifact artifact) {
        ComponentArtifactIdentifier artifactId = artifact.getId();
        Optional<TransformationNode> node = this.transformationNodeRegistry.getIfExecuted(artifactId, this.transformation);
        if (node.isPresent()) {
            this.artifactResults.put(artifactId, new PrecomputedTransformationResult(node.get().getTransformedSubject()));
        } else {
            File file = artifact.getFile();
            TransformationSubject initialSubject = TransformationSubject.initial(artifactId, file);
            TransformationResult result = this.createTransformationResult(initialSubject);
            this.artifactResults.put(artifactId, result);
        }
    }

    @Override
    public boolean requireArtifactFiles() {
        return true;
    }

    @Override
    public boolean includeFileDependencies() {
        return this.delegate.includeFileDependencies();
    }

    @Override
    public void fileAvailable(File file) {
        TransformationSubject initialSubject = TransformationSubject.initial(file);
        TransformationResult transformationResult = this.createTransformationResult(initialSubject);
        this.fileResults.put(file, transformationResult);
    }

    private TransformationResult createTransformationResult(TransformationSubject initialSubject) {
        CacheableInvocation<TransformationSubject> invocation = this.transformation.createInvocation(initialSubject, this.dependenciesResolver, null);
        return invocation.getCachedResult().map(PrecomputedTransformationResult::new).orElseGet(() -> {
            TransformationOperation operation = new TransformationOperation(invocation, "Transform " + initialSubject.getDisplayName() + " with " + this.transformation.getDisplayName());
            this.actions.add((BuildOperation)operation);
            return operation;
        });
    }
}

