/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.userinput;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.tasks.userinput.UserInputReader;

public class DefaultUserInputReader
implements UserInputReader {
    private static final char UNIX_NEW_LINE = '\n';
    private static final char WINDOWS_NEW_LINE = '\r';

    @Override
    public String readInput() {
        InputStreamReader br = new InputStreamReader(System.in);
        StringBuilder out = new StringBuilder();
        try {
            while (true) {
                int c;
                if (this.isEOF(c = ((Reader)br).read())) {
                    return null;
                }
                if (!this.isLineSeparator((char)c)) {
                    out.append((char)c);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        return out.toString();
    }

    private boolean isEOF(int c) {
        return c == 4 || c == -1;
    }

    private boolean isLineSeparator(char c) {
        return c == '\n' || c == '\r';
    }
}

