/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.InputChangesAwareTaskAction;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.TaskFingerprinter;
import org.gradle.api.internal.tasks.properties.FilePropertySpec;
import org.gradle.api.internal.tasks.properties.TaskProperties;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.impl.DefaultBeforeExecutionState;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveBeforeExecutionStateTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolveBeforeExecutionStateTaskExecuter.class);
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final ValueSnapshotter valueSnapshotter;
    private final TaskFingerprinter taskFingerprinter;
    private final TaskExecuter delegate;

    public ResolveBeforeExecutionStateTaskExecuter(ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ValueSnapshotter valueSnapshotter, TaskFingerprinter taskFingerprinter, TaskExecuter delegate) {
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.valueSnapshotter = valueSnapshotter;
        this.taskFingerprinter = taskFingerprinter;
        this.delegate = delegate;
    }

    @Override
    public TaskExecuterResult execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        if (context.getTaskExecutionMode().isTaskHistoryMaintained()) {
            context.setBeforeExecutionState(this.createExecutionState(task, context.getTaskProperties(), context.getAfterPreviousExecution(), context.getOutputFilesBeforeExecution()));
        }
        return this.delegate.execute(task, state, context);
    }

    private BeforeExecutionState createExecutionState(TaskInternal task, TaskProperties properties, @Nullable AfterPreviousExecutionState afterPreviousExecutionState, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> outputFiles) {
        Class<?> taskClass = task.getClass();
        List<InputChangesAwareTaskAction> taskActions = task.getTaskActions();
        ImplementationSnapshot taskImplementation = ImplementationSnapshot.of(taskClass, (ClassLoaderHierarchyHasher)this.classLoaderHierarchyHasher);
        ImmutableList<ImplementationSnapshot> taskActionImplementations = ResolveBeforeExecutionStateTaskExecuter.collectActionImplementations(taskActions, this.classLoaderHierarchyHasher);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Implementation for {}: {}", (Object)task, (Object)taskImplementation);
            LOGGER.debug("Action implementations for {}: {}", (Object)task, taskActionImplementations);
        }
        ImmutableSortedMap previousInputProperties = afterPreviousExecutionState == null ? ImmutableSortedMap.of() : afterPreviousExecutionState.getInputProperties();
        ImmutableSortedMap<String, ValueSnapshot> inputProperties = ResolveBeforeExecutionStateTaskExecuter.snapshotTaskInputProperties(task, properties, (ImmutableSortedMap<String, ValueSnapshot>)previousInputProperties, this.valueSnapshotter);
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFiles = this.taskFingerprinter.fingerprintTaskFiles(task, (SortedSet<? extends FilePropertySpec>)properties.getInputFileProperties());
        return new DefaultBeforeExecutionState(taskImplementation, taskActionImplementations, inputProperties, inputFiles, outputFiles);
    }

    private static ImmutableList<ImplementationSnapshot> collectActionImplementations(Collection<InputChangesAwareTaskAction> taskActions, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
        if (taskActions.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder actionImplementations = ImmutableList.builder();
        for (InputChangesAwareTaskAction taskAction : taskActions) {
            actionImplementations.add((Object)taskAction.getActionImplementation(classLoaderHierarchyHasher));
        }
        return actionImplementations.build();
    }

    private static ImmutableSortedMap<String, ValueSnapshot> snapshotTaskInputProperties(TaskInternal task, TaskProperties properties, ImmutableSortedMap<String, ValueSnapshot> previousInputProperties, ValueSnapshotter valueSnapshotter) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        Map inputPropertyValues = (Map)properties.getInputPropertyValues().create();
        assert (inputPropertyValues != null);
        for (Map.Entry entry : inputPropertyValues.entrySet()) {
            String propertyName = (String)entry.getKey();
            Object value = entry.getValue();
            try {
                ValueSnapshot previousSnapshot = (ValueSnapshot)previousInputProperties.get((Object)propertyName);
                if (previousSnapshot == null) {
                    builder.put((Object)propertyName, (Object)valueSnapshotter.snapshot(value));
                    continue;
                }
                builder.put((Object)propertyName, (Object)valueSnapshotter.snapshot(value, previousSnapshot));
            }
            catch (Exception e) {
                throw new UncheckedIOException(String.format("Unable to store input properties for %s. Property '%s' with value '%s' cannot be serialized.", task, propertyName, value), (Throwable)e);
            }
        }
        return builder.build();
    }
}

