/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.MethodProposalInfo;
import org.eclipse.wst.jsdt.internal.ui.text.java.ProposalContextInformation;
import org.eclipse.wst.jsdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.wst.jsdt.ui.text.java.JavaContentAssistInvocationContext;

public class JavaMethodCompletionProposal
extends LazyJavaCompletionProposal {
    protected static final char[] METHOD_TRIGGERS = new char[]{';', ',', '.', '\t', '['};
    protected static final char[] METHOD_WITH_ARGUMENTS_TRIGGERS = new char[]{'(', '-', ' '};
    protected static final char[] METHOD_NAME_TRIGGERS = new char[]{';'};
    private boolean fHasParameters;
    private boolean fHasParametersComputed = false;
    private LazyJavaCompletionProposal.FormatterPrefs fFormatterPrefs;

    public JavaMethodCompletionProposal(CompletionProposal proposal, JavaContentAssistInvocationContext context) {
        super(proposal, context);
    }

    @Override
    public void apply(IDocument document, char trigger, int offset) {
        if (trigger == ' ' || trigger == '(') {
            trigger = '\u0000';
        }
        super.apply(document, trigger, offset);
        if (this.needsLinkedMode()) {
            this.setUpLinkedMode(document, ')');
        }
    }

    protected boolean needsLinkedMode() {
        return this.hasArgumentList() && this.hasParameters();
    }

    @Override
    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        if (this.hasArgumentList()) {
            String completion = String.valueOf(this.fProposal.getName());
            if (this.isCamelCaseMatching()) {
                String prefix = this.getPrefix(document, completionOffset);
                return this.getCamelCaseCompound(prefix, completion);
            }
            return completion;
        }
        return super.getPrefixCompletionText(document, completionOffset);
    }

    @Override
    protected IContextInformation computeContextInformation() {
        if (this.fProposal.getKind() == 6 && this.hasParameters() && (this.getReplacementString().endsWith(")") || this.getReplacementString().length() == 0)) {
            ProposalContextInformation contextInformation = new ProposalContextInformation(this.fProposal);
            if (this.fContextInformationPosition != 0 && this.fProposal.getCompletion().length == 0) {
                contextInformation.setContextInformationPosition(this.fContextInformationPosition);
            }
            return contextInformation;
        }
        return super.computeContextInformation();
    }

    @Override
    protected char[] computeTriggerCharacters() {
        if (this.fProposal.getKind() == 12 || this.fProposal.getKind() == 6 || this.fProposal.getKind() == 26) {
            return METHOD_NAME_TRIGGERS;
        }
        if (this.hasParameters()) {
            return METHOD_WITH_ARGUMENTS_TRIGGERS;
        }
        return METHOD_TRIGGERS;
    }

    protected final boolean hasParameters() {
        if (!this.fHasParametersComputed) {
            this.fHasParametersComputed = true;
            this.fHasParameters = this.computeHasParameters();
        }
        return this.fHasParameters;
    }

    private boolean computeHasParameters() throws IllegalArgumentException {
        return this.fProposal.hasParameters() || Signature.getParameterCount((char[])this.fProposal.getSignature()) > 0;
    }

    protected boolean hasArgumentList() {
        if (12 == this.fProposal.getKind()) {
            return false;
        }
        IPreferenceStore preferenceStore = JavaScriptPlugin.getDefault().getPreferenceStore();
        boolean noOverwrite = preferenceStore.getBoolean("content_assist_insert_completion") ^ this.isToggleEating();
        char[] completion = this.fProposal.getCompletion();
        return !this.isInJavadoc() && completion.length > 0 && (noOverwrite || completion[completion.length - 1] == ')');
    }

    @Override
    protected final LazyJavaCompletionProposal.FormatterPrefs getFormatterPrefs() {
        if (this.fFormatterPrefs == null) {
            this.fFormatterPrefs = new LazyJavaCompletionProposal.FormatterPrefs(this.fInvocationContext.getProject());
        }
        return this.fFormatterPrefs;
    }

    @Override
    protected String computeReplacementString() {
        if (!this.hasArgumentList()) {
            return super.computeReplacementString();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.fProposal.getName());
        LazyJavaCompletionProposal.FormatterPrefs prefs = this.getFormatterPrefs();
        if (prefs.beforeOpeningParen) {
            buffer.append(" ");
        }
        buffer.append("(");
        if (this.hasParameters()) {
            this.setCursorPosition(buffer.length());
            if (prefs.afterOpeningParen) {
                buffer.append(" ");
            }
        } else if (prefs.inEmptyList) {
            buffer.append(" ");
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    protected ProposalInfo computeProposalInfo() {
        IJavaScriptProject project = this.fInvocationContext.getProject();
        if (project != null) {
            return new MethodProposalInfo(project, this.fProposal);
        }
        return super.computeProposalInfo();
    }

    @Override
    protected String computeSortString() {
        int parameterCount;
        char[] parameterList;
        char[] name = this.fProposal.getName();
        char[] signature = this.fProposal.getSignature();
        if (signature != null) {
            parameterList = Signature.toCharArray((char[])this.fProposal.getSignature(), null, null, (boolean)false, (boolean)false);
            parameterCount = Signature.getParameterCount((char[])this.fProposal.getSignature()) % 10;
        } else {
            char[][] params = this.fProposal.getParamaterNames();
            if (params != null) {
                parameterList = CharOperation.concatWith((char[][])params, (char)',');
                parameterCount = params.length % 10;
            } else {
                parameterList = new char[]{};
                parameterCount = 0;
            }
        }
        StringBuffer buf = new StringBuffer(name.length + 2 + parameterList.length);
        buf.append(name);
        buf.append('\u0000');
        buf.append(parameterCount);
        buf.append(parameterList);
        return buf.toString();
    }

    @Override
    public boolean isValidPrefix(String prefix) {
        if (super.isValidPrefix(prefix)) {
            return true;
        }
        String name = new String(this.fProposal.getName());
        int lastSeperatorIndex = name.lastIndexOf(46);
        if (lastSeperatorIndex != -1) {
            name = name.substring(lastSeperatorIndex + 1);
            if ((name = name.toLowerCase()).indexOf(prefix.toLowerCase()) == 0) {
                return true;
            }
        }
        String word = this.getDisplayString();
        if (this.isInJavadoc()) {
            int idx = word.indexOf("{@link ");
            if (idx == 0) {
                word = word.substring(7);
            } else {
                idx = word.indexOf("{@value ");
                if (idx == 0) {
                    word = word.substring(8);
                }
            }
        }
        return this.isPrefix(prefix, word);
    }
}

