/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintColumn;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditConstraintPage;

public class PostgreConstraintConfigurator
implements DBEObjectConfigurator<PostgreTableBase, PostgreTableConstraint> {
    public PostgreTableConstraint configureObject(DBRProgressMonitor monitor, final PostgreTableBase parent, final PostgreTableConstraint constraint) {
        return (PostgreTableConstraint)new UITask<PostgreTableConstraint>(){

            protected PostgreTableConstraint runTask() {
                EditConstraintPage editPage = new EditConstraintPage(PostgreMessages.edit_constraint_page_add_constraint, (DBSEntity)parent, new DBSEntityConstraintType[]{DBSEntityConstraintType.PRIMARY_KEY, DBSEntityConstraintType.UNIQUE_KEY, DBSEntityConstraintType.CHECK});
                if (!editPage.edit()) {
                    return null;
                }
                constraint.setName(editPage.getConstraintName());
                constraint.setConstraintType(editPage.getConstraintType());
                if (constraint.getConstraintType().isCustom()) {
                    constraint.setSource(editPage.getConstraintExpression());
                } else {
                    int colIndex = 1;
                    for (DBSEntityAttribute tableColumn : editPage.getSelectedAttributes()) {
                        constraint.addColumn(new PostgreTableConstraintColumn((PostgreTableConstraintBase)constraint, (PostgreAttribute)tableColumn, colIndex++));
                    }
                }
                return constraint;
            }
        }.execute();
    }
}

