/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.DBNRoot;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.ISearchContextProvider;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.itemlist.ItemListControl;
import org.jkiss.dbeaver.ui.controls.itemlist.ObjectListControl;
import org.jkiss.dbeaver.ui.editors.INavigatorEditorInput;
import org.jkiss.dbeaver.ui.editors.NodeEditorInput;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;

public class FolderEditor
extends EditorPart
implements INavigatorModelView,
IRefreshablePart,
ISearchContextProvider {
    private static final Log log = Log.getLog(FolderEditor.class);
    private FolderListControl itemControl;
    private List<String> history = new ArrayList<String>();
    private int historyPosition = 0;

    public void createPartControl(Composite parent) {
        this.itemControl = new FolderListControl(parent);
        this.itemControl.createProgressPanel();
        this.itemControl.loadData();
        this.getSite().setSelectionProvider(this.itemControl.getSelectionProvider());
        this.history.add(this.getRootNode().getNodeItemPath());
    }

    public void setFocus() {
        this.itemControl.setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public INavigatorEditorInput getEditorInput() {
        return (INavigatorEditorInput)super.getEditorInput();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input != null) {
            DBNNode navigatorNode = this.getEditorInput().getNavigatorNode();
            this.setTitleImage(DBeaverIcons.getImage((DBPImage)navigatorNode.getNodeIcon()));
            this.setPartName(navigatorNode.getNodeName());
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public DBNNode getRootNode() {
        return this.getEditorInput().getNavigatorNode();
    }

    @Override
    @Nullable
    public Viewer getNavigatorViewer() {
        return this.itemControl.getNavigatorViewer();
    }

    public void refreshPart(Object source, boolean force) {
        UIUtils.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!FolderEditor.this.itemControl.isDisposed()) {
                    FolderEditor.this.itemControl.loadData(false);
                }
            }
        });
    }

    public boolean isSearchPossible() {
        return this.itemControl.isSearchPossible();
    }

    public boolean isSearchEnabled() {
        return this.itemControl.isSearchEnabled();
    }

    public boolean performSearch(ISearchContextProvider.SearchType searchType) {
        return this.itemControl.performSearch(searchType);
    }

    public int getHistoryPosition() {
        return this.historyPosition;
    }

    public int getHistorySize() {
        return this.history.size();
    }

    public void navigateHistory(int position) {
        if (position >= this.history.size()) {
            position = this.history.size() - 1;
        } else if (position < 0) {
            position = -1;
        }
        if (position < 0 || position >= this.history.size()) {
            return;
        }
        String nodePath = this.history.get(position);
        try {
            DBNNode node = DBWorkbench.getPlatform().getNavigatorModel().getNodeByPath((DBRProgressMonitor)new VoidProgressMonitor(), nodePath);
            if (node != null) {
                this.historyPosition = position;
                this.itemControl.changeCurrentNode(node);
            }
        }
        catch (DBException e) {
            log.error((Object)e);
        }
    }

    private boolean canOpenNode(DBNNode node) {
        return node instanceof DBNDatabaseNode || node instanceof DBNResource && ((DBNResource)node).getResource() instanceof IFile;
    }

    private class FolderListControl
    extends ItemListControl {
        public FolderListControl(Composite parent) {
            super(parent, 0x10000000, (IWorkbenchSite)FolderEditor.this.getSite(), FolderEditor.this.getEditorInput().getNavigatorNode(), (DBXTreeNode)null);
        }

        @Override
        protected void setListData(Collection<DBNNode> items, boolean append) {
            DBNNode rootNode;
            DBNNode parentNode;
            if (!append && ((parentNode = (rootNode = this.getRootNode()).getParentNode()) instanceof DBNProjectDatabases || parentNode instanceof DBNLocalFolder)) {
                ArrayList<DBNNode> nodesWithParent = new ArrayList<DBNNode>(items);
                nodesWithParent.add(0, (DBNNode)DBWorkbench.getPlatform().getNavigatorModel().getRoot());
                items = nodesWithParent;
            }
            super.setListData(items, append);
        }

        @Override
        @Nullable
        protected Object getCellValue(Object element, ObjectListControl.ObjectColumn objectColumn) {
            if (element instanceof DBNRoot) {
                return objectColumn.isNameColumn(this.getObjectValue((DBNNode)((DBNRoot)element))) ? ".." : "";
            }
            return super.getCellValue(element, objectColumn);
        }

        @Override
        protected void openNodeEditor(DBNNode node) {
            DBNNode rootNode = this.getRootNode();
            if (!FolderEditor.this.canOpenNode(node)) {
                if (node instanceof DBNRoot) {
                    node = rootNode instanceof DBNLocalFolder ? ((DBNLocalFolder)rootNode).getLogicalParent() : rootNode.getParentNode();
                }
                if (FolderEditor.this.historyPosition >= 0) {
                    while (FolderEditor.this.historyPosition < FolderEditor.this.history.size() - 1) {
                        FolderEditor.this.history.remove(FolderEditor.this.historyPosition + 1);
                    }
                }
                FolderEditor folderEditor = FolderEditor.this;
                folderEditor.historyPosition = folderEditor.historyPosition + 1;
                FolderEditor.this.history.add(node.getNodeItemPath());
                this.changeCurrentNode(node);
            } else {
                super.openNodeEditor(node);
            }
        }

        private void changeCurrentNode(DBNNode node) {
            if (this.getRootNode() != null && node.getClass() != this.getRootNode().getClass()) {
                this.clearListData();
            }
            this.setRootNode(node);
            this.loadData();
            FolderEditor.this.setPartName(node.getNodeName());
            FolderEditor.this.setTitleImage(DBeaverIcons.getImage((DBPImage)node.getNodeIcon()));
            this.updateActions();
            INavigatorEditorInput editorInput = FolderEditor.this.getEditorInput();
            if (editorInput instanceof NodeEditorInput) {
                ((NodeEditorInput)editorInput).setNavigatorNode(node);
            }
        }

        @Override
        public void fillCustomActions(IContributionManager contributionManager) {
            contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)FolderEditor.this.getSite(), (String)"org.eclipse.ui.navigate.backwardHistory", (int)8, (DBPImage)UIIcon.RS_BACK));
            contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)FolderEditor.this.getSite(), (String)"org.eclipse.ui.navigate.forwardHistory", (int)8, (DBPImage)UIIcon.RS_FORWARD));
            contributionManager.add((IContributionItem)new Separator());
            super.fillCustomActions(contributionManager);
        }
    }
}

