/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.itemlist;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ObjectViewerRenderer;
import org.jkiss.dbeaver.ui.controls.itemlist.ObjectListControl;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.utils.CommonUtils;

public abstract class DatabaseObjectListControl<OBJECT_TYPE extends DBPObject>
extends ObjectListControl<OBJECT_TYPE> {
    private IWorkbenchSite site;

    protected DatabaseObjectListControl(Composite parent, int style, IWorkbenchSite site, IContentProvider contentProvider) {
        super(parent, style, contentProvider);
        this.site = site;
        this.setFitWidth(true);
        this.createContextMenu();
    }

    @Override
    protected ObjectViewerRenderer createRenderer() {
        return new ObjectListRenderer();
    }

    private void createContextMenu() {
        NavigatorUtils.createContextMenu(this.site, (Viewer)this.getItemsViewer(), new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action copyAction = new Action(WorkbenchMessages.Workbench_copy){

                    public void run() {
                        String text = DatabaseObjectListControl.this.getRenderer().getSelectedText();
                        if (!CommonUtils.isEmpty((String)text)) {
                            UIUtils.setClipboardContents((Display)DatabaseObjectListControl.this.getDisplay(), (Transfer)TextTransfer.getInstance(), (Object)text);
                        }
                    }
                };
                copyAction.setEnabled(!DatabaseObjectListControl.this.getSelectionProvider().getSelection().isEmpty());
                manager.add((IAction)copyAction);
                manager.add((IContributionItem)new Separator());
                DatabaseObjectListControl.this.fillCustomActions((IContributionManager)manager);
            }
        });
    }

    private class ObjectListRenderer
    extends ObjectListControl.ViewerRenderer {
        private ObjectListRenderer() {
        }

        public boolean isHyperlink(Object cellValue) {
            return cellValue instanceof DBSObject;
        }

        public void navigateHyperlink(Object cellValue) {
            if (cellValue instanceof DBSObject) {
                NavigatorHandlerObjectOpen.openEntityEditor((DBSObject)cellValue);
            }
        }
    }
}

