/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.EmptyAction;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class ResultSetReferenceMenu {
    static Action NOREFS_ACTION = new EmptyAction(ResultSetMessages.controls_resultset_ref_menu_no_references);
    static Action REFS_TITLE_ACTION = new EmptyAction(ResultSetMessages.controls_resultset_ref_menu_references);
    static Action NOFKS_ACTION = new EmptyAction(ResultSetMessages.controls_resultset_ref_menu_no_associations);
    static Action FKS_TITLE_ACTION = new EmptyAction(ResultSetMessages.controls_resultset_ref_menu_associations);

    static void fillRefTablesActions(final ResultSetViewer viewer, final List<ResultSetRow> rows, DBSEntity singleSource, IMenuManager manager, final boolean openInNewWindow) {
        DBSEntity refTable;
        ArrayList references = new ArrayList();
        ArrayList associations = new ArrayList();
        DBRRunnableWithProgress refCollector = monitor -> {
            try {
                monitor.beginTask("Read references", 1);
                Collection refs = singleSource.getReferences(monitor);
                if (refs != null) {
                    monitor.beginTask("Check references", refs.size());
                    for (DBSEntityAssociation ref : refs) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        monitor.subTask("Check references " + ref.getName());
                        boolean allMatch = true;
                        DBSEntityConstraint ownConstraint = ref.getReferencedConstraint();
                        if (ownConstraint instanceof DBSEntityReferrer) {
                            for (DBSEntityAttributeRef ownAttrRef : ((DBSEntityReferrer)ownConstraint).getAttributeReferences(monitor)) {
                                if (viewer.getModel().getAttributeBinding((DBSAttributeBase)ownAttrRef.getAttribute()) != null) continue;
                                allMatch = false;
                                break;
                            }
                        }
                        if (allMatch) {
                            references.add(ref);
                        }
                        monitor.worked(1);
                    }
                }
                monitor.done();
                if (monitor.isCanceled()) {
                    return;
                }
                monitor.beginTask("Read associations", 1);
                Collection fks = singleSource.getAssociations(monitor);
                if (fks != null) {
                    monitor.beginTask("Check associations", fks.size());
                    for (DBSEntityAssociation fk : fks) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        monitor.subTask("Check association " + fk.getName());
                        boolean allMatch = true;
                        if (fk instanceof DBSEntityReferrer && fk.getReferencedConstraint() != null) {
                            for (DBSEntityAttributeRef ownAttr : ((DBSEntityReferrer)fk).getAttributeReferences(monitor)) {
                                if (viewer.getModel().getAttributeBinding((DBSAttributeBase)ownAttr.getAttribute()) != null) continue;
                                allMatch = false;
                                break;
                            }
                        }
                        if (allMatch) {
                            associations.add(fk);
                        }
                        monitor.worked(1);
                    }
                }
                monitor.done();
            }
            catch (DBException e) {
                throw new InvocationTargetException(e);
            }
        };
        try {
            UIUtils.runInProgressService((DBRRunnableWithProgress)refCollector);
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Table References", "Error reading referencing tables for '" + singleSource.getName() + "'", e.getTargetException());
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        manager.removeAll();
        if (CommonUtils.isEmpty(associations)) {
            manager.add((IAction)NOFKS_ACTION);
        } else {
            manager.add((IAction)FKS_TITLE_ACTION);
            manager.add((IContributionItem)new Separator());
            for (final DBSEntityAssociation association : associations) {
                refTable = association.getReferencedConstraint().getParentObject();
                manager.add((IAction)new Action(String.valueOf(DBUtils.getObjectFullName((DBPNamedObject)refTable, (DBPEvaluationContext)DBPEvaluationContext.UI)) + " (" + association.getName() + ")", DBeaverIcons.getImageDescriptor((DBPImage)DBSEntityType.TABLE.getIcon())){

                    public void run() {
                        new AbstractJob("Navigate association"){

                            protected IStatus run(DBRProgressMonitor monitor) {
                                try {
                                    viewer.navigateAssociation((DBRProgressMonitor)new VoidProgressMonitor(), association, null, rows, openInNewWindow);
                                }
                                catch (DBException e) {
                                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                                }
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                });
            }
        }
        manager.add((IContributionItem)new Separator());
        if (CommonUtils.isEmpty(references)) {
            manager.add((IAction)NOREFS_ACTION);
        } else {
            manager.add((IAction)REFS_TITLE_ACTION);
            manager.add((IContributionItem)new Separator());
            for (final DBSEntityAssociation refAssociation : references) {
                refTable = refAssociation.getParentObject();
                manager.add((IAction)new Action(String.valueOf(DBUtils.getObjectFullName((DBPNamedObject)refTable, (DBPEvaluationContext)DBPEvaluationContext.UI)) + " (" + refAssociation.getName() + ")", DBeaverIcons.getImageDescriptor((DBPImage)DBSEntityType.TABLE.getIcon())){

                    public void run() {
                        new AbstractJob("Navigate reference"){

                            protected IStatus run(DBRProgressMonitor monitor) {
                                try {
                                    viewer.navigateReference((DBRProgressMonitor)new VoidProgressMonitor(), refAssociation, rows, openInNewWindow);
                                }
                                catch (DBException e) {
                                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                                }
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                });
            }
        }
    }
}

