/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.virtual.DBVColorOverride;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetValueController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.IValueManager;
import org.jkiss.dbeaver.ui.data.registry.ValueManagerRegistry;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

class ColorSettingsDialog
extends BaseDialog {
    private static final Log log = Log.getLog(ColorSettingsDialog.class);
    private static final String DIALOG_ID = "DBeaver.ColorSettingsDialog";
    private static RGB DEFAULT_RGB;
    @NotNull
    private final ResultSetViewer resultSetViewer;
    @NotNull
    private final DBDAttributeBinding attribute;
    @Nullable
    private final ResultSetRow row;
    private Table colorsTable;
    private Button rangeCheck;
    private ColorSelector bgColorSelector1;
    private ColorSelector bgColorSelector2;
    private ColorSelector fgColorSelector1;
    private ColorSelector fgColorSelector2;
    private IValueEditor valueEditor1;
    private IValueEditor valueEditor2;
    private ControlEnableState settingsEnableState;
    private Composite settingsGroup;
    private List<DBVColorOverride> colorOverrides;
    private Button singleColumnCheck;
    private DBVColorOverride curOverride;

    public ColorSettingsDialog(@NotNull ResultSetViewer resultSetViewer, @NotNull DBDAttributeBinding attr, @Nullable ResultSetRow row) {
        super(resultSetViewer.getControl().getShell(), "Customize colors for [" + attr.getName() + "]", (DBPImage)UIIcon.PALETTE);
        this.resultSetViewer = resultSetViewer;
        this.attribute = attr;
        this.row = row;
        DEFAULT_RGB = resultSetViewer.getControl().getDisplay().getSystemColor(22).getRGB();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite mainGroup = new Composite(composite, 0);
        mainGroup.setLayoutData((Object)new GridData(1810));
        mainGroup.setLayout((Layout)new GridLayout(2, false));
        Composite colorsGroup = new Composite(mainGroup, 0);
        colorsGroup.setLayoutData((Object)new GridData(1810));
        colorsGroup.setLayout((Layout)new GridLayout(1, false));
        UIUtils.createControlLabel((Composite)colorsGroup, (String)"Cell conditions");
        this.colorsTable = new Table(colorsGroup, 67584);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        this.colorsTable.setLayoutData((Object)gd);
        UIUtils.createTableColumn((Table)this.colorsTable, (int)16384, (String)"Operator");
        UIUtils.createTableColumn((Table)this.colorsTable, (int)131072, (String)"Value(s)");
        UIUtils.executeOnResize((Control)this.colorsTable, () -> UIUtils.packColumns((Table)this.colorsTable, (boolean)true));
        final DBVEntity vEntity = DBVUtils.getVirtualEntity((DBDAttributeBinding)this.attribute, (boolean)true);
        this.colorOverrides = vEntity.getColorOverrides(this.attribute.getName());
        if (this.colorOverrides == null) {
            this.colorOverrides = new ArrayList<DBVColorOverride>();
        }
        for (DBVColorOverride co : this.colorOverrides) {
            TableItem tableItem = new TableItem(this.colorsTable, 0);
            tableItem.setData((Object)co);
            this.updateTreeItem(tableItem);
        }
        Composite buttonsPanel = UIUtils.createComposite((Composite)colorsGroup, (int)2);
        Button btnAdd = this.createButton(buttonsPanel, 1000, "Add", false);
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorSettingsDialog.this.curOverride = new DBVColorOverride(ColorSettingsDialog.this.attribute.getName(), DBCLogicalOperator.EQUALS, null, null, null);
                vEntity.addColorOverride(ColorSettingsDialog.this.curOverride);
                TableItem tableItem = new TableItem(ColorSettingsDialog.this.colorsTable, 0);
                tableItem.setData((Object)ColorSettingsDialog.this.curOverride);
                ColorSettingsDialog.this.colorsTable.setSelection(tableItem);
                ColorSettingsDialog.this.updateTreeItem(tableItem);
                ColorSettingsDialog.this.updateSettingsValues();
                ColorSettingsDialog.this.updateControlsState();
            }
        });
        final Button btnDelete = this.createButton(buttonsPanel, 1001, "Delete", false);
        btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColorSettingsDialog.this.curOverride != null) {
                    ColorSettingsDialog.this.colorsTable.getItem(ColorSettingsDialog.this.colorsTable.getSelectionIndex()).dispose();
                    vEntity.removeColorOverride(ColorSettingsDialog.this.curOverride);
                    ColorSettingsDialog.this.curOverride = null;
                    ColorSettingsDialog.this.updateSettingsValues();
                    ColorSettingsDialog.this.updateControlsState();
                }
            }
        });
        this.colorsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = ColorSettingsDialog.this.colorsTable.getSelectionIndex();
                ColorSettingsDialog.this.curOverride = selectionIndex < 0 ? null : (DBVColorOverride)ColorSettingsDialog.this.colorsTable.getItem(selectionIndex).getData();
                btnDelete.setEnabled(selectionIndex >= 0);
                ColorSettingsDialog.this.updateSettingsValues();
                ColorSettingsDialog.this.updateControlsState();
            }
        });
        this.settingsGroup = new Composite(mainGroup, 0);
        this.settingsGroup.setLayoutData((Object)new GridData(1810));
        this.settingsGroup.setLayout((Layout)new GridLayout(3, false));
        gd = new GridData();
        gd.horizontalSpan = 3;
        UIUtils.createControlLabel((Composite)this.settingsGroup, (String)"Settings").setLayoutData((Object)gd);
        this.rangeCheck = UIUtils.createCheckbox((Composite)this.settingsGroup, (String)"Range / gradient", (String)"Use value range / color gradient", (boolean)false, (int)3);
        this.rangeCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorSettingsDialog.this.updateControlsState();
                if (ColorSettingsDialog.this.curOverride != null) {
                    ColorSettingsDialog.this.curOverride.setRange(ColorSettingsDialog.this.rangeCheck.getSelection());
                }
            }
        });
        this.singleColumnCheck = UIUtils.createCheckbox((Composite)this.settingsGroup, (String)"Use colors for this column only", (String)"Apply colors for this column only, otherwise color full rows", (boolean)false, (int)3);
        this.singleColumnCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColorSettingsDialog.this.curOverride != null) {
                    ColorSettingsDialog.this.curOverride.setSingleColumn(ColorSettingsDialog.this.singleColumnCheck.getSelection());
                }
            }
        });
        UIUtils.createControlLabel((Composite)this.settingsGroup, (String)"Value(s)");
        this.valueEditor1 = this.createValueEditor(this.settingsGroup, 0);
        this.valueEditor2 = this.createValueEditor(this.settingsGroup, 1);
        UIUtils.createControlLabel((Composite)this.settingsGroup, (String)"Background");
        this.bgColorSelector1 = new ColorSelector(this.settingsGroup);
        this.bgColorSelector1.addListener(event -> {
            this.curOverride.setColorBackground(StringConverter.asString((RGB)this.bgColorSelector1.getColorValue()));
            this.updateCurrentTreeItem();
        });
        this.bgColorSelector2 = new ColorSelector(this.settingsGroup);
        this.bgColorSelector2.addListener(event -> {
            this.curOverride.setColorBackground2(StringConverter.asString((RGB)this.bgColorSelector2.getColorValue()));
            this.updateCurrentTreeItem();
        });
        UIUtils.createControlLabel((Composite)this.settingsGroup, (String)"Foreground");
        this.fgColorSelector1 = new ColorSelector(this.settingsGroup);
        this.fgColorSelector1.addListener(event -> {
            this.curOverride.setColorForeground(StringConverter.asString((RGB)this.fgColorSelector1.getColorValue()));
            this.updateCurrentTreeItem();
        });
        this.fgColorSelector2 = new ColorSelector(this.settingsGroup);
        this.fgColorSelector2.addListener(event -> {
            this.curOverride.setColorForeground2(StringConverter.asString((RGB)this.fgColorSelector2.getColorValue()));
            this.updateCurrentTreeItem();
        });
        UIUtils.createInfoLabel((Composite)this.settingsGroup, (String)"To use gradient set minimum and maximum\ncolumn values and two\ncolors for gradient range. ", (int)768, (int)3);
        this.updateControlsState();
        return parent;
    }

    private void updateSettingsValues() {
        try {
            if (this.curOverride == null) {
                if (this.valueEditor1 != null) {
                    this.valueEditor1.primeEditorValue(null);
                }
                if (this.valueEditor2 != null) {
                    this.valueEditor2.primeEditorValue(null);
                }
                this.rangeCheck.setSelection(false);
                this.singleColumnCheck.setSelection(false);
                this.bgColorSelector1.setColorValue(DEFAULT_RGB);
                this.fgColorSelector1.setColorValue(DEFAULT_RGB);
                this.bgColorSelector2.setColorValue(DEFAULT_RGB);
                this.fgColorSelector2.setColorValue(DEFAULT_RGB);
            } else {
                this.rangeCheck.setSelection(this.curOverride.isRange());
                this.singleColumnCheck.setSelection(this.curOverride.isSingleColumn());
                Object[] values = this.curOverride.getAttributeValues();
                if (this.valueEditor1 != null) {
                    this.valueEditor1.primeEditorValue(ArrayUtils.isEmpty((Object[])values) ? null : values[0]);
                }
                if (!CommonUtils.isEmpty((String)this.curOverride.getColorBackground())) {
                    this.bgColorSelector1.setColorValue(StringConverter.asRGB((String)this.curOverride.getColorBackground()));
                } else {
                    this.bgColorSelector1.setColorValue(DEFAULT_RGB);
                }
                if (!CommonUtils.isEmpty((String)this.curOverride.getColorForeground())) {
                    this.fgColorSelector1.setColorValue(StringConverter.asRGB((String)this.curOverride.getColorForeground()));
                } else {
                    this.fgColorSelector1.setColorValue(DEFAULT_RGB);
                }
                if (this.curOverride.isRange()) {
                    if (this.valueEditor2 != null) {
                        this.valueEditor2.primeEditorValue(values.length < 2 ? null : values[1]);
                    }
                    if (!CommonUtils.isEmpty((String)this.curOverride.getColorBackground2())) {
                        this.bgColorSelector2.setColorValue(StringConverter.asRGB((String)this.curOverride.getColorBackground2()));
                    } else {
                        this.bgColorSelector2.setColorValue(DEFAULT_RGB);
                    }
                    if (!CommonUtils.isEmpty((String)this.curOverride.getColorForeground2())) {
                        this.fgColorSelector2.setColorValue(StringConverter.asRGB((String)this.curOverride.getColorForeground2()));
                    } else {
                        this.fgColorSelector2.setColorValue(DEFAULT_RGB);
                    }
                }
            }
        }
        catch (DBException e) {
            log.error((Object)e);
        }
    }

    private void updateControlsState() {
        if (this.curOverride == null) {
            this.settingsEnableState = ControlEnableState.disable((Control)this.settingsGroup);
        } else if (this.settingsEnableState != null) {
            this.settingsEnableState.restore();
            this.settingsEnableState = null;
        }
        boolean isRange = this.rangeCheck.getSelection();
        if (this.valueEditor2 != null) {
            this.valueEditor2.getControl().setEnabled(isRange);
        }
        this.bgColorSelector2.setEnabled(isRange);
        this.fgColorSelector2.setEnabled(isRange);
        this.singleColumnCheck.setEnabled(false);
    }

    private IValueEditor createValueEditor(Composite panel, final int index) {
        try {
            IValueManager valueManager = ValueManagerRegistry.findValueManager(this.resultSetViewer.getDataContainer().getDataSource(), (DBSTypedObject)this.attribute, this.attribute.getValueHandler().getValueObjectType((DBSTypedObject)this.attribute));
            ColorValueController valueController = new ColorValueController(this, this.settingsGroup){

                @Override
                public Object getValue() {
                    if (curOverride == null) {
                        return null;
                    }
                    Object[] attributeValues = curOverride.getAttributeValues();
                    if (attributeValues == null || index > attributeValues.length - 1) {
                        return null;
                    }
                    return attributeValues[index];
                }
            };
            Composite editorPlaceholder = new Composite(panel, 0);
            editorPlaceholder.setLayoutData((Object)new GridData(768));
            editorPlaceholder.setLayout((Layout)new FillLayout());
            valueController.setInlinePlaceholder(editorPlaceholder);
            IValueEditor editor = valueManager.createEditor(valueController);
            if (editor == null) {
                Label errorLabel = new Label(editorPlaceholder, 0);
                errorLabel.setText("N/A");
            } else {
                editor.createControl();
                editor.getControl().addListener(24, event -> {
                    if (this.curOverride != null) {
                        try {
                            Object value = editor.extractEditorValue();
                            Object[] attributeValues = this.curOverride.getAttributeValues();
                            int valueCount = index + 1;
                            if (attributeValues == null) {
                                attributeValues = new Object[valueCount];
                            } else if (attributeValues.length < valueCount) {
                                Object[] newAttributeValues = new Object[valueCount];
                                System.arraycopy(attributeValues, 0, newAttributeValues, 0, attributeValues.length);
                                attributeValues = newAttributeValues;
                            }
                            attributeValues[n] = value;
                            this.curOverride.setAttributeValues(attributeValues);
                            this.updateCurrentTreeItem();
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                    }
                });
            }
            return editor;
        }
        catch (DBException e) {
            log.error((Object)e);
            return null;
        }
    }

    private void updateCurrentTreeItem() {
        this.updateTreeItem(this.colorsTable.getItem(this.colorsTable.getSelectionIndex()));
    }

    private void updateTreeItem(TableItem tableItem) {
        DBVColorOverride co = (DBVColorOverride)tableItem.getData();
        tableItem.setText(0, co.getOperator().getStringValue());
        Object[] values = co.getAttributeValues();
        if (ArrayUtils.isEmpty((Object[])values)) {
            tableItem.setText(1, "");
        } else if (values.length == 1) {
            tableItem.setText(1, DBValueFormatting.getDefaultValueDisplayString((Object)values[0], (DBDDisplayFormat)DBDDisplayFormat.UI));
        } else {
            tableItem.setText(1, Arrays.toString(values));
        }
        if (!CommonUtils.isEmpty((String)co.getColorBackground())) {
            tableItem.setBackground(UIUtils.getSharedColor((String)co.getColorBackground()));
        }
        if (!CommonUtils.isEmpty((String)co.getColorForeground())) {
            tableItem.setForeground(UIUtils.getSharedColor((String)co.getColorForeground()));
        }
    }

    public int open() {
        return super.open();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        this.resultSetViewer.getModel().updateColorMapping(true);
        super.okPressed();
    }

    private class ColorValueController
    extends ResultSetValueController {
        public ColorValueController(Composite inlinePlaceholder) {
            super(ColorSettingsDialog.this.resultSetViewer, ColorSettingsDialog.this.attribute, null, IValueController.EditType.INLINE, inlinePlaceholder);
        }

        void setInlinePlaceholder(Composite ph) {
            this.inlinePlaceholder = ph;
        }
    }
}

