/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.lightgrid;

import java.util.Comparator;
import org.jkiss.dbeaver.model.data.DBDCellValue;

public class GridPos
implements DBDCellValue {
    public int col;
    public int row;

    public GridPos(int col, int row) {
        this.col = col;
        this.row = row;
    }

    public GridPos(GridPos copy) {
        this.col = copy.col;
        this.row = copy.row;
    }

    public boolean isValid() {
        return this.col >= 0 && this.row >= 0;
    }

    public boolean equals(Object object) {
        return object instanceof GridPos && this.equalsTo((GridPos)object);
    }

    public boolean equals(int col, int row) {
        return this.col == col && this.row == row;
    }

    public boolean equalsTo(GridPos pos) {
        return this.col == pos.col && this.row == pos.row;
    }

    public String toString() {
        return String.valueOf(this.col) + ":" + this.row;
    }

    public int hashCode() {
        return this.col ^ this.row;
    }

    public static class PosComparator
    implements Comparator<GridPos> {
        @Override
        public int compare(GridPos pos1, GridPos pos2) {
            int res = pos1.row - pos2.row;
            return res != 0 ? res : pos1.col - pos2.col;
        }
    }
}

