(function() {
  var PropertiesURL, fetchPropertyDescriptions, fs, path, propertiesPromise, propertyDescriptionsPromise, request;

  path = require('path');

  fs = require('fs');

  request = require('request');

  fetchPropertyDescriptions = require('./fetch-property-docs');

  PropertiesURL = 'https://raw.githubusercontent.com/adobe/brackets/master/src/extensions/default/CSSCodeHints/CSSProperties.json';

  propertiesPromise = new Promise(function(resolve) {
    return request({
      json: true,
      url: PropertiesURL
    }, function(error, response, properties) {
      if (error != null) {
        console.error(error.message);
        resolve(null);
      }
      if (response.statusCode !== 200) {
        console.error("Request for CSSProperties.json failed: " + response.statusCode);
        resolve(null);
      }
      return resolve(properties);
    });
  });

  propertyDescriptionsPromise = fetchPropertyDescriptions();

  Promise.all([propertiesPromise, propertyDescriptionsPromise]).then(function(values) {
    var completions, i, len, metadata, properties, propertiesRaw, propertyDescriptions, propertyName, pseudoSelectors, sortedPropertyNames, tags;
    properties = {};
    propertiesRaw = values[0];
    propertyDescriptions = values[1];
    sortedPropertyNames = JSON.parse(fs.readFileSync(path.join(__dirname, 'sorted-property-names.json')));
    for (i = 0, len = sortedPropertyNames.length; i < len; i++) {
      propertyName = sortedPropertyNames[i];
      if (!(metadata = propertiesRaw[propertyName])) {
        continue;
      }
      metadata.description = propertyDescriptions[propertyName];
      properties[propertyName] = metadata;
      if (propertyDescriptions[propertyName] == null) {
        console.warn("No description for property " + propertyName);
      }
    }
    for (propertyName in propertiesRaw) {
      if (sortedPropertyNames.indexOf(propertyName) < 0) {
        console.warn("Ignoring " + propertyName + "; not in sorted-property-names.json");
      }
    }
    tags = JSON.parse(fs.readFileSync(path.join(__dirname, 'html-tags.json')));
    pseudoSelectors = JSON.parse(fs.readFileSync(path.join(__dirname, 'pseudo-selectors.json')));
    completions = {
      tags: tags,
      properties: properties,
      pseudoSelectors: pseudoSelectors
    };
    return fs.writeFileSync(path.join(__dirname, 'completions.json'), (JSON.stringify(completions, null, '  ')) + "\n");
  });

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
