/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.URLLister;
import org.apache.ivy.util.Message;

public final class ResolverHelper {
    private ResolverHelper() {
    }

    public static String[] listTokenValues(Repository repository, String string, String string2) {
        String string3;
        String string4 = repository.getFileSeparator();
        int n = (string = repository.standardize(string)).indexOf(string3 = IvyPatternHelper.getTokenString(string2));
        if (n == -1) {
            Message.verbose("unable to list " + string2 + " in " + string + ": token not found in pattern");
            return null;
        }
        if ((string.length() <= n + string3.length() || string4.equals(string.substring(n + string3.length(), n + string3.length() + 1))) && (n == 0 || string4.equals(string.substring(n - 1, n)))) {
            String string5 = string.substring(0, n);
            return ResolverHelper.listAll(repository, string5);
        }
        int n2 = string.substring(0, n).lastIndexOf(string4);
        String string6 = n2 == -1 ? "" : string.substring(0, n2);
        try {
            Message.debug("\tusing " + repository + " to list all in " + string6);
            List list = repository.list(string6);
            if (list != null) {
                Message.debug("\t\tfound " + list.size() + " urls");
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                int n3 = string.indexOf(string4, n2 + 1);
                String string7 = n3 != -1 ? string.substring(n2 + 1, n3) : string.substring(n2 + 1);
                string7 = string7.replaceAll("\\.", "\\\\.");
                string7 = IvyPatternHelper.substituteToken(string7, string2, "(.+)");
                Pattern pattern = Pattern.compile(string7);
                for (String string8 : list) {
                    Matcher matcher = pattern.matcher(string8.substring(string6.length() + 1));
                    if (!matcher.matches()) continue;
                    String string9 = matcher.group(1);
                    arrayList.add(string9);
                }
                Message.debug("\t\t" + arrayList.size() + " matched " + string);
                return arrayList.toArray(new String[arrayList.size()]);
            }
            return null;
        }
        catch (IOException iOException) {
            Message.verbose("problem while listing resources in " + string6 + " with " + repository + ":");
            Message.verbose("  " + iOException.getClass().getName() + " " + iOException.getMessage());
            return null;
        }
        catch (Exception exception) {
            Message.warn("problem while listing resources in " + string6 + " with " + repository + ":");
            Message.warn("  " + exception.getClass().getName() + " " + exception.getMessage());
            return null;
        }
    }

    public static String[] listAll(Repository repository, String string) {
        try {
            String string2 = repository.getFileSeparator();
            Message.debug("\tusing " + repository + " to list all in " + string);
            List list = repository.list(string);
            if (list != null) {
                Message.debug("\t\tfound " + list.size() + " resources");
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                for (String string3 : list) {
                    if (string3.endsWith(string2)) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                    int n = string3.lastIndexOf(string2);
                    arrayList.add(string3.substring(n + 1));
                }
                return arrayList.toArray(new String[arrayList.size()]);
            }
            Message.debug("\t\tno resources found");
            return null;
        }
        catch (IOException iOException) {
            Message.verbose("problem while listing resources in " + string + " with " + repository + ":");
            Message.verbose("  " + iOException.getClass().getName() + " " + iOException.getMessage());
            return null;
        }
        catch (Exception exception) {
            Message.warn("problem while listing resources in " + string + " with " + repository + ":");
            Message.warn("  " + exception.getClass().getName() + " " + exception.getMessage());
            return null;
        }
    }

    public static ResolvedResource[] findAll(Repository repository, ModuleRevisionId moduleRevisionId, String string, Artifact artifact) {
        String string2 = IvyPatternHelper.substitute(string, ModuleRevisionId.newInstance(moduleRevisionId, IvyPatternHelper.getTokenString("revision")), artifact);
        Message.debug("\tlisting all in " + string2);
        String[] stringArray = ResolverHelper.listTokenValues(repository, string2, "revision");
        if (stringArray != null) {
            Message.debug("\tfound revs: " + Arrays.asList(stringArray));
            ArrayList<ResolvedResource> arrayList = new ArrayList<ResolvedResource>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = IvyPatternHelper.substituteToken(string2, "revision", stringArray[i]);
                try {
                    Resource resource = repository.getResource(string3);
                    if (resource == null) continue;
                    arrayList.add(new ResolvedResource(resource, stringArray[i]));
                    continue;
                }
                catch (IOException iOException) {
                    Message.warn("impossible to get resource from name listed by repository: " + string3 + ": " + iOException.getMessage());
                }
            }
            if (stringArray.length != arrayList.size()) {
                Message.debug("\tfound resolved res: " + arrayList);
            }
            return arrayList.toArray(new ResolvedResource[arrayList.size()]);
        }
        if (string2.indexOf("[revision]") == -1) {
            try {
                Resource resource = repository.getResource(string2);
                if (resource.exists()) {
                    Message.debug("\tonly one resource found without real listing: using and defining it as working@" + repository.getName() + " revision: " + resource.getName());
                    return new ResolvedResource[]{new ResolvedResource(resource, "working@" + repository.getName())};
                }
            }
            catch (IOException iOException) {
                Message.debug("\timpossible to get resource from name listed by repository: " + string2 + ": " + iOException.getMessage());
            }
            Message.debug("\tno revision found");
        }
        return null;
    }

    public static String[] listTokenValues(URLLister uRLLister, String string, String string2) {
        if (uRLLister.accept(string = ResolverHelper.standardize(string))) {
            String string3 = IvyPatternHelper.getTokenString(string2);
            int n = string.indexOf(string3);
            if (n == -1) {
                Message.verbose("unable to list " + string2 + " in " + string + ": token not found in pattern");
                return null;
            }
            if ((string.length() <= n + string3.length() || "/".equals(string.substring(n + string3.length(), n + string3.length() + 1))) && (n == 0 || "/".equals(string.substring(n - 1, n)))) {
                String string4 = string.substring(0, n);
                try {
                    return ResolverHelper.listAll(uRLLister, new URL(string4));
                }
                catch (MalformedURLException malformedURLException) {
                    Message.warn("malformed url from pattern root: " + string4 + ": " + malformedURLException.getMessage());
                    return null;
                }
            }
            int n2 = string.substring(0, n).lastIndexOf(47);
            String string5 = n2 == -1 ? "" : string.substring(0, n2);
            try {
                Message.debug("\tusing " + uRLLister + " to list all in " + string5);
                List list = uRLLister.listAll(new URL(string5));
                Message.debug("\t\tfound " + list.size() + " urls");
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                int n3 = string.indexOf(47, n2 + 1);
                String string6 = n3 != -1 ? string.substring(n2 + 1, n3) : string.substring(n2 + 1);
                String string7 = ".*" + IvyPatternHelper.substituteToken(string6, string2, "([^/]+)") + ".*";
                Pattern pattern = Pattern.compile(string7.toString());
                for (URL uRL : list) {
                    String string8 = ResolverHelper.standardize(uRL.getPath());
                    Matcher matcher = pattern.matcher(string8);
                    if (!matcher.matches()) continue;
                    String string9 = matcher.group(1);
                    arrayList.add(string9);
                }
                Message.debug("\t\t" + arrayList.size() + " matched " + string);
                return arrayList.toArray(new String[arrayList.size()]);
            }
            catch (Exception exception) {
                Message.warn("problem while listing files in " + string5 + ": " + exception.getClass() + " " + exception.getMessage());
                return null;
            }
        }
        return null;
    }

    private static String standardize(String string) {
        return string.replace('\\', '/');
    }

    public static String[] listAll(URLLister uRLLister, URL uRL) {
        try {
            if (uRLLister.accept(uRL.toExternalForm())) {
                Message.debug("\tusing " + uRLLister + " to list all in " + uRL);
                List list = uRLLister.listAll(uRL);
                Message.debug("\t\tfound " + list.size() + " urls");
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                for (URL uRL2 : list) {
                    String string = uRL2.getPath();
                    if (string.endsWith("/")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    int n = string.lastIndexOf(47);
                    arrayList.add(string.substring(n + 1));
                }
                return arrayList.toArray(new String[arrayList.size()]);
            }
            return null;
        }
        catch (Exception exception) {
            Message.warn("problem while listing directories in " + uRL + ": " + exception.getClass() + " " + exception.getMessage());
            return null;
        }
    }
}

