/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.codeInsight.navigation.ListBackgroundUpdaterTask;
import com.intellij.find.FindUtil;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.ListComponentUpdater;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.usages.UsageView;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementListNavigator {
    private PsiElementListNavigator() {
    }

    public static void openTargets(MouseEvent e, NavigatablePsiElement[] targets, String title, String findUsagesTitle, ListCellRenderer listRenderer) {
        PsiElementListNavigator.openTargets(e, targets, title, findUsagesTitle, listRenderer, (BackgroundUpdaterTask)null);
    }

    public static void openTargets(MouseEvent e, NavigatablePsiElement[] targets, String title, String findUsagesTitle, ListCellRenderer listRenderer, @Nullable BackgroundUpdaterTask listUpdaterTask) {
        JBPopup popup2 = PsiElementListNavigator.navigateOrCreatePopup(targets, title, findUsagesTitle, listRenderer, listUpdaterTask);
        if (popup2 != null) {
            RelativePoint point = new RelativePoint(e);
            if (listUpdaterTask != null) {
                PsiElementListNavigator.runActionAndListUpdaterTask((Disposable)popup2, () -> popup2.show(point), listUpdaterTask);
            } else {
                popup2.show(point);
            }
        }
    }

    public static void openTargets(Editor e, NavigatablePsiElement[] targets, String title, String findUsagesTitle, ListCellRenderer listRenderer) {
        PsiElementListNavigator.openTargets(e, targets, title, findUsagesTitle, listRenderer, (BackgroundUpdaterTask)null);
    }

    public static void openTargets(Editor e, NavigatablePsiElement[] targets, String title, String findUsagesTitle, ListCellRenderer listRenderer, @Nullable BackgroundUpdaterTask listUpdaterTask) {
        JBPopup popup2 = PsiElementListNavigator.navigateOrCreatePopup(targets, title, findUsagesTitle, listRenderer, listUpdaterTask);
        if (popup2 != null) {
            if (listUpdaterTask != null) {
                PsiElementListNavigator.runActionAndListUpdaterTask((Disposable)popup2, () -> popup2.showInBestPositionFor(e), listUpdaterTask);
            } else {
                popup2.showInBestPositionFor(e);
            }
        }
    }

    private static void runActionAndListUpdaterTask(@NotNull Disposable popup2, @NotNull Runnable action, @NotNull BackgroundUpdaterTask listUpdaterTask) {
        if (popup2 == null) {
            PsiElementListNavigator.$$$reportNull$$$0(0);
        }
        if (action == null) {
            PsiElementListNavigator.$$$reportNull$$$0(1);
        }
        if (listUpdaterTask == null) {
            PsiElementListNavigator.$$$reportNull$$$0(2);
        }
        Alarm alarm = new Alarm(popup2);
        alarm.addRequest(action, 300);
        ProgressManager.getInstance().run((Task)listUpdaterTask);
    }

    @Nullable
    public static JBPopup navigateOrCreatePopup(NavigatablePsiElement[] targets, String title, String findUsagesTitle, ListCellRenderer listRenderer, @Nullable BackgroundUpdaterTask listUpdaterTask) {
        return PsiElementListNavigator.navigateOrCreatePopup(targets, title, findUsagesTitle, listRenderer, listUpdaterTask, (Consumer<Object[]>)((Consumer)selectedElements -> {
            for (Object element : selectedElements) {
                PsiElement selected = (PsiElement)element;
                if (!selected.isValid()) continue;
                ((NavigatablePsiElement)selected).navigate(true);
            }
        }));
    }

    @Nullable
    public static JBPopup navigateOrCreatePopup(@NotNull NavigatablePsiElement[] targets, String title, String findUsagesTitle, ListCellRenderer listRenderer, @Nullable BackgroundUpdaterTask listUpdaterTask, @NotNull Consumer<Object[]> consumer) {
        if (targets == null) {
            PsiElementListNavigator.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            PsiElementListNavigator.$$$reportNull$$$0(4);
        }
        if (targets.length == 0) {
            return null;
        }
        if (targets.length == 1 && (listUpdaterTask == null || listUpdaterTask.isFinished())) {
            consumer.consume((Object)targets);
            return null;
        }
        List<NavigatablePsiElement> initialTargetsList = Arrays.asList(targets);
        final Ref updatedTargetsList = Ref.create((Object)targets);
        IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(initialTargetsList);
        if (listRenderer instanceof PsiElementListCellRenderer) {
            ((PsiElementListCellRenderer)listRenderer).installSpeedSearch(builder2);
        }
        IPopupChooserBuilder popupChooserBuilder = builder2.setTitle(title).setMovable(true).setFont(EditorUtil.getEditorFont()).setRenderer(listRenderer).withHintUpdateSupply().setResizable(true).setItemsChosenCallback(selectedValues -> consumer.consume((Object)ArrayUtil.toObjectArray((Collection)selectedValues))).setCancelCallback(() -> {
            if (listUpdaterTask != null) {
                listUpdaterTask.cancelTask();
            }
            return true;
        });
        Ref usageView = new Ref();
        if (findUsagesTitle != null) {
            popupChooserBuilder = popupChooserBuilder.setCouldPin(popup2 -> {
                usageView.set((Object)FindUtil.showInUsageView(null, (PsiElement[])updatedTargetsList.get(), findUsagesTitle, targets[0].getProject()));
                popup2.cancel();
                return false;
            });
        }
        JBPopup popup3 = popupChooserBuilder.createPopup();
        if (builder2 instanceof PopupChooserBuilder) {
            final JBList list2 = (JBList)((PopupChooserBuilder)builder2).getChooserComponent();
            list2.setTransferHandler(new TransferHandler(){

                @Override
                protected Transferable createTransferable(JComponent c) {
                    Object[] selectedValues = list2.getSelectedValues();
                    PsiElement[] copy = new PsiElement[selectedValues.length];
                    for (int i = 0; i < selectedValues.length; ++i) {
                        copy[i] = (PsiElement)selectedValues[i];
                    }
                    return new PsiCopyPasteManager.MyTransferable(copy);
                }

                @Override
                public int getSourceActions(JComponent c) {
                    return 1;
                }
            });
            JScrollPane pane = ((PopupChooserBuilder)builder2).getScrollPane();
            pane.setBorder(null);
            pane.setViewportBorder(null);
        }
        if (listUpdaterTask != null) {
            final ListComponentUpdater popupUpdater = builder2.getBackgroundUpdater();
            listUpdaterTask.init(popup3, new ListComponentUpdater(){

                public void replaceModel(@NotNull List<? extends PsiElement> data) {
                    if (data == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    updatedTargetsList.set((Object)data.toArray(NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY));
                    popupUpdater.replaceModel(data);
                }

                public void paintBusy(boolean paintBusy) {
                    popupUpdater.paintBusy(paintBusy);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/codeInsight/daemon/impl/PsiElementListNavigator$2", "replaceModel"));
                }
            }, (Ref<? extends UsageView>)usageView);
        }
        return popup3;
    }

    @Deprecated
    public static void openTargets(MouseEvent e, NavigatablePsiElement[] targets, String title, String findUsagesTitle, ListCellRenderer listRenderer, @Nullable ListBackgroundUpdaterTask listUpdaterTask) {
        PsiElementListNavigator.openTargets(e, targets, title, findUsagesTitle, listRenderer, (BackgroundUpdaterTask)listUpdaterTask);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listUpdaterTask";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/PsiElementListNavigator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActionAndListUpdaterTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateOrCreatePopup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

