/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.conversion;

import org.sejda.conversion.AdapterUtils;
import org.sejda.conversion.EnumUtils;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.exception.SejdaRuntimeException;
import org.sejda.model.pdf.transition.PdfPageTransition;
import org.sejda.model.pdf.transition.PdfPageTransitionStyle;

public class PdfPageTransitionAdapter {
    private static final int MIN_TOKENS = 3;
    private PdfPageTransition pdfPageTransition;

    public PdfPageTransitionAdapter(String input) {
        try {
            this.doParse(input);
        }
        catch (SejdaRuntimeException e) {
            throw new ConversionException("Unparsable transition: '" + input + "'. " + e.getMessage(), e);
        }
    }

    private void doParse(String input) {
        String[] tokens = AdapterUtils.splitAndTrim(input);
        if (tokens.length < 3) {
            throw new ConversionException("Expected format is: 'transitionType:transitionDurationInSec:pageDisplayDurationInSec'");
        }
        PdfPageTransitionStyle style = EnumUtils.valueOf(PdfPageTransitionStyle.class, tokens[0], "transition type");
        int transitionDuration = AdapterUtils.parseInt(tokens[1], "transition duration in seconds");
        int displayDuration = AdapterUtils.parseInt(tokens[2], "page display duration in seconds");
        this.pdfPageTransition = PdfPageTransition.newInstance((PdfPageTransitionStyle)style, (int)transitionDuration, (int)displayDuration);
    }

    public final PdfPageTransition getPdfPageTransition() {
        return this.pdfPageTransition;
    }
}

