/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cordova.CordovaPerformer;
import org.netbeans.modules.cordova.CordovaPlatform;
import org.netbeans.modules.cordova.project.CordovaPanel;
import org.netbeans.modules.cordova.updatetask.SourceConfig;
import org.netbeans.modules.cordova.wizard.Bundle;
import org.netbeans.modules.cordova.wizard.CordovaSetupPanel;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.spi.ProjectBrowserProvider;
import org.netbeans.modules.web.clientproject.api.ClientProjectWizardProvider;
import org.netbeans.modules.web.clientproject.spi.ClientProjectExtender;
import org.netbeans.modules.web.clientproject.spi.SiteTemplateImplementation;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class CordovaTemplate
implements SiteTemplateImplementation {
    public String getName() {
        return Bundle.LBL_Name();
    }

    public void apply(FileObject projectDir, SiteTemplateImplementation.ProjectProperties projectProperties, ProgressHandle handle) throws IOException {
        CordovaPerformer.getDefault().perform("create-hello-world", FileOwnerQuery.getOwner((FileObject)projectDir)).waitFinished();
    }

    public String getDescription() {
        return Bundle.LBL_Name();
    }

    public boolean isPrepared() {
        return CordovaPlatform.getDefault().isReady();
    }

    public void prepare() throws IOException {
        if (!CordovaPlatform.getDefault().isReady()) {
            throw new IllegalStateException(Bundle.ERR_NO_Cordova(), null);
        }
    }

    public void configure(SiteTemplateImplementation.ProjectProperties projectProperties) {
        projectProperties.setSiteRootFolder("www");
        projectProperties.setTestFolder("test");
    }

    public String getId() {
        return "CORDOVA";
    }

    public void cleanup() {
    }

    public static WizardDescriptor.InstantiatingIterator newProjectWithExtender() {
        return ClientProjectWizardProvider.newProjectWithExtender();
    }

    public static WizardDescriptor.InstantiatingIterator existingHtml5Project() {
        return ClientProjectWizardProvider.existingHtml5Project();
    }

    private static class CordovaWizardPanel
    implements WizardDescriptor.Panel<WizardDescriptor>,
    PropertyChangeListener {
        private CordovaExtender ext;
        private WizardDescriptor wizardDescriptor;
        private CordovaPanel panel;
        private final transient ChangeSupport changeSupport = new ChangeSupport((Object)this);

        public CordovaWizardPanel(CordovaExtender ext) {
            CordovaPlatform.getDefault().addPropertyChangeListener(this);
            this.ext = ext;
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        public JComponent getComponent() {
            if (this.panel == null) {
                this.panel = new CordovaPanel(this.ext);
                this.panel.addPropertyChangeListener(this);
            }
            return this.panel;
        }

        public HelpCtx getHelp() {
            return new HelpCtx("org.netbeans.modules.cordova.template.CordovaTemplate$CordovaWizardPanel");
        }

        public void readSettings(WizardDescriptor wizardDescriptor) {
            this.wizardDescriptor = wizardDescriptor;
            SiteTemplateImplementation template = (SiteTemplateImplementation)wizardDescriptor.getProperty("SITE_TEMPLATE");
            this.panel.setPanelEnabled(template instanceof CordovaTemplate);
            this.panel.setProjectName((String)wizardDescriptor.getProperty("NAME"));
            this.panel.setVersion("1.0.0");
        }

        public void storeSettings(WizardDescriptor settings) {
        }

        public boolean isValid() {
            return true;
        }

        private void setErrorMessage(String message) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)message);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.changeSupport.fireChange();
            this.panel.update();
        }

        private void save(SourceConfig c) throws IOException {
            this.panel.save(c);
        }
    }

    public static class CordovaExtender
    implements ClientProjectExtender {
        private CordovaWizardPanel panel;
        private CordovaSetupPanel initPanel;

        public WizardDescriptor.Panel<WizardDescriptor>[] createWizardPanels() {
            WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[1];
            this.panel = new CordovaWizardPanel(this);
            panelArray[0] = this.panel;
            return panelArray;
        }

        public WizardDescriptor.Panel<WizardDescriptor>[] createInitPanels() {
            if (CordovaPlatform.getDefault().isReady()) {
                return new WizardDescriptor.Panel[0];
            }
            WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[1];
            this.initPanel = new CordovaSetupPanel(null);
            panelArray[0] = this.initPanel;
            return panelArray;
        }

        public void apply(FileObject projectRoot, FileObject siteRoot, String librariesPath) {
            block5: {
                try {
                    Project project = FileOwnerQuery.getOwner((FileObject)projectRoot);
                    CordovaPerformer.getDefault().createPlatforms(project).waitFinished();
                    Preferences preferences = ProjectUtils.getPreferences((Project)project, CordovaPlatform.class, (boolean)true);
                    preferences.put("phonegap", "true");
                    CordovaExtender.setPhoneGapBrowser(project);
                    if (this.panel == null) break block5;
                    try {
                        SourceConfig config = CordovaPerformer.getConfig(project);
                        this.panel.save(config);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    CordovaPerformer.createScript(project, "plugins.properties", "nbproject/plugins.properties", true);
                    this.panel = null;
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (Throwable ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        public void initialize(WizardDescriptor wizardDescriptor) {
            wizardDescriptor.putProperty("SITE_TEMPLATE", Lookup.getDefault().lookup(CordovaTemplate.class));
            wizardDescriptor.putProperty("SITE_ROOT", (Object)"www");
        }

        public static void setPhoneGapBrowser(Project project) throws IOException, IllegalArgumentException {
            ProjectBrowserProvider browserProvider = (ProjectBrowserProvider)project.getLookup().lookup(ProjectBrowserProvider.class);
            for (WebBrowser browser : browserProvider.getBrowsers()) {
                if (browser.getBrowserFamily() != BrowserFamilyId.PHONEGAP) continue;
                if (Utilities.isMac()) {
                    if (!browser.getId().equals("ios")) continue;
                    browserProvider.setActiveBrowser(browser);
                    break;
                }
                if (!browser.getId().equals("android_1")) continue;
                browserProvider.setActiveBrowser(browser);
                break;
            }
        }
    }
}

