/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.netbeans.modules.glassfish.tooling.GlassFishIdeException;
import org.netbeans.modules.glassfish.tooling.logging.Logger;
import org.netbeans.modules.glassfish.tooling.utils.ServerUtils;

public class NetUtils {
    private static final Logger LOGGER = new Logger(ServerUtils.class);
    public static final int PORT_CHECK_TIMEOUT = 2000;
    private static final InetAddressComparator INET_ADDRESS_COMPARATOR = new InetAddressComparator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortListeningRemote(String host, int port, int timeout) {
        String METHOD = "isPortListeningRemote";
        if (null == host) {
            return false;
        }
        Socket socket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress(host, port), timeout);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.INFO, "isPortListeningRemote", "closeError", ioe.getLocalizedMessage());
                }
            }
        }
    }

    public static boolean isPortListeningRemote(String host, int port) {
        return NetUtils.isPortListeningRemote(host, port, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortListeningLocal(String host, int port) {
        String METHOD = "isPortListeningLocal";
        ServerSocket socket = null;
        try {
            InetAddress ia = InetAddress.getByName(host);
            socket = new ServerSocket(port, 1, ia);
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.INFO, "isPortListeningLocal", "closeError", ioe.getLocalizedMessage());
                }
            }
        }
    }

    public static boolean isSecurePort(String hostname, int port) throws IOException, ConnectException, SocketTimeoutException {
        return NetUtils.isSecurePort(hostname, port, 0);
    }

    private static boolean isSecurePort(String hostname, int port, int depth) throws IOException, ConnectException, SocketTimeoutException {
        String METHOD = "isSecurePort";
        boolean isSecure = true;
        try (Socket socket = new Socket();){
            block15: {
                try {
                    LOGGER.log(Level.FINE, "isSecurePort", "socket");
                    socket.connect(new InetSocketAddress(hostname, port), 2000);
                    socket.setSoTimeout(2000);
                }
                catch (SocketException ex) {
                    String socksNonProxyHosts = System.getProperty("socksNonProxyHosts");
                    if (socksNonProxyHosts == null || socksNonProxyHosts.indexOf("localhost") >= 0) break block15;
                    String localhost = socksNonProxyHosts.length() > 0 ? "|localhost" : "localhost";
                    System.setProperty("socksNonProxyHosts", socksNonProxyHosts + localhost);
                    ConnectException ce = new ConnectException();
                    ce.initCause(ex);
                    throw ce;
                }
            }
            InputStream istream = socket.getInputStream();
            String testQuery = "GET / HTTP/1.0";
            PrintWriter pw = new PrintWriter(socket.getOutputStream());
            pw.println(testQuery);
            pw.println();
            pw.flush();
            byte[] respArr = new byte[1024];
            while (istream.read(respArr) != -1) {
                String resp = new String(respArr);
                if (NetUtils.checkHelper(resp)) continue;
                isSecure = false;
                break;
            }
        }
        return isSecure;
    }

    private static boolean checkHelper(String respText) {
        boolean isSecure = true;
        if (respText.startsWith("http/1.") || respText.startsWith("HTTP/1.")) {
            isSecure = false;
        } else if (respText.contains("<html")) {
            isSecure = false;
        } else if (respText.contains("</html")) {
            isSecure = false;
        } else if (respText.contains("connection: ")) {
            isSecure = false;
        }
        return isSecure;
    }

    public static Set<InetAddress> getHostIPs() {
        String METHOD = "getHostIPs";
        TreeSet<InetAddress> addrs = new TreeSet<InetAddress>(INET_ADDRESS_COMPARATOR);
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> e = iface.getInetAddresses();
                while (e.hasMoreElements()) {
                    InetAddress a = e.nextElement();
                    addrs.add(a);
                }
            }
        }
        catch (SocketException se) {
            addrs = null;
            throw new GlassFishIdeException(LOGGER.excMsg("getHostIPs", "exception"));
        }
        return addrs;
    }

    public static Set<Inet4Address> getHostIP4s() {
        TreeSet<InetAddress> addrs = new TreeSet<InetAddress>(INET_ADDRESS_COMPARATOR);
        for (InetAddress a : NetUtils.getHostIPs()) {
            if (!(a instanceof Inet4Address)) continue;
            addrs.add((Inet4Address)a);
        }
        return addrs;
    }

    public static Set<Inet6Address> getHostIP6s() {
        TreeSet<InetAddress> addrs = new TreeSet<InetAddress>(INET_ADDRESS_COMPARATOR);
        for (InetAddress a : NetUtils.getHostIPs()) {
            if (!(a instanceof Inet6Address)) continue;
            addrs.add((Inet6Address)a);
        }
        return addrs;
    }

    public static class InetAddressComparator
    implements Comparator<InetAddress> {
        @Override
        public int compare(InetAddress ip1, InetAddress ip2) {
            byte[] addr1 = ip1.getAddress();
            byte[] addr2 = ip2.getAddress();
            int result = addr2.length - addr1.length;
            if (result == 0) {
                for (int i = 0; result == 0 && i < addr1.length; ++i) {
                    result = addr1[i] - addr2[i];
                }
            }
            return result;
        }
    }
}

