/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.mvc.annotation;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.ClientDataRequest;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.MimeResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;
import org.springframework.core.ExceptionDepthComparator;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.ui.Model;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.context.PortletWebRequest;
import org.springframework.web.portlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMethodHandlerExceptionResolver
extends AbstractHandlerExceptionResolver {
    private static final Method NO_METHOD_FOUND = ClassUtils.getMethodIfAvailable(System.class, (String)"currentTimeMillis", (Class[])null);
    private final Map<Class<?>, Map<Class<? extends Throwable>, Method>> exceptionHandlerCache = new ConcurrentHashMap(64);
    private WebArgumentResolver[] customArgumentResolvers;

    public void setCustomArgumentResolver(WebArgumentResolver argumentResolver) {
        this.customArgumentResolvers = new WebArgumentResolver[]{argumentResolver};
    }

    public void setCustomArgumentResolvers(WebArgumentResolver[] argumentResolvers) {
        this.customArgumentResolvers = argumentResolvers;
    }

    @Override
    protected ModelAndView doResolveException(PortletRequest request, MimeResponse response, Object handler, Exception ex) {
        Method handlerMethod;
        if (handler != null && (handlerMethod = this.findBestExceptionHandlerMethod(handler, ex)) != null) {
            PortletWebRequest webRequest = new PortletWebRequest(request, (PortletResponse)response);
            try {
                Object[] args = this.resolveHandlerArguments(handlerMethod, handler, webRequest, ex);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Invoking request handler method: " + handlerMethod));
                }
                Object retVal = this.doInvokeMethod(handlerMethod, handler, args);
                return this.getModelAndView(retVal);
            }
            catch (Exception invocationEx) {
                this.logger.error((Object)("Invoking request method resulted in exception : " + handlerMethod), (Throwable)invocationEx);
            }
        }
        return null;
    }

    private Method findBestExceptionHandlerMethod(Object handler, Exception thrownException) {
        Method handlerMethod;
        final Class<?> handlerType = handler.getClass();
        final Class<?> thrownExceptionType = thrownException.getClass();
        Map<Class<? extends Throwable>, Method> handlers = this.exceptionHandlerCache.get(handlerType);
        if (handlers != null) {
            handlerMethod = handlers.get(thrownExceptionType);
            if (handlerMethod != null) {
                return handlerMethod == NO_METHOD_FOUND ? null : handlerMethod;
            }
        } else {
            handlers = new ConcurrentHashMap<Class<? extends Throwable>, Method>(16);
            this.exceptionHandlerCache.put(handlerType, handlers);
        }
        final HashMap<Class<? extends Throwable>, Method> matchedHandlers = new HashMap<Class<? extends Throwable>, Method>();
        ReflectionUtils.doWithMethods(handlerType, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                method = ClassUtils.getMostSpecificMethod((Method)method, (Class)handlerType);
                List<Class<? extends Throwable>> handledExceptions = AnnotationMethodHandlerExceptionResolver.this.getHandledExceptions(method);
                for (Class<? extends Throwable> handledException : handledExceptions) {
                    if (!handledException.isAssignableFrom(thrownExceptionType)) continue;
                    if (!matchedHandlers.containsKey(handledException)) {
                        matchedHandlers.put(handledException, method);
                        continue;
                    }
                    Method oldMappedMethod = (Method)matchedHandlers.get(handledException);
                    if (oldMappedMethod.equals(method)) continue;
                    throw new IllegalStateException("Ambiguous exception handler mapped for " + handledException + "]: {" + oldMappedMethod + ", " + method + "}.");
                }
            }
        });
        handlerMethod = this.getBestMatchingMethod(matchedHandlers, thrownException);
        handlers.put(thrownExceptionType, handlerMethod == null ? NO_METHOD_FOUND : handlerMethod);
        return handlerMethod;
    }

    protected List<Class<? extends Throwable>> getHandledExceptions(Method method) {
        ArrayList<Class<? extends Throwable>> result = new ArrayList<Class<? extends Throwable>>();
        ExceptionHandler exceptionHandler = (ExceptionHandler)AnnotationUtils.findAnnotation((Method)method, ExceptionHandler.class);
        if (exceptionHandler != null) {
            if (!ObjectUtils.isEmpty((Object[])exceptionHandler.value())) {
                result.addAll(Arrays.asList(exceptionHandler.value()));
            } else {
                for (Class<?> param : method.getParameterTypes()) {
                    if (!Throwable.class.isAssignableFrom(param)) continue;
                    result.add(param);
                }
            }
        }
        return result;
    }

    private Method getBestMatchingMethod(Map<Class<? extends Throwable>, Method> resolverMethods, Exception thrownException) {
        if (resolverMethods.isEmpty()) {
            return null;
        }
        Class closestMatch = ExceptionDepthComparator.findClosestMatch(resolverMethods.keySet(), (Throwable)thrownException);
        Method method = resolverMethods.get(closestMatch);
        return method == null || NO_METHOD_FOUND == method ? null : method;
    }

    private Object[] resolveHandlerArguments(Method handlerMethod, Object handler, NativeWebRequest webRequest, Exception thrownException) throws Exception {
        Class<?>[] paramTypes = handlerMethod.getParameterTypes();
        Object[] args = new Object[paramTypes.length];
        Class<?> handlerType = handler.getClass();
        for (int i = 0; i < args.length; ++i) {
            MethodParameter methodParam = new MethodParameter(handlerMethod, i);
            GenericTypeResolver.resolveParameterType((MethodParameter)methodParam, handlerType);
            Class paramType = methodParam.getParameterType();
            Object argValue = this.resolveCommonArgument(methodParam, webRequest, thrownException);
            if (argValue == WebArgumentResolver.UNRESOLVED) {
                throw new IllegalStateException("Unsupported argument [" + paramType.getName() + "] for @ExceptionHandler method: " + handlerMethod);
            }
            args[i] = argValue;
        }
        return args;
    }

    protected Object resolveCommonArgument(MethodParameter methodParameter, NativeWebRequest webRequest, Exception thrownException) throws Exception {
        Class paramType;
        Object value;
        if (this.customArgumentResolvers != null) {
            for (WebArgumentResolver argumentResolver : this.customArgumentResolvers) {
                Object value2 = argumentResolver.resolveArgument(methodParameter, webRequest);
                if (value2 == WebArgumentResolver.UNRESOLVED) continue;
                return value2;
            }
        }
        if ((value = this.resolveStandardArgument(paramType = methodParameter.getParameterType(), webRequest, thrownException)) != WebArgumentResolver.UNRESOLVED && !ClassUtils.isAssignableValue((Class)paramType, (Object)value)) {
            throw new IllegalStateException("Standard argument type [" + paramType.getName() + "] resolved to incompatible value of type [" + (value != null ? value.getClass() : null) + "]. Consider declaring the argument type in a less specific fashion.");
        }
        return value;
    }

    protected Object resolveStandardArgument(Class<?> parameterType, NativeWebRequest webRequest, Exception thrownException) throws Exception {
        if (parameterType.isInstance(thrownException)) {
            return thrownException;
        }
        if (WebRequest.class.isAssignableFrom(parameterType)) {
            return webRequest;
        }
        PortletRequest request = (PortletRequest)webRequest.getNativeRequest(PortletRequest.class);
        PortletResponse response = (PortletResponse)webRequest.getNativeResponse(PortletResponse.class);
        if (PortletRequest.class.isAssignableFrom(parameterType)) {
            return request;
        }
        if (PortletResponse.class.isAssignableFrom(parameterType)) {
            return response;
        }
        if (PortletSession.class.isAssignableFrom(parameterType)) {
            return request.getPortletSession();
        }
        if (PortletPreferences.class.isAssignableFrom(parameterType)) {
            return request.getPreferences();
        }
        if (PortletMode.class.isAssignableFrom(parameterType)) {
            return request.getPortletMode();
        }
        if (WindowState.class.isAssignableFrom(parameterType)) {
            return request.getWindowState();
        }
        if (PortalContext.class.isAssignableFrom(parameterType)) {
            return request.getPortalContext();
        }
        if (Principal.class.isAssignableFrom(parameterType)) {
            return request.getUserPrincipal();
        }
        if (Locale.class.equals(parameterType)) {
            return request.getLocale();
        }
        if (InputStream.class.isAssignableFrom(parameterType)) {
            if (!(request instanceof ClientDataRequest)) {
                throw new IllegalStateException("InputStream can only get obtained for Action/ResourceRequest");
            }
            return ((ClientDataRequest)request).getPortletInputStream();
        }
        if (Reader.class.isAssignableFrom(parameterType)) {
            if (!(request instanceof ClientDataRequest)) {
                throw new IllegalStateException("Reader can only get obtained for Action/ResourceRequest");
            }
            return ((ClientDataRequest)request).getReader();
        }
        if (OutputStream.class.isAssignableFrom(parameterType)) {
            if (!(response instanceof MimeResponse)) {
                throw new IllegalStateException("OutputStream can only get obtained for Render/ResourceResponse");
            }
            return ((MimeResponse)response).getPortletOutputStream();
        }
        if (Writer.class.isAssignableFrom(parameterType)) {
            if (!(response instanceof MimeResponse)) {
                throw new IllegalStateException("Writer can only get obtained for Render/ResourceResponse");
            }
            return ((MimeResponse)response).getWriter();
        }
        if (Event.class.equals(parameterType)) {
            if (!(request instanceof EventRequest)) {
                throw new IllegalStateException("Event can only get obtained from EventRequest");
            }
            return ((EventRequest)request).getEvent();
        }
        return WebArgumentResolver.UNRESOLVED;
    }

    private Object doInvokeMethod(Method method, Object target, Object[] args) throws Exception {
        ReflectionUtils.makeAccessible((Method)method);
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException ex) {
            ReflectionUtils.rethrowException((Throwable)ex.getTargetException());
            throw new IllegalStateException("Should never get here");
        }
    }

    private ModelAndView getModelAndView(Object returnValue) {
        if (returnValue instanceof ModelAndView) {
            return (ModelAndView)returnValue;
        }
        if (returnValue instanceof Model) {
            return new ModelAndView().addAllObjects(((Model)returnValue).asMap());
        }
        if (returnValue instanceof Map) {
            return new ModelAndView().addAllObjects((Map)returnValue);
        }
        if (returnValue instanceof View) {
            return new ModelAndView(returnValue);
        }
        if (returnValue instanceof String) {
            return new ModelAndView((String)returnValue);
        }
        if (returnValue == null) {
            return new ModelAndView();
        }
        throw new IllegalArgumentException("Invalid handler method return value: " + returnValue);
    }
}

